/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankData;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.client.AbstractBeBankF7UI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BeBankF7UI
extends AbstractBeBankF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BeBankF7UI.class);
    private Object listData;
    protected boolean isCanceled = true;
    public static final String IS_ENABLED_MULTI_SELECTION = "isEnabledMultiSelection";
    public static final String FILTER = "filter";
    protected static final String COL_BANKNAME = "bankName";
    protected static final String COL_BANKCODE = "bankCode";
    protected static final String NAME = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"BeBankF7UIName");
    protected static final String NUMBER = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"BeBankF7UINumber");
    private Map bankMap = new HashMap();

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.buildData();
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnFastQuery_actionPerformed(ActionEvent e) throws Exception {
        this.launchQuickFilter();
    }

    @Override
    protected void kdOk_actionPerformed(ActionEvent e) throws Exception {
        this.buildData();
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    @Override
    protected void kdCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public Object getRstData() {
        return this.listData;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        this.toolBar.setVisible(false);
        this.kcoKey.addItem((Object)NAME);
        this.kcoKey.addItem((Object)NUMBER);
        this.initTable();
        FilterInfo filter = (FilterInfo)this.getUIContext().get(FILTER);
        this.fillTable(filter);
        boolean isMul = (Boolean)this.getUIContext().get(IS_ENABLED_MULTI_SELECTION);
        if (isMul) {
            this.tblMain.getSelectManager().setSelectMode(10);
        } else {
            this.tblMain.getSelectManager().setSelectMode(2);
        }
        KDTableHelper.releaseEnterAndTab((JComponent)this.tblMain);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.tblMain, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.tblMain.requestFocusInWindow();
        this.tblMain.getInputMap().remove(KeyStroke.getKeyStroke(10, 0));
        this.chkLike.setSelected(true);
    }

    private void initTable() {
        this.tblMain.checkParsed();
    }

    private void fillTable(FilterInfo filter) throws BOSException, EASBizException {
        Map resultMap = BankFacadeFactory.getRemoteInstance().syncBeBank();
        this.tblMain.removeRows(false);
        if (filter == null) {
            int k = 0;
            Set bankCodeSet = resultMap.keySet();
            Iterator iter = bankCodeSet.iterator();
            while (iter.hasNext()) {
                String bankCode = iter.next().toString();
                String bankName = resultMap.get(bankCode).toString();
                if (this.bankMap.containsKey(bankCode)) continue;
                IRow row = this.tblMain.addRow();
                row.getCell(COL_BANKCODE).setValue((Object)bankCode);
                row.getCell(COL_BANKNAME).setValue((Object)bankName);
                this.bankMap.put(bankCode, new Integer(k));
                ++k;
            }
        } else {
            FilterItemInfo filterItemInfo = filter.getFilterItems().get(0);
            String keyValue = (String)filterItemInfo.getCompareValue();
            Set bankCodeSet = resultMap.keySet();
            Iterator iter = bankCodeSet.iterator();
            while (iter.hasNext()) {
                Matcher m;
                String bankCode = iter.next().toString();
                String bankName = resultMap.get(bankCode).toString();
                boolean canAdd = false;
                String regEx = keyValue;
                Pattern p = Pattern.compile(regEx);
                if (filterItemInfo.getPropertyName().equals(NAME)) {
                    if (filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS) && bankName.equals(keyValue)) {
                        canAdd = true;
                    }
                    if (filterItemInfo.getCompareType().equals((Object)CompareType.LIKE) && (m = p.matcher(bankName)).find()) {
                        canAdd = true;
                    }
                }
                if (filterItemInfo.getPropertyName().equals(NUMBER)) {
                    if (filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS) && bankCode.equals(keyValue)) {
                        canAdd = true;
                    }
                    if (filterItemInfo.getCompareType().equals((Object)CompareType.LIKE) && (m = p.matcher(bankCode)).find()) {
                        canAdd = true;
                    }
                }
                if (!canAdd) continue;
                IRow row = this.tblMain.addRow();
                row.getCell(COL_BANKCODE).setValue((Object)bankCode);
                row.getCell(COL_BANKNAME).setValue((Object)bankName);
            }
        }
    }

    private void buildData() {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rows.length < 1) {
            this.abort();
        }
        if (this.tblMain.getRow(rows[0]) == null) {
            this.abort();
        }
        BEBankData beBank = new BEBankData();
        for (int i = 0; i < rows.length; ++i) {
            String value = (String)this.tblMain.getRow(rows[i]).getCell(0).getValue();
            String name = (String)this.tblMain.getRow(rows[i]).getCell(1).getValue();
            beBank.setBankCode(value.trim());
            beBank.setBankName(name.trim());
        }
        this.listData = beBank;
    }

    private void launchQuickFilter() throws BOSException, EASBizException {
        this.fillTable(this.getFilter(this.kcoKey.getSelectedItem().toString()));
    }

    private FilterInfo getFilter(String key) {
        String keyValue = this.txtValue.getText().trim();
        FilterInfo filter = new FilterInfo();
        if (this.chkLike.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo(key, (Object)keyValue, CompareType.LIKE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(key, (Object)keyValue, CompareType.EQUALS));
        }
        return filter;
    }
}

