/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitFilterInfoProducer;
import com.kingdee.eas.fm.be.BeServiceAddFactory;
import com.kingdee.eas.fm.be.BeServiceAddInfo;
import com.kingdee.eas.fm.be.client.AbstractBeServiceAddListUI;
import com.kingdee.eas.fm.be.client.MulBeServiceUI;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BeServiceAddListUI
extends AbstractBeServiceAddListUI {
    private static final Logger logger = CoreUIObject.getLogger(BeServiceAddListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCompanyF7(this.prmtCompany);
        this.actionLocate.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return MulBeServiceUI.class.getName();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()), "BeServiceDel");
        super.actionRemove_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()), "BeServiceAdd");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isMultiple", (Object)0, CompareType.EQUALS));
        boolean isExist = BeServiceAddFactory.getRemoteInstance().exists(filter);
        if (isExist) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"314_Mul_Tip"));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()), "BeserviceModify");
        super.actionEdit_actionPerformed(e);
    }

    protected void execQuery() {
        this.mergeFilter();
        super.execQuery();
    }

    private void mergeFilter() {
        HashSet<String> idSet = new HashSet<String>();
        FilterInfo filter = new FilterInfo();
        if (!FMHelper.isEmpty((Object)this.prmtCompany.getData())) {
            Object[] org = (Object[])this.prmtCompany.getData();
            for (int index = 0; index < org.length; ++index) {
                Object companyInfo = org[index];
                if (FMHelper.isEmpty((Object)companyInfo)) continue;
                idSet.add(((CompanyOrgUnitInfo)companyInfo).getId().toString());
            }
        }
        try {
            if (idSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("entry.company.id", idSet, CompareType.INCLUDE));
            }
            if (FMHelper.isEmpty((Object)this.mainQuery.getFilter())) {
                this.mainQuery.setFilter(filter);
            } else {
                this.mainQuery.getFilter().mergeFilter(filter, "and");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected void initCompanyF7(KDBizPromptBox bizOrgUnitBox) {
        bizOrgUnitBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        OrgUnitFilterInfoProducer iProducer = new OrgUnitFilterInfoProducer(OrgType.Company);
        if (iProducer != null) {
            bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
            if (iProducer.getModel() != null) {
                bizOrgUnitBox.setSelector((KDPromptSelector)iProducer.getModel());
                iProducer.getModel().setMultiSelect(true);
            }
        }
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
        bizOrgUnitBox.setEditFormat("$number$");
        bizOrgUnitBox.setDisplayFormat("$number$");
        bizOrgUnitBox.setEnabledMultiSelection(true);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BeServiceAddFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        BeServiceAddInfo objectValue = new BeServiceAddInfo();
        return objectValue;
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        this.mainQuery.setFilter(new FilterInfo());
        this.execQuery();
    }
}

