/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.DetailIntegralityFilterParam;
import com.kingdee.eas.fm.be.client.AbstractDetailIntegralityFilterUI;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DetailIntegralityFilterUI
extends AbstractDetailIntegralityFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DetailIntegralityFilterUI.class);
    private static final String F7_COMPANY_QUERY = "com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery";
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.beResourse";
    private Map bankInterMap = new HashMap();

    protected void init() throws Exception {
        super.init();
        this.initBankInterface();
        this.f7BankAccount.setDisplayFormat("$number$ $name$");
        this.f7BankAccount.setCommitFormat("$number$");
        this.f7BankAccount.setEditFormat("$number$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.f7BankAccount.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.chkIsDataImport.setSelected(false);
        this.cmbxBankInterface.setEnabled(true);
        FMClientHelper.initCurrency((KDComboBox)this.cmbxCurrency);
        this.cmbxCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FMClientHelper.setSelectObject((KDComboBox)this.cmbxCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        this.reSetF7BankAccountQuery();
    }

    private void reSetF7BankAccountQuery() {
        this.f7BankAccount.setData(null);
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void cmbxBankInterface_actionPerformed(ActionEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"34_AccountBankBalanceFilterUI"));
            SysUtil.abort();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)array);
        this.reSetF7BankAccountQuery();
    }

    protected void f7Company_dataChanged(DataChangeEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void f7BankAccount_willCommit(CommitEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    @Override
    protected void f7BankAccount_willShow(SelectorEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    private void initAccountBankEvi() {
        CurrencyInfo selectedCurrency;
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        Object[] companyId = this.getCompanyIds();
        if (!FMHelper.isEmpty((Object[])companyId)) {
            HashSet<Object> list = new HashSet<Object>(companyId.length);
            for (int i = 0; i < companyId.length; ++i) {
                list.add(companyId[i]);
            }
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", list, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        if (!this.chkIsDataImport.isSelected()) {
            BankInterface bankInterface;
            filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
            if (this.cmbxBankInterface.getSelectedItem() instanceof BankInterface && !FMHelper.isEmpty((String)(bankInterface = (BankInterface)this.cmbxBankInterface.getSelectedItem()).getNumber())) {
                filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)bankInterface.getNumber()));
            }
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
        }
        FilterInfo currencyFilter = new FilterInfo();
        if (this.cmbxCurrency.getSelectedItem() != null && !this.cmbxCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS) && (selectedCurrency = (CurrencyInfo)this.cmbxCurrency.getSelectedItem()) != null) {
            currencyFilter.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)new Boolean(true)));
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)selectedCurrency.getId()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)new Boolean(false)));
            currencyFilter.setMaskString("( #0 and #1 ) or #2 ");
        }
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
            filterInfo.mergeFilter(currencyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setEntityViewInfo(evi);
        this.f7BankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.cmbxBankInterface.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setSelector(this.getSelectors());
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (!FMClientHelper.isNotExistsMulBeService()) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
        }
        view.setFilter(filter);
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        int k = 0;
        this.bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (FMHelper.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.cmbxBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
        if (!this.bankInterMap.containsKey(null)) {
            BankInterface bankAcct = new BankInterface();
            bankAcct.setNumber(null);
            bankAcct.setName(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"Select_All"));
            this.cmbxBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
        }
    }

    public Object getParam() {
        DetailIntegralityFilterParam para = new DetailIntegralityFilterParam();
        Object[] acctBank = (Object[])this.f7BankAccount.getData();
        if (!EmptyUtil.isEmpty((Object[])acctBank)) {
            AccountBankInfo[] bankAccts = new AccountBankInfo[acctBank.length];
            for (int i = 0; i < acctBank.length; ++i) {
                bankAccts[i] = (AccountBankInfo)acctBank[i];
            }
            para.setBankAccts(bankAccts);
            if (acctBank != null && acctBank.length > 0) {
                HashSet<String> bankIdSet = new HashSet<String>();
                HashSet<String> companyIdSet = new HashSet<String>();
                for (int index = 0; index < acctBank.length; ++index) {
                    if (acctBank[index] == null) continue;
                    AccountBankInfo bank = (AccountBankInfo)acctBank[index];
                    bankIdSet.add(bank.getId().toString());
                    companyIdSet.add(bank.getCompany().getId().toString());
                }
                para.setBankAcctIds(bankIdSet);
                para.setCompanyId(companyIdSet.toArray(new String[0]));
            }
        } else {
            para.setBankAcctIds(null);
            para.setCompanyId(null);
        }
        if (this.cmbxCurrency.getSelectedItem() == null || !this.cmbxCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            para.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cmbxCurrency));
        }
        para.setBeginDate(this.dtpBeginDate.getSqlDate());
        para.setEndDate(this.dtpEndDate.getSqlDate());
        if (this.cmbxBankInterface.getSelectedItem() instanceof BankInterface) {
            BankInterface bankInterface = (BankInterface)this.cmbxBankInterface.getSelectedItem();
            para.setBankInterface(bankInterface.getNumber());
        } else {
            para.setBankInterface(null);
        }
        para.setIsDataImport(this.chkIsDataImport.isSelected());
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof DetailIntegralityFilterParam)) {
            return;
        }
        DetailIntegralityFilterParam para = (DetailIntegralityFilterParam)param;
        String currencyId = para.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cmbxCurrency, (Object)currencyInfo);
            } else {
                this.cmbxCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        String[] companyIds = para.getCompanyId();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        this.dtpBeginDate.setValue((Object)para.getBeginDate());
        this.dtpEndDate.setValue((Object)para.getEndDate());
        this.chkIsDataImport.setSelected(para.isIsDataImport());
        if (FMHelper.isEmpty((String)para.getBankInterface())) {
            this.cmbxBankInterface.setSelectedItem(this.cmbxBankInterface.getItemAt(this.cmbxBankInterface.getItemCount() - 1));
        } else {
            int index = (Integer)this.bankInterMap.get(para.getBankInterface());
            FMClientHelper.setSelectObject((KDComboBox)this.cmbxBankInterface, (Object)this.cmbxBankInterface.getItemAt(index));
        }
        try {
            if (para.getBankAcctIds() != null) {
                Set set = para.getBankAcctIds();
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                ev.setFilter(filter);
                AccountBankCollection coll = null;
                IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                coll = bankAcct.getAccountBankCollection(ev);
                this.f7BankAccount.setData((Object)coll.toArray());
            }
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
    }

    public boolean verify() {
        if (this.f7BankAccount.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckAccountBank"));
            SysUtil.abort();
        }
        if (this.dtpBeginDate.getSqlDate() == null) {
            this.dtpBeginDate.requestFocus(true);
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckBeginDate"));
            SysUtil.abort();
        }
        if (this.dtpEndDate.getSqlDate() == null) {
            this.dtpEndDate.requestFocus(true);
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckEndDate"));
            SysUtil.abort();
        }
        if (DateTimeUtils.truncateDate((Date)this.dtpEndDate.getSqlDate()).before(DateTimeUtils.truncateDate((Date)this.dtpBeginDate.getSqlDate()))) {
            this.dtpEndDate.requestFocus(true);
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"ChecBeginAndEndkDate"));
            SysUtil.abort();
        }
        Date curDate = DateTimeUtils.truncateDate((Date)Calendar.getInstance().getTime());
        if (DateTimeUtils.truncateDate((Date)this.dtpBeginDate.getSqlDate()).after(curDate) || DateTimeUtils.truncateDate((Date)this.dtpEndDate.getSqlDate()).after(curDate)) {
            this.dtpEndDate.requestFocus(true);
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CanNotAfterCurDate"));
            SysUtil.abort();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.dtpBeginDate.getSqlDate());
        long time1 = cal.getTimeInMillis();
        cal.setTime(this.dtpEndDate.getSqlDate());
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        int days = Integer.parseInt(String.valueOf(between_days));
        if (days > 90) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1175_DetailIntegralityFilterUI"));
            SysUtil.abort();
        }
        return true;
    }

    @Override
    protected void chkIsDataImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkIsDataImport.isSelected()) {
            this.cmbxBankInterface.setSelectedItem(this.cmbxBankInterface.getItemAt(this.cmbxBankInterface.getItemCount() - 1));
        }
    }

    public Class getParamClass() {
        return DetailIntegralityFilterParam.class;
    }
}

