/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.CollectionUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.EReceiptFilterParam;
import com.kingdee.eas.fm.be.EReceiptIsMatchEnum;
import com.kingdee.eas.fm.be.SharedAcctFacadeFactory;
import com.kingdee.eas.fm.be.client.AbstractEReceiptFilterUI;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class EReceiptFilterUI
extends AbstractEReceiptFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EReceiptFilterUI.class);
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.FmBeEReceiptRescource";
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
    private Map bankInterMap = new HashMap();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        this.beginDate.setValue((Object)DateUtil.getDayBegin());
        this.endDate.setValue((Object)DateUtil.getDayBegin());
        this.initCurrency();
        this.initBankInterface();
        this.initIsMatch();
        this.setCompany();
        this.reSetF7BankAccountQuery();
        this.btnCompanySelect.setVisible(false);
    }

    public Object getParam() {
        EReceiptFilterParam param = new EReceiptFilterParam();
        param.setBeginDate(this.beginDate.getSqlDate());
        param.setEndDate(this.endDate.getSqlDate());
        if (this.accountBank.getData() != null) {
            HashSet<String> idSet = new HashSet<String>();
            Object[] acctBank = (Object[])this.accountBank.getData();
            if (!EmptyUtil.isEmpty((Object[])acctBank)) {
                for (int i = 0; i < acctBank.length; ++i) {
                    idSet.add(((AccountBankInfo)acctBank[i]).getBankAccountNumber());
                }
                Map result = null;
                try {
                    result = SharedAcctFacadeFactory.getRemoteInstance().getSharedAcctAndCompany(idSet);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                AccountBankInfo[] acctBankInfoArry = (AccountBankInfo[])result.get("acctBank");
                String[] idStr = new String[acctBankInfoArry.length];
                for (int i = 0; i < acctBankInfoArry.length; ++i) {
                    idStr[i] = acctBankInfoArry[i].getId().toString();
                }
                param.setBankAcctId(idStr);
                String[] companyIds = (String[])result.get("companys");
                HashSet<String> companyIdSet = new HashSet<String>();
                for (int i = 0; i < companyIds.length; ++i) {
                    companyIdSet.add(companyIds[i].toString());
                }
                param.setMainOrgCollIDSet(companyIdSet);
            }
        } else {
            param.setBankAcctId(null);
        }
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl()) && EmptyUtil.isEmpty((Collection)param.getMainOrgCollIDSet())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            param.setMainOrgCollIDSet(idSet);
        }
        if (this.currency.getSelectedItem().equals(FMSysDefinedEnum.SELECT_ALL)) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(((CurrencyInfo)this.currency.getSelectedItem()).getId().toString());
        }
        if (this.bankInterface.getSelectedItem() instanceof BankInterface) {
            BankInterface bankInterface = (BankInterface)this.bankInterface.getSelectedItem();
            param.setBankInterface(bankInterface.getNumber());
        } else {
            param.setBankInterface(null);
        }
        if (this.isMatch != null) {
            if (!this.isMatch.getSelectedItem().toString().equals(FMSysDefinedEnum.SELECT_ALL.toString())) {
                param.setIsMatch((EReceiptIsMatchEnum)((Object)this.isMatch.getSelectedItem()));
            } else {
                param.setIsMatch(null);
            }
        }
        param.setImport(this.isImport.isSelected());
        return param;
    }

    public void setCompany() throws EASBizException, BOSException {
        this.company.setValue((Object)this.getCompanyOrgUnitInfoByUserPermisson());
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException {
        CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange(null, (String)"eReceipt_01View");
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo info = coll.get(i);
            if (!this.currentCompany.getId().toString().equals(info.getId().toString())) continue;
            return info;
        }
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private CompanyOrgUnitCollection getMainOrgColl() {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        Object mainBizOrgValue = this.company.getValue();
        if (mainBizOrgValue instanceof Object[]) {
            Object[] arrays = (Object[])mainBizOrgValue;
            for (int i = 0; i < arrays.length; ++i) {
                if (null == arrays[i]) continue;
                coll.add((CompanyOrgUnitInfo)arrays[i]);
            }
        } else if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
            coll.add((CompanyOrgUnitInfo)mainBizOrgValue);
        }
        return coll;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof EReceiptFilterParam)) {
            return;
        }
        EReceiptFilterParam para = (EReceiptFilterParam)param;
        String currencyId = para.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.currency, (Object)currencyInfo);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        if (!EmptyUtil.isEmpty((Collection)para.getMainOrgCollIDSet())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)para.getMainOrgCollIDSet(), CompareType.INCLUDE));
            try {
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                this.company.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.company.setValue(null);
        }
        this.beginDate.setValue((Object)para.getBeginDate());
        this.endDate.setValue((Object)para.getEndDate());
        if (FMHelper.isEmpty((String)para.getBankInterface())) {
            this.bankInterface.setSelectedItem(this.bankInterface.getItemAt(this.bankInterface.getItemCount() - 1));
        } else {
            int index = (Integer)this.bankInterMap.get(para.getBankInterface());
            FMClientHelper.setSelectObject((KDComboBox)this.bankInterface, (Object)this.bankInterface.getItemAt(index));
        }
        try {
            if (para.getBankAcctId() != null) {
                String[] bankAcctId = para.getBankAcctId();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)CollectionUtil.asSet((String[])bankAcctId), CompareType.INCLUDE));
                AccountBankCollection bankAcct = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
                this.accountBank.setData((Object)bankAcct.toArray());
            } else {
                this.accountBank.setData(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (para.getIsMatch() != null) {
            this.isMatch.setSelectedItem((Object)para.getIsMatch());
        } else {
            this.isMatch.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        }
        this.isImport.setSelected(para.isImport());
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.beginDate.setValue((Object)DateUtil.getDayBegin());
        this.endDate.setValue((Object)DateUtil.getDayBegin());
        this.accountBank.setValue(null);
        this.isMatch.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.company.setEnabledMultiSelection(true);
        try {
            this.initCurrency();
            this.initBankInterface();
            this.setCompany();
            this.reSetF7BankAccountQuery();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Class getParamClass() {
        return EReceiptFilterParam.class;
    }

    protected void initIsMatch() {
        this.isMatch.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.isMatch.addItem((Object)EReceiptIsMatchEnum.AutoMatic);
        this.isMatch.addItem((Object)EReceiptIsMatchEnum.UnMatch);
        this.isMatch.addItem((Object)EReceiptIsMatchEnum.manual);
        this.isMatch.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    private void initCurrency() throws Exception {
        FMClientHelper.initCurrency((KDComboBox)this.currency);
        FMClientHelper.setSelectObject((KDComboBox)this.currency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany));
        this.currency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.currency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.bankInterface.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setSelector(this.getSelectors());
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (!FMClientHelper.isNotExistsMulBeService()) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
        }
        view.setFilter(filter);
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        int k = 0;
        this.bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (FMHelper.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.bankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
        if (!this.bankInterMap.containsKey(null)) {
            BankInterface bankAcct = new BankInterface();
            bankAcct.setNumber(null);
            bankAcct.setName(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"Select_All"));
            this.bankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
        }
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public String getPermissionItem() {
        return "eReceipt_01View";
    }

    public KDBizPromptBox getMainOrg() {
        return this.company;
    }

    public boolean isSupportMultiOrgs() {
        return true;
    }

    public boolean verify() {
        if (this.beginDate.getSqlDate() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckBeginDate"));
            SysUtil.abort();
        }
        if (this.endDate.getSqlDate() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckEndDate"));
            SysUtil.abort();
        }
        if (DateTimeUtils.truncateDate((Date)this.endDate.getSqlDate()).before(DateTimeUtils.truncateDate((Date)this.beginDate.getSqlDate()))) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"ChecBeginAndEndkDate"));
            SysUtil.abort();
        }
        if (this.company.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckCompany"));
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    protected void bankInterface_actionPerformed(ActionEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void company_dataChanged(DataChangeEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    private void reSetF7BankAccountQuery() {
        BankInterface bankFace;
        this.accountBank.setData(null);
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", idSet, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", idSet, CompareType.INCLUDE));
        }
        if (this.bankInterface.getSelectedItem() instanceof BankInterface && !EmptyUtil.isEmpty((String)(bankFace = (BankInterface)this.bankInterface.getSelectedItem()).getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)bankFace.getNumber()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        if (!this.isImport.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("isEReceipt", (Object)new Integer(1)));
        }
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        this.accountBank.setSelectorCollection(selectors);
        this.accountBank.setEntityViewInfo(evi);
        this.accountBank.getQueryAgent().resetRuntimeEntityView();
        this.accountBank.setEnabledMultiSelection(true);
    }

    @Override
    protected void isImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.isImport.isSelected()) {
            this.bankInterface.setSelectedIndex(this.bankInterMap.size() - 1);
        } else {
            this.initBankInterface();
            this.reSetF7BankAccountQuery();
        }
    }
}

