/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptReprintCollection;
import com.kingdee.eas.fm.be.EReceiptReprintFactory;
import com.kingdee.eas.fm.be.EReceiptReprintInfo;
import com.kingdee.eas.fm.be.EReceiptWebFacadeFactory;
import com.kingdee.eas.fm.be.IEReceiptWebFacade;
import com.kingdee.eas.fm.be.client.AbstractEReceiptPrintRecordListUI;
import com.kingdee.eas.fm.be.client.EReceiptClientHelper;
import com.kingdee.eas.fm.be.client.EReceiptPrintRecordEditUI;
import com.kingdee.eas.fm.be.client.EReceiptPrintRecordFilterUI;
import com.kingdee.eas.fm.be.util.BatchBillProcessResult;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class EReceiptPrintRecordListUI
extends AbstractEReceiptPrintRecordListUI {
    private static final Logger logger = CoreUIObject.getLogger(EReceiptPrintRecordListUI.class);
    FMFilterBaseUI filterUI = null;

    public EReceiptPrintRecordListUI() throws Exception {
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionCancelAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionPrintEReceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
    }

    private void init() throws BOSException {
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionWorkFlowG.setVisible(true);
        this.actionAuditResult.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionAudit.setEnabled(true);
        this.actionCancelAudit.setEnabled(true);
        this.actionPrintEReceipt.setEnabled(true);
        this.menuWorkFlow.setVisible(true);
        this.menuItemCopyTo.setVisible(false);
    }

    protected String getEditUIName() {
        return EReceiptPrintRecordEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EReceiptReprintFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new EReceiptPrintRecordFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        this.verifyPermission(idList, "fm_be_eReceiptReprint_03Audit");
        String[] pks = new String[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pks[i] = (String)idList.get(i);
        }
        IEReceiptWebFacade facade = EReceiptWebFacadeFactory.getRemoteInstance();
        BatchBillProcessResult result = (BatchBillProcessResult)facade.banchAuditRePrintBill(pks);
        this.showMessage(result);
        this.refreshList();
    }

    private void verifyPermission(List srcList, String permission) throws Exception {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < srcList.size(); ++i) {
            String id = (String)srcList.get(i);
            set.add(id);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("company"));
        view.setFilter(fi);
        EReceiptReprintCollection colInfo = EReceiptReprintFactory.getRemoteInstance().getEReceiptReprintCollection(view);
        for (int i = 0; i < colInfo.size(); ++i) {
            EReceiptReprintInfo erInfo = colInfo.get(i);
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(erInfo.getCompany().getId().toString()), permission);
        }
    }

    @Override
    public void actionCancelAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        this.verifyPermission(idList, "fm_be_eReceiptReprint_04UnAudit");
        String[] pks = new String[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pks[i] = (String)idList.get(i);
        }
        IEReceiptWebFacade facade = EReceiptWebFacadeFactory.getRemoteInstance();
        BatchBillProcessResult result = (BatchBillProcessResult)facade.banchUnAuditRePrintBill(pks);
        this.showMessage(result);
        this.refreshList();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        this.verifyPermission(idList, "fm_be_eReceiptReprint_06Delete");
        String[] pks = new String[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pks[i] = (String)idList.get(i);
        }
        IEReceiptWebFacade facade = EReceiptWebFacadeFactory.getRemoteInstance();
        BatchBillProcessResult result = (BatchBillProcessResult)facade.banchDeleteRePrintBill(pks);
        this.showMessage(result);
        this.refreshList();
    }

    private void showMessage(BatchBillProcessResult result) {
        StringBuffer str = new StringBuffer();
        if (result.getDetailMsgList() != null) {
            for (int i = 0; i < result.getDetailMsgList().size(); ++i) {
                str.append(result.getDetailMsgList().get(i).get("info").toString());
                str.append("\r\n");
            }
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)result.get("summaryMsg").toString(), (String)str.toString(), (int)1);
        } else {
            MsgBox.showWarning((String)((String)result.get("summaryMsg")));
        }
    }

    @Override
    public void actionPrintEReceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        String id = (String)idList.get(0);
        List ereceiptList = EReceiptReprintFactory.getRemoteInstance().getEReceiptIdList(id);
        if (ereceiptList != null && ereceiptList.size() > 0) {
            EReceiptFactory.getRemoteInstance().updatePrintCount(ereceiptList, id);
            EReceiptClientHelper.printERecordReceiptByIdList(ereceiptList, (Component)((Object)this));
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(EReceiptPrintRecordListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            Object currencyId = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                String checkedStatus = (String)((BizEnumValueDTO)row.getCell("checkedStatus").getValue()).getStateManager().getStateValue("value");
                String effectedStatus = (String)((BizEnumValueDTO)row.getCell("effectedStatus").getValue()).getStateManager().getStateValue("value");
                String printStatus = (String)((BizEnumValueDTO)row.getCell("printStatus").getValue()).getStateManager().getStateValue("value");
                if (effectedStatus.equals("1")) {
                    row.getCell("status").setValue(row.getCell("effectedStatus").getValue());
                    continue;
                }
                if (effectedStatus.equals("2") && checkedStatus.equals("1")) {
                    row.getCell("status").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1224_EReceiptPrintRecordListUI"));
                    continue;
                }
                if (checkedStatus.equals("2") && printStatus.equals("1")) {
                    row.getCell("status").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1225_EReceiptPrintRecordListUI"));
                    continue;
                }
                if (!printStatus.equals("2")) continue;
                row.getCell("status").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1226_EReceiptPrintRecordListUI"));
            }
        }
    }
}

