/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptPrintRecordFactory;
import com.kingdee.eas.fm.be.EReceiptPrintRecordInfo;
import com.kingdee.eas.fm.be.EReceiptWebFacadeFactory;
import com.kingdee.eas.fm.be.IEReceipt;
import com.kingdee.eas.fm.be.IEReceiptPrintRecord;
import com.kingdee.eas.fm.be.IEReceiptWebFacade;
import com.kingdee.eas.fm.be.IPDFParser;
import com.kingdee.eas.fm.be.client.AbstractEReceiptViewUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class EReceiptViewUI
extends AbstractEReceiptViewUI {
    private static final Logger logger = CoreUIObject.getLogger(EReceiptViewUI.class);
    private IPDFParser pdfParser = null;
    private String eReceiptId = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComponents();
        this.loadImg();
    }

    private void initComponents() {
        this.btnPrintPDF.setEnabled(true);
        this.btnPrintPDF.setVisible(true);
    }

    private void loadImg() {
        Class<?> pdfParserClass = null;
        try {
            try {
                pdfParserClass = Class.forName("com.kingdee.eas.fm.common.pdfbox.PdfBoxparser");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (pdfParserClass != null) {
                this.pdfParser = (IPDFParser)pdfParserClass.newInstance();
                this.eReceiptId = (String)this.getUIContext().get("eReceiptId");
                byte[] fileValue = (byte[])this.getUIContext().get("fileValue");
                BufferedImage image = this.pdfParser.pdfToBufferImg(fileValue);
                int height = image.getHeight();
                ImageIcon icon = new ImageIcon(image);
                Dimension screenDiem = Toolkit.getDefaultToolkit().getScreenSize();
                icon.setImage(icon.getImage().getScaledInstance(screenDiem.width - 20, height, 1));
                this.imgLabel.setIcon((Icon)icon);
                this.imgLabel.setText(null);
                this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1233_EReceiptViewUI"));
                Dimension size = new Dimension(screenDiem.width - 20, screenDiem.height - 200);
                this.setPreferredSize(size);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1234_EReceiptViewUI"));
                SysUtil.abort();
            }
        }
        catch (Exception e) {
            if (pdfParserClass != null) {
                e.printStackTrace();
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1235_EReceiptViewUI"));
            }
            SysUtil.abort();
        }
    }

    @Override
    public void actionPrintPDF_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPDF_actionPerformed(e);
        if (this.checkEReceiptIsPrint()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1236_EReceiptViewUI"));
        } else if (this.pdfParser != null) {
            this.pdfParser.printPDF();
            this.savePrintRecord();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    private boolean checkEReceiptIsPrint() throws EASBizException, BOSException {
        IEReceiptWebFacade eReceiptWebFacade = EReceiptWebFacadeFactory.getRemoteInstance();
        Map map = eReceiptWebFacade.isPrint(this.eReceiptId);
        return map.get("isPrint") != null && !map.get("isPrint").toString().equals("");
    }

    private void savePrintRecord() throws BOSException {
        try {
            SelectorItemCollection sic;
            IEReceipt billBase = EReceiptFactory.getRemoteInstance();
            UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
            Date bizDate = new Date();
            SimpleDateFormat dfts = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            ObjectUuidPK pk = new ObjectUuidPK(this.eReceiptId);
            EReceiptInfo eReceiptInfo = (EReceiptInfo)billBase.getCoreBillBaseInfo((IObjectPK)pk);
            int printCount = eReceiptInfo.getPrintCount();
            if (printCount == 0) {
                eReceiptInfo.setPrintCount(++printCount);
                eReceiptInfo.setFirstPrintPerson(userInfo.getName());
                bizDate = dfts.parse(dfts.format(bizDate.getTime()));
                eReceiptInfo.setPrintDate(bizDate);
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("printDate"));
                sic.add(new SelectorItemInfo("printCount"));
                sic.add(new SelectorItemInfo("firstPrintPerson"));
                billBase.updatePartial((CoreBaseInfo)eReceiptInfo, sic);
            } else {
                eReceiptInfo.setPrintCount(++printCount);
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("printCount"));
                billBase.updatePartial((CoreBaseInfo)eReceiptInfo, sic);
            }
            IEReceiptPrintRecord eReceiptPrintRecord = EReceiptPrintRecordFactory.getRemoteInstance();
            EReceiptPrintRecordInfo info = new EReceiptPrintRecordInfo();
            info.setBizDate(bizDate);
            info.setPrintPerson(userInfo);
            info.setEreceiptId(eReceiptInfo.getId().toString());
            eReceiptPrintRecord.addnew((CoreBaseInfo)info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

