/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.CollectionUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.ElStatementFilterParam;
import com.kingdee.eas.fm.be.SharedAcctFacadeFactory;
import com.kingdee.eas.fm.be.client.AbstractElStatementBillFilterUI;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class ElStatementBillFilterUI
extends AbstractElStatementBillFilterUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ElStatementBillFilterUI.class);
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.FmBeEReceiptRescource";
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
    private Calendar cal = Calendar.getInstance();
    private Map bankInterMap = new HashMap();
    private Date startDate = new Date();
    private Date endDate = new Date();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        this.initCurrency();
        this.initBankInterface();
        this.setCompany();
        this.reSetF7BankAccountQuery();
        this.prmtCompany.setEnabledMultiSelection(true);
        this.btnCompanySelect.setVisible(false);
        FMClientHelper.manageAccountLevelRange((KDSpinner)this.spnStartYear, (KDSpinner)this.spnEndYear, (KDSpinner)this.spnStartMonth, (KDSpinner)this.spnEndMonth);
    }

    public Object getParam() {
        ElStatementFilterParam param = new ElStatementFilterParam();
        GregorianCalendar begincal = new GregorianCalendar(AccessHelper.getSpiValue((KDSpinner)this.spnStartYear), AccessHelper.getSpiValue((KDSpinner)this.spnStartMonth) - 1, 1);
        this.startDate = begincal.getTime();
        GregorianCalendar endcal = new GregorianCalendar(AccessHelper.getSpiValue((KDSpinner)this.spnEndYear), AccessHelper.getSpiValue((KDSpinner)this.spnEndMonth), 0);
        this.endDate = endcal.getTime();
        param.setStartDate(this.startDate);
        param.setEndDate(this.endDate);
        if (this.prmtBankAccount.getData() != null) {
            HashSet<String> idSet = new HashSet<String>();
            Object[] acctBank = (Object[])this.prmtBankAccount.getData();
            if (!EmptyUtil.isEmpty((Object[])acctBank)) {
                for (int i = 0; i < acctBank.length; ++i) {
                    idSet.add(((AccountBankInfo)acctBank[i]).getBankAccountNumber());
                }
                Map result = null;
                try {
                    result = SharedAcctFacadeFactory.getRemoteInstance().getSharedAcctAndCompany(idSet);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                AccountBankInfo[] acctBankInfoArry = (AccountBankInfo[])result.get("acctBank");
                String[] idStr = new String[acctBankInfoArry.length];
                for (int i = 0; i < acctBankInfoArry.length; ++i) {
                    idStr[i] = acctBankInfoArry[i].getId().toString();
                }
                param.setBankAcctId(idStr);
                String[] companyIds = (String[])result.get("companys");
                param.setCompanyId(companyIds);
            }
        } else {
            param.setBankAcctId(null);
        }
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl()) && EmptyUtil.isEmpty((Object[])param.getCompanyId())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            String[] idStr = new String[coll.size()];
            for (int i = 0; i < coll.size(); ++i) {
                idStr[i] = coll.get(i).getId().toString();
            }
            param.setCompanyId(idStr);
        }
        if (this.comboCurrency.getSelectedItem().equals(FMSysDefinedEnum.SELECT_ALL)) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        }
        if (this.comboBankInterface.getSelectedItem() instanceof BankInterface) {
            BankInterface bankInterface = (BankInterface)this.comboBankInterface.getSelectedItem();
            param.setBankInterface(bankInterface.getNumber());
        } else {
            param.setBankInterface(null);
        }
        if (this.chkIsClosed.isSelected()) {
            param.setClosed(true);
        } else {
            param.setClosed(false);
        }
        if (this.chkImport.isSelected()) {
            param.setImport(true);
        } else {
            param.setImport(false);
        }
        return param;
    }

    public void setCompany() throws EASBizException, BOSException {
        this.prmtCompany.setValue((Object)this.getCompanyOrgUnitInfoByUserPermisson());
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException {
        CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange(null, (String)"elstatement_01query");
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo info = coll.get(i);
            if (!this.currentCompany.getId().toString().equals(info.getId().toString())) continue;
            return info;
        }
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private CompanyOrgUnitCollection getMainOrgColl() {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        Object mainBizOrgValue = this.prmtCompany.getValue();
        if (mainBizOrgValue instanceof Object[]) {
            Object[] arrays = (Object[])mainBizOrgValue;
            for (int i = 0; i < arrays.length; ++i) {
                if (null == arrays[i]) continue;
                coll.add((CompanyOrgUnitInfo)arrays[i]);
            }
        } else if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
            coll.add((CompanyOrgUnitInfo)mainBizOrgValue);
        }
        return coll;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof ElStatementFilterParam)) {
            return;
        }
        ElStatementFilterParam para = (ElStatementFilterParam)param;
        String currencyId = para.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currencyInfo);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        if (!EmptyUtil.isEmpty((Object[])para.getCompanyId())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])para.getCompanyId()), CompareType.INCLUDE));
            try {
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                this.prmtCompany.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.prmtCompany.setValue(null);
        }
        this.cal.setTime(para.getStartDate());
        int startYear = this.cal.get(1);
        SpinnerNumberModel yModel = new SpinnerNumberModel(startYear, 2000, 2999, 1);
        this.spnStartYear.setModel((SpinnerModel)yModel);
        int startMonth = this.cal.get(2) + 1;
        SpinnerNumberModel mModel = new SpinnerNumberModel(startMonth, 1, 12, 1);
        this.spnStartMonth.setModel((SpinnerModel)mModel);
        this.cal.setTime(para.getEndDate());
        int endYear = this.cal.get(1);
        SpinnerNumberModel yModel1 = new SpinnerNumberModel(endYear, 2000, 2999, 1);
        this.spnEndYear.setModel((SpinnerModel)yModel1);
        int endMonth = this.cal.get(2) + 1;
        SpinnerNumberModel mModel1 = new SpinnerNumberModel(endMonth, 1, 12, 1);
        this.spnEndMonth.setModel((SpinnerModel)mModel1);
        if (FMHelper.isEmpty((String)para.getBankInterface())) {
            this.comboBankInterface.setSelectedItem(this.comboBankInterface.getItemAt(this.comboBankInterface.getItemCount() - 1));
        } else {
            int index = (Integer)this.bankInterMap.get(para.getBankInterface());
            FMClientHelper.setSelectObject((KDComboBox)this.comboBankInterface, (Object)this.comboBankInterface.getItemAt(index));
        }
        try {
            if (para.getBankAcctId() != null) {
                String[] bankAcctId = para.getBankAcctId();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)CollectionUtil.asSet((String[])bankAcctId), CompareType.INCLUDE));
                AccountBankCollection bankAcct = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
                this.prmtBankAccount.setData((Object)bankAcct.toArray());
            } else {
                this.prmtBankAccount.setData(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (para.isClosed()) {
            this.chkIsClosed.setSelected(true);
        } else {
            this.chkIsClosed.setSelected(false);
        }
        if (para.isImport()) {
            this.chkImport.setSelected(true);
        } else {
            this.chkImport.setSelected(false);
        }
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        FMClientHelper.initSpinFromTO((KDSpinner)this.spnStartYear, (KDSpinner)this.spnStartMonth, (KDSpinner)this.spnEndYear, (KDSpinner)this.spnEndMonth);
        GregorianCalendar begincal = new GregorianCalendar(AccessHelper.getSpiValue((KDSpinner)this.spnStartYear), AccessHelper.getSpiValue((KDSpinner)this.spnStartMonth) - 1, 1);
        this.startDate = begincal.getTime();
        GregorianCalendar endcal = new GregorianCalendar(AccessHelper.getSpiValue((KDSpinner)this.spnEndYear), AccessHelper.getSpiValue((KDSpinner)this.spnEndMonth), 0);
        this.endDate = endcal.getTime();
        this.prmtBankAccount.setValue(null);
        try {
            this.initCurrency();
            this.initBankInterface();
            this.setCompany();
            this.reSetF7BankAccountQuery();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Class getParamClass() {
        return ElStatementFilterParam.class;
    }

    private void initCurrency() throws Exception {
        FMClientHelper.initCurrency((KDComboBox)this.comboCurrency);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany));
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.comboBankInterface.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setSelector(this.getSelectors());
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (!FMClientHelper.isNotExistsMulBeService()) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
        }
        view.setFilter(filter);
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        int k = 0;
        this.bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (FMHelper.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.comboBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
        if (!this.bankInterMap.containsKey(null)) {
            BankInterface bankAcct = new BankInterface();
            bankAcct.setNumber(null);
            bankAcct.setName(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"Select_All"));
            this.comboBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
        }
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public String getPermissionItem() {
        return "elstatement_01query";
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public boolean isSupportMultiOrgs() {
        return true;
    }

    public boolean verify() {
        if (DateTimeUtils.truncateDate((Date)this.endDate).before(DateTimeUtils.truncateDate((Date)this.startDate))) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"ChecBeginAndEndkDate"));
            SysUtil.abort();
        }
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckCompany"));
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    protected void bankInterface_actionPerformed(ActionEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void company_dataChanged(DataChangeEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void chkIsClosed_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtBankAccount.setValue(null);
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void chkImport_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkImport.isSelected()) {
            for (int i = 0; i < this.comboBankInterface.getItemCount(); ++i) {
                BankInterface bankAcct = (BankInterface)this.comboBankInterface.getItemAt(i);
                if (null != bankAcct.getNumber()) continue;
                this.comboBankInterface.setSelectedIndex(i);
                break;
            }
        }
    }

    private void reSetF7BankAccountQuery() {
        BankInterface bankFace;
        this.prmtBankAccount.setData(null);
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", idSet, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", idSet, CompareType.INCLUDE));
        }
        if (this.comboBankInterface.getSelectedItem() instanceof BankInterface && !EmptyUtil.isEmpty((String)(bankFace = (BankInterface)this.comboBankInterface.getSelectedItem()).getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)bankFace.getNumber()));
        }
        if (!this.chkIsClosed.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        this.prmtBankAccount.setSelectorCollection(selectors);
        this.prmtBankAccount.setEntityViewInfo(evi);
        this.prmtBankAccount.getQueryAgent().resetRuntimeEntityView();
        this.prmtBankAccount.setEnabledMultiSelection(true);
    }
}

