/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.FixedMutualFactory;
import com.kingdee.eas.fm.be.FixedMutualInfo;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.IFixedMutual;
import com.kingdee.eas.fm.be.RegularFixTransInfo;
import com.kingdee.eas.fm.be.client.AbstractFixedMutualListUI;
import com.kingdee.eas.fm.be.client.BankPayingBillUpdateStateUI;
import com.kingdee.eas.fm.be.client.FixedMutualEditUI;
import com.kingdee.eas.fm.be.client.FixedMutualFilterParam;
import com.kingdee.eas.fm.be.client.FixedMutualFilterUI;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class FixedMutualListUI
extends AbstractFixedMutualListUI {
    private static final Logger logger = CoreUIObject.getLogger(FixedMutualListUI.class);
    private static final String resourcePath = "com.kingdee.eas.fm.be.beResourse";
    private IKDTablePrecisionFormater currencyPrecisionFormater = new DefaultKDTablePrecisionFormater();
    private FixedMutualFilterUI filterUI;

    public FixedMutualListUI() throws Exception {
        this.currencyPrecisionFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider("currency.id"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    protected String getEditUIName() {
        return FixedMutualEditUI.class.getName();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            IFixedMutual pay = FixedMutualFactory.getRemoteInstance();
            FixedMutualInfo info = pay.getFixedMutualInfo((IObjectPK)new ObjectUuidPK(id));
            if ((info.getStatus() == BankPayingBillStateEnum.OF || info.getStatus() == BankPayingBillStateEnum.TF) && info.isFightBack()) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Fixed_remove"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionBitBack_actionPerformed(ActionEvent e) throws Exception {
        super.actionBitBack_actionPerformed(e);
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            IFixedMutual pay = FixedMutualFactory.getRemoteInstance();
            FixedMutualInfo info = pay.getFixedMutualInfo((IObjectPK)new ObjectUuidPK(id));
            if ((info.getStatus() == BankPayingBillStateEnum.OF || info.getStatus() == BankPayingBillStateEnum.TF) && !info.isFightBack()) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Fixed_back"));
            return;
        }
        IObjectPK[] pks = new IObjectPK[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            pks[i] = new ObjectUuidPK(ids.get(i).toString());
        }
        IFixedMutual pay = FixedMutualFactory.getRemoteInstance();
        pay.bitBack(pks);
        FMClientHelper.showSuccessInfo((CoreUI)this, (ItemAction)this.actionBitBack);
        this.refreshList();
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        if (i >= 0) {
            BizEnumValueInfo srcBillType = (BizEnumValueInfo)this.tblMain.getRow(i).getCell("businessType").getValue();
            Object value = this.tblMain.getRow(i).getCell("srcBillId").getValue();
            if (value == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"37_BankAgentPayBillListUI"));
                return;
            }
            String billId = value.toString();
            if (billId != null) {
                CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                FMClientHelper.viewDetailBill((CoreUIObject)this, (String)billId, (CompanyOrgUnitInfo)company);
            }
        } else {
            this.setMessageText(EASResource.getString((String)resourcePath, (String)"SelectOneRow"));
            this.showMessage();
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new FixedMutualFilterUI();
        }
        return this.filterUI;
    }

    public void onLoad() throws Exception {
        this.currencyPrecisionFormater.init(this.getMainTable(), new String[]{"amount", "solutionInterest"});
        super.onLoad();
        this.resetVisible();
        this.tblMain.getColumn("interestDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected IObjectValue createNewData() {
        FixedMutualInfo info = new FixedMutualInfo();
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FixedMutualFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        super.initWorkButton();
        this.actionBitBack.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fclose"));
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionEditState.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_modifyattribute"));
        this.actionSyncStateByBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_synchronization"));
        boolean isBizUnit = GlUtils.isCompanyUnion((CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        if (isBizUnit) {
            this.actionBitBack.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionViewDetail.setVisible(false);
        }
    }

    private void resetVisible() {
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
    }

    protected IRow appendFootRow() {
        IRow footRow = super.appendFootRow();
        if (footRow != null) {
            String[] numberCols = new String[]{"amount", "solutionInterest"};
            int[] numberColsPrecision = new int[]{2, 2};
            if (this.getUIContext().get("BTPEDITPARAMETER") == null) {
                for (int i = 0; i < numberCols.length; ++i) {
                    this.tblMain.getFootRow(0).getCell(numberCols[i]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)numberColsPrecision[i]));
                }
            }
        }
        return footRow;
    }

    public void executeQuery(FilterParam param) throws BOSException {
        FixedMutualFilterParam para = (FixedMutualFilterParam)param;
        super.executeQuery((FilterParam)para);
    }

    @Override
    public void actionEditState_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        int result;
        this.checkSelected();
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        int state = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("status").getValue()).getInt();
        if (state != 4) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"editState_FixedMutualListUI"));
            SysUtil.abort();
        }
        ArrayList idList = this.getSelectedIdValues();
        UIContext uiContext = new UIContext((Object)this);
        String uiName = BankPayingBillUpdateStateUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        BankPayingBillStateEnum updateState = ((BankPayingBillUpdateStateUI)uiWindow.getUIObject()).getResult();
        if (updateState == null) {
            return;
        }
        if (updateState == BankPayingBillStateEnum.TF && (result = MsgBox.showConfirm2((Component)((Object)this), (String)(msg = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"41_BankAgentPayBillListUI")))) == 2) {
            SysUtil.abort();
        }
        IObjectPK[] pks = new IObjectPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pks[i] = new ObjectUuidPK(idList.get(i).toString());
        }
        IFixedMutual iFixedMutual = FixedMutualFactory.getRemoteInstance();
        boolean flag = iFixedMutual.updateState(pks, updateState);
        if (flag) {
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (ActionEvent)e);
            this.refresh(e);
        }
    }

    @Override
    public void actionSyncStateByBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        String id = (String)idList.get(0);
        IFixedMutual pay = FixedMutualFactory.getRemoteInstance();
        FixedMutualInfo info = pay.getFixedMutualInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.getStatus() == BankPayingBillStateEnum.OP || info.getStatus() == BankPayingBillStateEnum.TS || info.getStatus() == BankPayingBillStateEnum.TF) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"syn_FixedMutualListUI"));
            return;
        }
        RegularFixTransInfo regularBizInfo = new RegularFixTransInfo();
        regularBizInfo.setCurrentAccNo(info.getAccountCode());
        regularBizInfo.setFixedAccNo(info.getRecBankAccount().getBankAccountNumber());
        String saveTerm = info.getSaveTerm();
        regularBizInfo.setDepositTermValue(Integer.parseInt(saveTerm));
        regularBizInfo.setDepositTermUnit(info.getTermUnit().getValue());
        regularBizInfo.setNextDepositType(String.valueOf(info.getRenewFlag().getValue()));
        if (!EmptyUtil.isEmpty((String)info.getNextTerm())) {
            regularBizInfo.setNextDepositTermValue(Integer.parseInt(info.getNextTerm()));
        }
        if (!EmptyUtil.isEmpty((Object)((Object)info.getNextTermUnit()))) {
            regularBizInfo.setNextDepositTermUnit(info.getNextTermUnit().getValue());
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isoCode"));
        CurrencyInfo oldCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()), sic);
        if (oldCurrency == null) {
            throw new BEException(BEException.CURRENCYISERROR, new Object[]{" "});
        }
        String currencyCode = " ";
        currencyCode = "RMB".equalsIgnoreCase(oldCurrency.getIsoCode()) ? "CNY" : oldCurrency.getIsoCode().toUpperCase();
        regularBizInfo.setCurrency(currencyCode);
        regularBizInfo.setAmount(String.valueOf(info.getAmount()));
        IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
        try {
            bankFacade.syncFixedMatualStateByBill(regularBizInfo, info);
        }
        catch (Exception e1) {
            this.setMessageText(EASResource.getString((String)resourcePath, (String)"SyncFailure"));
            this.showMessage();
            SysUtil.abort();
        }
        this.actionRefresh_actionPerformed(e);
        this.setMessageText(EASResource.getString((String)resourcePath, (String)"SyncSucess"));
        this.showMessage();
    }
}

