/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.OpenAreaFactory;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.fm.be.client.AbstractOpenAreaEditUI;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class OpenAreaEditUI
extends AbstractOpenAreaEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OpenAreaEditUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.comboBankInterface.getSelectedItem() != null) {
            this.editData.setBankInterFaceid(((BankInterface)this.comboBankInterface.getSelectedItem()).getNumber());
            this.editData.setBankInterfaceName(((BankInterface)this.comboBankInterface.getSelectedItem()).getName());
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        boolean canEditBankInterface = OprtState.ADDNEW.equals(this.getOprtState()) || FMHelper.isEmpty((String)this.editData.getBankInterFaceid());
        this.comboBankInterface.setEnabled(canEditBankInterface);
        if (!canEditBankInterface) {
            BankInterface info = new BankInterface();
            info.setName(this.editData.getBankInterfaceName());
            info.setNumber(this.editData.getBankInterFaceid());
            this.comboBankInterface.addItem((Object)info);
            this.comboBankInterface.setSelectedItem((Object)info);
        } else {
            try {
                this.comboBankInterface.removeAllItems();
                this.initBankInterface();
                this.comboBankInterface.setSelectedItem(null);
            }
            catch (Exception e) {
                MsgBox.showError((String)e.getMessage());
            }
        }
    }

    public boolean isModify() {
        return super.isModify();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
    }

    @Override
    protected IObjectValue createNewData() {
        OpenAreaInfo info = new OpenAreaInfo();
        info.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return info;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.chkdifBank.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionSave.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return OpenAreaFactory.getRemoteInstance();
    }

    private void initBankInterface() throws EASBizException, BOSException {
        Object[] bankCert = BankFacadeFactory.getRemoteInstance().getBankCert("", "");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < bankCert.length; ++i) {
            BankInterface info = (BankInterface)bankCert[i];
            if (info.getName().indexOf("-") >= 0) {
                info.setName(info.getName().substring(0, info.getName().indexOf("-")));
            }
            if (set.contains(info.getName())) continue;
            this.comboBankInterface.addItem((Object)info);
            set.add(info.getName());
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bankInterfaceType"));
        sic.add(new SelectorItemInfo("deptID"));
        sic.add(new SelectorItemInfo("province"));
        sic.add(new SelectorItemInfo("unionCode"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("difBank"));
        sic.add(new SelectorItemInfo("bankInterfaceName"));
        sic.add(new SelectorItemInfo("bankInterFaceid"));
        return sic;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankInterfaceName", (Object)((BankInterface)this.comboBankInterface.getSelectedItem()).getName()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.txtNumber.getStringValue()));
        filter.getFilterItems().add(new FilterItemInfo("province", (Object)this.txtProvince.getStringValue()));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)this.txtName.getStringValue()));
        if (OpenAreaFactory.getRemoteInstance().exists(filter) && "ADDNEW".equals(this.oprtState)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"342_OpenAreaEditUI"));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
    }
}

