/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.OpenAreaCollection;
import com.kingdee.eas.fm.be.OpenAreaFactory;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.fm.be.client.AbstractOpenAreaUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class OpenAreaUI
extends AbstractOpenAreaUI {
    private static final Logger logger = CoreUIObject.getLogger(OpenAreaUI.class);
    private static String resourcePath = "com.kingdee.eas.fm.be.client.BankInterfaceResource";
    private OpenAreaCollection areas;
    private BankInterfaceTypeEnum curBankInterfaceType;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.areas = new OpenAreaCollection();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            OpenAreaInfo area = (OpenAreaInfo)row.getUserObject();
            area.setNumber((String)row.getCell("number").getValue());
            area.setDeptID((String)row.getCell("deptId").getValue());
            area.setProvince((String)row.getCell("province").getValue());
            area.setUnionCode((String)row.getCell("unionCode").getValue());
            Object objName = row.getCell("name").getValue();
            String sName = null;
            if (objName instanceof MultiLangItem) {
                MultiLangItem mlItem = (MultiLangItem)objName;
                sName = (String)mlItem.getData();
                area.setName(sName, mlItem.getLang().getLocale());
            } else {
                sName = (String)objName;
                area.setName(sName);
            }
            if (sName != null && sName.trim().length() > 0) {
                sName = sName.trim();
                area.setName(sName, LocaleUtils.locale_l1);
                area.setName(sName, LocaleUtils.locale_l2);
                area.setName(sName, LocaleUtils.locale_l3);
            }
            this.areas.add(area);
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        this.tblMain.addRow().setUserObject((Object)this.createNewData());
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (i == 0) {
                row.getCell("interfaceType").setValue((Object)this.curBankInterfaceType);
                continue;
            }
            row.getCell("interfaceType").setValue(null);
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        this.tblMain.addRow(index).setUserObject((Object)this.createNewData());
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (i == 0) {
                row.getCell("interfaceType").setValue((Object)this.curBankInterfaceType);
                continue;
            }
            row.getCell("interfaceType").setValue(null);
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(index);
        if (row != null) {
            String areaCode = (String)row.getCell("number").getValue();
            this.checkOpenAreaIsUse(areaCode, this.curBankInterfaceType);
        }
        this.tblMain.removeRow(index);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            if (i == 0) {
                row.getCell("interfaceType").setValue((Object)this.curBankInterfaceType);
                continue;
            }
            row.getCell("interfaceType").setValue(null);
        }
    }

    private void checkOpenAreaIsUse(String areaCode, BankInterfaceTypeEnum bankInterface) throws EASBizException, BOSException {
        FilterInfo fi = new FilterInfo();
        if (areaCode == null) {
            return;
        }
        fi.getFilterItems().add(new FilterItemInfo("openArea.number", (Object)areaCode));
        fi.getFilterItems().add(new FilterItemInfo("bankInterfaceType", (Object)new Integer(bankInterface.getValue())));
        boolean isUsed = AccountBankFactory.getRemoteInstance().exists(fi);
        if (isUsed) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"76_OpenAreaUI"));
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        this.storeFields();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankInterfaceType", (Object)new Integer(this.curBankInterfaceType.getValue())));
        OpenAreaFactory.getRemoteInstance().delete(filter);
        for (int i = 0; i < this.areas.size(); ++i) {
            OpenAreaFactory.getRemoteInstance().submit((CoreBaseInfo)this.areas.get(i));
        }
        this.showSubmitSuccess();
        this.setAreaList(this.curBankInterfaceType);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected IObjectValue createNewData() {
        OpenAreaInfo info = new OpenAreaInfo();
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OpenAreaFactory.getRemoteInstance();
    }

    public void setAreaList(BankInterfaceTypeEnum bankInterface) throws BOSException {
        if (bankInterface == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bankInterfaceType", (Object)new Integer(bankInterface.getValue())));
        view.getSorter().add(new SorterItemInfo("number"));
        this.areas = OpenAreaFactory.getRemoteInstance().getOpenAreaCollection(view);
        this.tblMain.removeRows();
        int size = this.areas.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.addRow();
            OpenAreaInfo openAreaInfo = this.areas.get(i);
            row.setUserObject((Object)openAreaInfo);
            if (i == 0) {
                row.getCell("interfaceType").setValue((Object)bankInterface);
            }
            row.getCell("name").setValue((Object)openAreaInfo.getName());
            row.getCell("province").setValue((Object)openAreaInfo.getProvince());
            row.getCell("unionCode").setValue((Object)openAreaInfo.getUnionCode());
            row.getCell("number").setValue((Object)openAreaInfo.getNumber());
            row.getCell("deptId").setValue((Object)openAreaInfo.getDeptID());
            row.getCell("number").getStyleAttributes().setLocked(true);
        }
    }

    public void onLoad() throws Exception {
        this.resetOprState();
        this.tblMain.checkParsed();
        this.tblMain.getColumn(0).getStyleAttributes().setLocked(true);
        KDTextField txtField = new KDTextField();
        this.tblMain.setActiveCellStatus(1);
        txtField.setMaxLength(70);
        this.tblMain.getColumn("number").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField));
        KDTextField txtField2 = new KDTextField();
        txtField2.setMaxLength(20);
        this.tblMain.getColumn("deptId").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField2));
        KDTextField mbName = new KDTextField();
        mbName.setMaxLength(70);
        this.tblMain.getColumn("name").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)mbName));
        KDTextField mbprovince = new KDTextField();
        mbprovince.setMaxLength(70);
        this.tblMain.getColumn("province").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)mbprovince));
        KDTextField mbunionCode = new KDTextField();
        mbunionCode.setMaxLength(70);
        this.tblMain.getColumn("unionCode").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)mbunionCode));
        super.onLoad();
        this.cboBankInterface.addItems(BankInterfaceTypeEnum.getEnumList().toArray());
        this.curBankInterfaceType = (BankInterfaceTypeEnum)this.getUIContext().get("bankInterface");
        if (this.curBankInterfaceType == null) {
            this.curBankInterfaceType = BankInterfaceTypeEnum.ABC;
        }
        FMClientHelper.setSelectObject((KDComboBox)this.cboBankInterface, (Object)this.curBankInterfaceType);
        this.setAreaList(this.curBankInterfaceType);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        KDTableHelper.updateEnterWithTab((KDTable)this.tblMain, (boolean)false);
    }

    private void resetOprState() {
        this.setOprtState(OprtState.ADDNEW);
    }

    @Override
    protected void cboBankInterface_actionPerformed(ActionEvent e) throws Exception {
        BankInterfaceTypeEnum bankInterface = (BankInterfaceTypeEnum)this.cboBankInterface.getSelectedItem();
        if (bankInterface == null || this.curBankInterfaceType == null) {
            return;
        }
        if (this.curBankInterfaceType.equals((Object)bankInterface)) {
            return;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.actionSubmit_actionPerformed(null);
            } else if (result == 2) {
                FMClientHelper.setSelectObject((KDComboBox)this.cboBankInterface, (Object)this.curBankInterfaceType);
                SysUtil.abort();
            }
        }
        this.curBankInterfaceType = bankInterface;
        this.setAreaList(bankInterface);
        super.cboBankInterface_actionPerformed(e);
    }

    public boolean isModify() {
        if (this.areas == null && this.tblMain.getRowCount() != 0) {
            return true;
        }
        if (this.areas != null && this.tblMain.getRowCount() != this.areas.size()) {
            return true;
        }
        if (this.areas != null) {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                String name = null;
                Object objName = row.getCell("name").getValue();
                if (objName instanceof MultiLangItem) {
                    MultiLangItem mlItem = (MultiLangItem)objName;
                    name = (String)mlItem.getData();
                } else {
                    name = (String)objName;
                }
                if (name == null) {
                    return true;
                }
                if (!name.equals(this.areas.get(i).getName())) {
                    return true;
                }
                String number = (String)row.getCell("number").getValue();
                if (number == null) {
                    return true;
                }
                if (number.equals(this.areas.get(i).getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("name").getValue() == null || row.getCell("name").getValue().toString().trim().length() == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NameNoNull"));
                FMClientHelper.setSelectObject((KDComboBox)this.cboBankInterface, (Object)this.curBankInterfaceType);
                SysUtil.abort();
            }
            if (row.getCell("number").getValue() == null || row.getCell("number").getValue().toString().trim().length() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"NumberNoNull"));
                FMClientHelper.setSelectObject((KDComboBox)this.cboBankInterface, (Object)this.curBankInterfaceType);
                SysUtil.abort();
            }
            if (row.getCell("deptId").getValue() != null && row.getCell("deptId").getValue().toString().trim().length() != 0) continue;
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"DeptIdNoNull"));
            FMClientHelper.setSelectObject((KDComboBox)this.cboBankInterface, (Object)this.curBankInterfaceType);
            SysUtil.abort();
        }
        super.verifyInput(e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionPageSetup.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionLast.setVisible(false);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnImportData.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.actionImportData.setEnabled(true);
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        if (this.getImportParam() != null) {
            task.invoke(this.getImportParam(), 0, false);
        }
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.be.openArea";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"75_OpenAreaListUI");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }
}

