/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.RegularDetailFilterParam;
import com.kingdee.eas.fm.be.client.AbstractRegularDetailFilterUI;
import com.kingdee.eas.fm.be.client.BEClientHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class RegularDetailFilterUI
extends AbstractRegularDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RegularDetailFilterUI.class);
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.beResourse";
    private Map bankInterMap = new HashMap();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        this.initBankInterface();
        FMClientHelper.initCurrency((KDComboBox)this.cmbxCurrency);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FMClientHelper.setSelectObject((KDComboBox)this.cmbxCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        this.reSetF7BankAccountQuery();
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.cmbxBankInterface.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setSelector(this.getSelectors());
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (!FMClientHelper.isNotExistsMulBeService()) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
        }
        view.setFilter(filter);
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        int k = 0;
        this.bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (FMHelper.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.cmbxBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
        if (!this.bankInterMap.containsKey(null)) {
            this.cmbxBankInterface.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
            this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
        }
    }

    private void reSetF7BankAccountQuery() {
        BankInterface bankInterface;
        this.f7BankAccount.setData(null);
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        Object[] companyId = this.getCompanyIds();
        if (!EmptyUtil.isEmpty((Object[])companyId)) {
            HashSet<Object> list = new HashSet<Object>(companyId.length);
            for (int i = 0; i < companyId.length; ++i) {
                list.add(companyId[i]);
            }
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", list, CompareType.INCLUDE));
        }
        if (this.cmbxBankInterface.getSelectedItem() instanceof BankInterface && !EmptyUtil.isEmpty((String)(bankInterface = (BankInterface)this.cmbxBankInterface.getSelectedItem()).getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)bankInterface.getNumber()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setDisplayFormat("$number$ $name$");
        this.f7BankAccount.setCommitFormat("$number$");
        this.f7BankAccount.setEditFormat("$number$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.f7BankAccount.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.f7BankAccount.setEntityViewInfo(evi);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"34_AccountBankBalanceFilterUI"));
            SysUtil.abort();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
        this.reSetF7BankAccountQuery();
    }

    protected void f7Company_dataChanged(DataChangeEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void cmbxBankInterface_actionPerformed(ActionEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    @Override
    protected void rdbIsOnline_stateChanged(ChangeEvent e) throws Exception {
        super.rdbIsOnline_stateChanged(e);
        if (this.rdbIsOnline.isSelected()) {
            if (this.bankInterMap.containsKey(null)) {
                this.cmbxBankInterface.removeItem((Object)FMSysDefinedEnum.SELECT_ALL);
                this.bankInterMap.remove(null);
            }
            this.rdbIsOffline.setSelected(false);
        } else {
            if (!this.bankInterMap.containsKey(null)) {
                this.cmbxBankInterface.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
                this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
            }
            this.rdbIsOffline.setSelected(true);
        }
    }

    @Override
    protected void rdbIsOffline_stateChanged(ChangeEvent e) throws Exception {
        if (this.rdbIsOffline.isSelected()) {
            if (!this.bankInterMap.containsKey(null)) {
                this.cmbxBankInterface.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
                this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
            }
            this.rdbIsOnline.setSelected(false);
        } else {
            if (this.bankInterMap.containsKey(null)) {
                this.cmbxBankInterface.removeItem((Object)FMSysDefinedEnum.SELECT_ALL);
                this.bankInterMap.remove(null);
            }
            this.rdbIsOnline.setSelected(true);
        }
    }

    public Object getParam() {
        RegularDetailFilterParam para = new RegularDetailFilterParam();
        para.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cmbxCurrency));
        para.setBankAcctIds(AccessHelper.getF7Ids((KDBizPromptBox)this.f7BankAccount));
        String[] companyIds = this.getCompanyIds();
        para.setCompanyId(companyIds);
        para.setBeginDate(this.dtpBeginDate.getSqlDate());
        para.setEndDate(this.dtpEndDate.getSqlDate());
        if (this.rdbIsOnline.isSelected()) {
            para.setOnLine(true);
        } else {
            para.setOnLine(false);
        }
        if (this.cmbxBankInterface.getSelectedItem() instanceof BankInterface) {
            BankInterface bankInterface = (BankInterface)this.cmbxBankInterface.getSelectedItem();
            para.setBankInterface(bankInterface.getNumber());
            para.setBankInterfaceName(bankInterface.getName());
        } else {
            para.setBankInterface(null);
        }
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof RegularDetailFilterParam)) {
            return;
        }
        RegularDetailFilterParam para = (RegularDetailFilterParam)param;
        String currencyId = para.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cmbxCurrency, (Object)currencyInfo);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        String[] companyIds = para.getCompanyId();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        this.dtpBeginDate.setValue((Object)para.getBeginDate());
        this.dtpEndDate.setValue((Object)para.getEndDate());
        if (para.isOnLine()) {
            this.rdbIsOnline.setSelected(true);
        } else {
            this.rdbIsOffline.setSelected(true);
        }
        if (EmptyUtil.isEmpty((String)para.getBankInterface())) {
            this.cmbxBankInterface.setSelectedItem(this.cmbxBankInterface.getItemAt(this.cmbxBankInterface.getItemCount() - 1));
        } else {
            int index = (Integer)this.bankInterMap.get(para.getBankInterface());
            FMClientHelper.setSelectObject((KDComboBox)this.cmbxBankInterface, (Object)this.cmbxBankInterface.getItemAt(index));
        }
        try {
            if (para.getBankAcctIds() != null) {
                Set set = FMHelper.asSet((String[])para.getBankAcctIds());
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                ev.setFilter(filter);
                AccountBankCollection coll = null;
                IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                coll = bankAcct.getAccountBankCollection(ev);
                this.f7BankAccount.setData((Object)coll.toArray());
            }
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
    }

    public boolean verify() {
        if (this.f7BankAccount.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckAccountBank"));
            SysUtil.abort();
        }
        return BEClientHelper.verifyDate((Component)((Object)this), this.dtpBeginDate, this.dtpEndDate);
    }

    private void initF7BankAccount() {
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
        try {
            CompanyOrgUnitInfo clearingHouse = FSClientHelper.getClearingHouseCompany();
            if (clearingHouse != null && !clearingHouse.getId().equals((Object)curCompany.getId())) {
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)curCompany.getId()));
            }
        }
        catch (Exception e1) {
            SysUtil.abort();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setDisplayFormat("$name$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.f7BankAccount.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.f7BankAccount.setEntityViewInfo(evi);
    }

    protected Class getParamClass() {
        return RegularDetailFilterParam.class;
    }
}

