/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.RegularDetailFactory;
import com.kingdee.eas.fm.be.RegularDetailFilterParam;
import com.kingdee.eas.fm.be.RegularDetailInfo;
import com.kingdee.eas.fm.be.client.AbstractRegularDetailListUI;
import com.kingdee.eas.fm.be.client.RegularDetailFilterUI;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class RegularDetailListUI
extends AbstractRegularDetailListUI {
    private static final Logger logger = CoreUIObject.getLogger(RegularDetailListUI.class);
    private RegularDetailFilterUI filterUI;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RegularDetailFilterUI();
        }
        return this.filterUI;
    }

    protected String getEditUIName() {
        return null;
    }

    protected IObjectValue createNewData() {
        RegularDetailInfo info = new RegularDetailInfo();
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RegularDetailFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.tblMain.getColumn("openDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("closeDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    public void setCurrencyFormat(KDTable tblMain, RegularDetailFilterParam param) {
        String numberFtm = param.getCurrencyId() == null ? "%r-[ ]{###,###,##0.00}15.2n" : FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)param.getCurrencyId()));
        String numberInt = "%r-[ ]{###,###,##0.0000}13.4n";
        String numberTerm = "%r-[ ]{###,###,##0}13.0n";
        tblMain.getColumn("bankAcnt.number").getStyleAttributes().setNumberFormat("@");
        tblMain.getColumn("bankAcnt.bankAccountNumber").getStyleAttributes().setNumberFormat("@");
        tblMain.getColumn("saveTerm").getStyleAttributes().setNumberFormat(numberTerm);
        tblMain.getColumn("nextTerm").getStyleAttributes().setNumberFormat(numberTerm);
        tblMain.getColumn("amount").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("closeInt").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("totalInt").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("rate").getStyleAttributes().setNumberFormat(numberInt);
        tblMain.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("closeInt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("totalInt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void executeQuery(FilterParam param) throws BOSException {
        RegularDetailFilterParam para = (RegularDetailFilterParam)param;
        this.setCurrencyFormat(this.tblMain, para);
        if (para.isOnLine()) {
            IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
            try {
                Map rst = bankFacade.getRegularDetails(para.getCurrencyId(), para.getBankInterface(), para.getBankInterfaceName(), para.getBankAcctIds(), para.getBeginDate(), para.getEndDate());
                if (rst != null && rst.size() > 0) {
                    MsgBox.showInfo((String)rst.toString());
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"79_TransDetailListUI"));
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"OnLineSearchError"), e.getMessage());
                MsgBox.showInfo((Component)((Object)this), (String)msgStr);
                SysUtil.abort();
            }
        }
        super.executeQuery(param);
        this.formatFootRow();
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    protected boolean isFootVisible() {
        return true;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            RegularDetailFilterParam param = (RegularDetailFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : param.getCurrencyId();
            String[] columns = new String[]{"amount", "closeInt", "totalInt"};
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"company.name", "bankAcnt.number", " bankAcnt.bankAccountNumber", "bankAcnt.name", "amount"};
        return locateNames;
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dlg = super.getQueryDlg();
        dlg.setWidth(586);
        return dlg;
    }
}

