/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.AbstractBankAcntRelationInfo;
import com.kingdee.eas.fm.be.BankAcntRelationCollection;
import com.kingdee.eas.fm.be.BankAcntRelationEntryCollection;
import com.kingdee.eas.fm.be.BankAcntRelationFactory;
import com.kingdee.eas.fm.be.BankAcntRelationInfo;
import com.kingdee.eas.fm.be.VirtualDetailDisplayTypeEnum;
import com.kingdee.eas.fm.be.client.AbstractRptVirtualDetailFilterUI;
import com.kingdee.eas.fm.be.client.RptVirtualDetailParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class RptVirtualDetailFilterUI
extends AbstractRptVirtualDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptVirtualDetailFilterUI.class);
    private RptVirtualDetailParam param = null;
    public static final String F7_BANK_ACNT_RELATION_QUERY = "com.kingdee.eas.fm.be.BankAcntRelationQuery";
    private static String resourcePath = "com.kingdee.eas.fm.be.BankAcntRelationResource";

    public Object getParam() {
        Object[] info;
        if (this.param == null) {
            this.param = new RptVirtualDetailParam();
        }
        if (EmptyUtil.isEmpty((Object[])(info = (Object[])this.prmtBankInterfaceType.getValue()))) {
            this.param.setBankAcntRelation(null);
        } else {
            String[] bankacntInfo = new String[info.length];
            for (int i = 0; i < info.length; ++i) {
                bankacntInfo[i] = ((BankAcntRelationInfo)info[i]).getId().toString();
            }
            this.param.setBankAcntRelation(bankacntInfo);
        }
        List bankAcntList = this.getbankAcntId(info);
        this.param.setBankAcctId(bankAcntList);
        String bankInterFaceType = this.getBankInterfaceType(info);
        this.param.setBankInterFaceType(bankInterFaceType);
        this.param.setBizDate(this.kDDate.getSqlDate());
        VirtualDetailDisplayTypeEnum dispalyEnum = (VirtualDetailDisplayTypeEnum)((Object)this.kDComboBoxDisplayType.getSelectedItem());
        this.param.setDisplayType(dispalyEnum.getValue());
        CurrencyInfo currency = (CurrencyInfo)this.kDComboCurrency.getSelectedItem();
        this.param.setCurrency(currency);
        return this.param;
    }

    private String getBankInterfaceType(Object[] info) {
        if (info == null || info.length == 0 || info.length == 1 && info[0] == null) {
            return "''";
        }
        StringBuffer sbBankInterfaceType = new StringBuffer();
        BankAcntRelationInfo tmp = null;
        for (int i = 0; i < info.length; ++i) {
            tmp = (BankAcntRelationInfo)info[i];
            if (sbBankInterfaceType.length() == 0) {
                sbBankInterfaceType.append("'" + tmp.getBankInterFace() + "'");
                continue;
            }
            sbBankInterfaceType.append(",'" + tmp.getBankInterFace() + "'");
        }
        return sbBankInterfaceType.toString();
    }

    private List getbankAcntId(Object[] info) {
        ArrayList<String> list = new ArrayList<String>();
        if (info == null || info.length == 0 || info.length == 1 && info[0] == null) {
            return list;
        }
        AbstractBankAcntRelationInfo tmpInfo = null;
        BankAcntRelationInfo tmp = null;
        for (int i = 0; i < info.length; ++i) {
            try {
                tmp = (BankAcntRelationInfo)info[i];
                tmpInfo = BankAcntRelationFactory.getRemoteInstance().getBankAcntRelationInfo((IObjectPK)new ObjectUuidPK(tmp.getId().toString()), this.getSelectors());
            }
            catch (EASBizException e) {
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort();
            }
            catch (BOSException e) {
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort();
            }
            if (tmpInfo.getFirstAcnt() != null) {
                list.add(tmpInfo.getFirstAcnt().getId().toString());
            }
            if (tmpInfo.getSecondOverAcnt() != null) {
                list.add(tmpInfo.getSecondOverAcnt().getId().toString());
            }
            BankAcntRelationEntryCollection entry = tmpInfo.getSecondAcnt();
            for (int j = 0; j < entry.size(); ++j) {
                list.add(entry.get(j).getBankAcntID().getId().toString());
            }
        }
        return list;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("bankInterfaceType"));
        sic.add(new SelectorItemInfo("firstAcnt.id"));
        sic.add(new SelectorItemInfo("secondOverAcnt.id"));
        sic.add(new SelectorItemInfo("bankOverAccountType"));
        sic.add(new SelectorItemInfo("overPer"));
        sic.add(new SelectorItemInfo("secondAcnt.id"));
        sic.add(new SelectorItemInfo("secondAcnt.BankAcntID"));
        sic.add(new SelectorItemInfo("secondAcnt.bankAcntID.id"));
        sic.add(new SelectorItemInfo("bankOverAccount"));
        sic.add(new SelectorItemInfo("bankInterfaceTypeName"));
        sic.add(new SelectorItemInfo("bankInterFace"));
        return sic;
    }

    public void setParam(Object param) {
        this.param = (RptVirtualDetailParam)((Object)param);
        this.prmtBankInterfaceType.setValue((Object)this.getBankAcntRelation(this.param.getBankAcntRelation()));
        this.kDComboCurrency.setSelectedItem((Object)this.param.getCurrency());
        this.kDDate.setValue((Object)this.param.getBizDate());
        this.kDComboBoxDisplayType.setSelectedIndex(this.param.getDisplayType());
    }

    protected void setDefaultValue() {
        this.prmtBankInterfaceType.setValue(null);
        CashHelper.initCombCurrency((KDComboBox)this.kDComboCurrency, (boolean)false);
        this.kDComboBoxDisplayType.addItem((Object)VirtualDetailDisplayTypeEnum.displayTotal);
        this.kDComboBoxDisplayType.addItem((Object)VirtualDetailDisplayTypeEnum.dispalyDetail);
        this.kDComboBoxDisplayType.addItem((Object)VirtualDetailDisplayTypeEnum.displayNone);
        this.kDDate.setValue((Object)new Date());
        this.kDComboBoxDisplayType.removeAllItems();
        this.kDComboBoxDisplayType.addItem((Object)VirtualDetailDisplayTypeEnum.displayTotal);
        this.kDComboBoxDisplayType.addItem((Object)VirtualDetailDisplayTypeEnum.dispalyDetail);
        this.kDComboBoxDisplayType.addItem((Object)VirtualDetailDisplayTypeEnum.displayNone);
    }

    private Object[] getBankAcntRelation(String[] bankAcntRelation) {
        if (EmptyUtil.isEmpty((Object[])bankAcntRelation)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < bankAcntRelation.length; ++i) {
            if (bankAcntRelation[i].length() <= 0) continue;
            set.add(bankAcntRelation[i]);
        }
        if (set.size() == 0) {
            return null;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        BankAcntRelationCollection coll = null;
        try {
            coll = BankAcntRelationFactory.getRemoteInstance().getBankAcntRelationCollection(view);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        if (EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            return null;
        }
        return coll.toArray();
    }

    public void init() throws EASBizException, BOSException {
        this.initF7BankInferfaceType();
        CashHelper.initCombCurrency((KDComboBox)this.kDComboCurrency, (boolean)false);
        this.kDComboBoxDisplayType.addItem((Object)VirtualDetailDisplayTypeEnum.displayTotal);
        this.kDComboBoxDisplayType.addItem((Object)VirtualDetailDisplayTypeEnum.dispalyDetail);
        this.kDComboBoxDisplayType.addItem((Object)VirtualDetailDisplayTypeEnum.displayNone);
    }

    private void initF7BankInferfaceType() {
        this.prmtBankInterfaceType.setData(null);
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        boolean val = ContextHelperFactory.getRemoteInstance().getBooleanParam("BE003", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (!(EmptyUtil.isEmpty((CoreBaseInfo)company) || !val && GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany))) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("hasEffected", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.prmtBankInterfaceType.setDisplayFormat("$bankInterFace$");
        this.prmtBankInterfaceType.setCommitFormat("$bankInterFace$");
        this.prmtBankInterfaceType.setEditFormat("$bankInterFace$");
        this.prmtBankInterfaceType.setEnabledMultiSelection(true);
        this.prmtBankInterfaceType.setQueryInfo(F7_BANK_ACNT_RELATION_QUERY);
        this.prmtBankInterfaceType.setEntityViewInfo(evi);
    }

    public boolean verify() {
        Object[] info = (Object[])this.prmtBankInterfaceType.getValue();
        if (info == null || info.length == 0 || info.length == 1 && info[0] == null) {
            this.showWarning(EASResource.getString((String)resourcePath, (String)"BankInterfaceType"));
            return false;
        }
        return true;
    }

    private void showWarning(String resName) {
        MsgBox.showWarning((String)resName);
        SysUtil.abort();
    }

    protected Class getParamClass() {
        return RptVirtualDetailParam.class;
    }
}

