/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.be.BankLevelEnum;
import com.kingdee.eas.fm.be.client.RptVirtualDetailParam;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;

public class RptVirtualDetailHandler
extends FMDetailRptBaseHandler
implements IFMDetailRptHandler {
    private static final String RPT_TIME_DEPOSIT_HANDLER_ADAPTER = "30_RptTimeDepositHandlerAdapter";
    RptVirtualDetailParam param = null;
    private static final String TDSOURCE_PATH = "com.kingdee.eas.fm.be.VirtualDetailResource";
    private static final String TDAUTO_GENERATE_PATH = "com.kingdee.eas.fm.td.TDAutoGenerateResource";
    private int precisionLocalCurrency = 2;
    private static final String FLD_BANKINTERFACETYPE = "BankInterfaceType";
    private static final String FLD_PREBALANCE = "PREBALANCE";
    private static final String FLD_BALANCE = "BALANCE";
    private static final String FLD_CHANGEBALANCE = "CHANGEBALANCE";
    private static final String FLD_OVERDRAFTLIMIT = "OVERDRAFTLIMIT";
    private static final String FLD_INOVERDRAFTLIMIT = "INOVERDRAFTLIMIT";
    private static final String FLD_OVERUSELIMIT = "OVERUSELIMIT";
    private static final String FLD_OVERUNUSELIMIT = "OVERUNUSELIMIT";
    private static final String FLD_BANKLIMIT = "BANKLIMIT";
    private static final String FLD_USEBANKLIMIT = "USEBANKLIMIT";
    private static final String FLD_UNUSEBANKLIMIT = "UNUSEBANKLIMIT";
    private static final String FLD_ALLDRAFLIMIT = "ALLDRAFLIMIT";
    private static final String FLD_ALLUSELIMIT = "ALLUSELIMIT";
    private static final String FLD_BANKTYPE = "BANKTYPE";
    private static final String FLD_BANKACNTNUMBER = "BANKACNTNUMBER";
    private static final String FLD_BANKACNTNAME = "BANKACNTNAME";
    private static final String FLD_COMPANYNAME = "COMPANYNAME";
    private static final String FLD_COMPANYNUMBER = "COMPANYNUMBER";
    private static final String KSQL_RPTVIRTUAL_FIELD = "BANKACNT.FbankAccountNumber AS BANKACNTNUMBER, BANKACNT.FName_{0} AS BANKACNTNAME, \nCOMPANY.FNUMBER AS COMPANYNUMBER, COMPANY.FName_{0} AS COMPANYNAME, \nVIRTUALDETAIL.FPrebalance AS PREBALANCE, VIRTUALDETAIL.FBalance AS BALANCE, \nVIRTUALDETAIL.FChangeBalance AS CHANGEBALANCE, VIRTUALDETAIL.FOverdraftLimit AS OVERDRAFTLIMIT, \nVIRTUALDETAIL.FInOverdraftLimit AS INOVERDRAFTLIMIT, VIRTUALDETAIL.FOverUseLimit AS OVERUSELIMIT, \nVIRTUALDETAIL.FOverUnuseLimit AS OVERUNUSELIMIT, VIRTUALDETAIL.FBankLimit AS BANKLIMIT, \nVIRTUALDETAIL.FUseBankLimit AS USEBANKLIMIT, VIRTUALDETAIL.FUnuseBankLimit AS UNUSEBANKLIMIT, \nVIRTUALDETAIL.FAllDrafLimit AS ALLDRAFLIMIT, VIRTUALDETAIL.FAllUseLimit AS ALLUSELIMIT ";
    private static final String KSQL_RPTVIRTUAL_SUM_FIELD = "max(BANKACNT.FbankAccountNumber) AS BANKACNTNUMBER, max(BANKACNT.FName_{0}) AS BANKACNTNAME, \nmax(COMPANY.FNUMBER) AS COMPANYNUMBER, max(COMPANY.FName_{0}) AS COMPANYNAME, \nsum(VIRTUALDETAIL.FPrebalance) AS PREBALANCE, sum(VIRTUALDETAIL.FBalance) AS BALANCE,\nsum(VIRTUALDETAIL.FChangeBalance) AS CHANGEBALANCE, sum(VIRTUALDETAIL.FOverdraftLimit) AS OVERDRAFTLIMIT,\nsum(VIRTUALDETAIL.FInOverdraftLimit) AS INOVERDRAFTLIMIT, sum(VIRTUALDETAIL.FOverUseLimit) AS OVERUSELIMIT, \nsum(VIRTUALDETAIL.FOverUnuseLimit) AS OVERUNUSELIMIT, sum(VIRTUALDETAIL.FBankLimit) AS BANKLIMIT,\nsum(VIRTUALDETAIL.FUseBankLimit) AS USEBANKLIMIT, sum(VIRTUALDETAIL.FUnuseBankLimit) AS UNUSEBANKLIMIT, \nsum(VIRTUALDETAIL.FAllDrafLimit) AS ALLDRAFLIMIT, sum(VIRTUALDETAIL.FAllUseLimit) AS ALLUSELIMIT ";
    private static final String KSQL_RPTVIRTUAL_DATA = "SELECT BANKACNT.FBankInterFace AS BankInterfaceType, VIRTUALDETAIL.FBankType AS BANKTYPE, \n{0} \nFROM T_BE_VirtualDetail AS VIRTUALDETAIL LEFT OUTER JOIN T_BD_AccountBanks AS BANKACNT ON VIRTUALDETAIL.FBankAcnt = BANKACNT.FID \nLEFT OUTER JOIN T_ORG_Company AS COMPANY ON VIRTUALDETAIL.FCompanyID = COMPANY.FID \nWHERE BANKACNT.FBankInterFace IN ({1}) \nAND VIRTUALDETAIL.FVirtualDate >= {2} AND VIRTUALDETAIL.FVirtualDate < {3} \nAND VIRTUALDETAIL.FCURRENCY = ''{4}'' \nAND VIRTUALDETAIL.FBankAcnt IN ({5}) \n{6} ORDER BY FBankInterface, FBANKTYPE, COMPANYNUMBER ASC";
    private static final String KSQL_GROUPBY_FIELD = "GROUP BY FBankInterface, FBANKTYPE \n";
    private static final String KSQL_BANKTYPE_FILTER = "AND VIRTUALDETAIL.FBankType IN (0, 1) \n";

    public RptVirtualDetailHandler(FilterInfo filterInfo, KDTable kdt, RptVirtualDetailParam param) {
        super(filterInfo, kdt);
        this.param = param;
    }

    protected String getQueryPath() {
        return "";
    }

    private void setRowExpressionsSum(IRow row, String fieldName) {
        row.getCell(fieldName).setExpressions("SUM");
    }

    private void setMoneyRowExpressionsSum(IRow row) {
        this.setRowExpressionsSum(row, FLD_PREBALANCE);
        this.setRowExpressionsSum(row, FLD_BALANCE);
        this.setRowExpressionsSum(row, FLD_CHANGEBALANCE);
        if (this.param.getDisplayType() == 2) {
            this.setRowExpressionsSum(row, FLD_OVERDRAFTLIMIT);
        }
        this.setRowExpressionsSum(row, FLD_INOVERDRAFTLIMIT);
        this.setRowExpressionsSum(row, FLD_OVERUSELIMIT);
        this.setRowExpressionsSum(row, FLD_OVERUNUSELIMIT);
        this.setRowExpressionsSum(row, FLD_BANKLIMIT);
        this.setRowExpressionsSum(row, FLD_USEBANKLIMIT);
        this.setRowExpressionsSum(row, FLD_UNUSEBANKLIMIT);
        this.setRowExpressionsSum(row, FLD_ALLDRAFLIMIT);
        this.setRowExpressionsSum(row, FLD_ALLUSELIMIT);
    }

    private void setSubTotalRow() {
        IRow subtotalRow = this.kdt.getGroupManager().getStatRowTemplate(0);
        subtotalRow.getStyleAttributes().setBackground(new Color(16119270));
        subtotalRow.getCell(FLD_BANKINTERFACETYPE).setValue((Object)EASResource.getString((String)TDAUTO_GENERATE_PATH, (String)RPT_TIME_DEPOSIT_HANDLER_ADAPTER));
        this.setMoneyRowExpressionsSum(subtotalRow);
    }

    private void setRowSummation() {
        IRow summationRow = this.kdt.getGroupManager().getStatRowTemplate(-1);
        summationRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        summationRow.getCell(FLD_BANKINTERFACETYPE).setValue((Object)EASResource.getString((String)TDAUTO_GENERATE_PATH, (String)"31_RptTimeDepositHandlerAdapter"));
        this.setMoneyRowExpressionsSum(summationRow);
    }

    public void setTableStateRow() {
        this.kdt.getColumn(FLD_BANKINTERFACETYPE).setStat(true);
        this.setSubTotalRow();
        this.setRowSummation();
    }

    public IRowSet getRowSet() throws BOSException {
        return SQLExecutorFactory.getRemoteInstance((String)this.getDetailSQL()).executeSQL();
    }

    private String getDetailSQL() {
        Object[] bankAcntId = this.param.getBankAcctId().toArray();
        StringBuffer sbTmp = new StringBuffer();
        if (!EmptyUtil.isEmpty((Object[])bankAcntId)) {
            for (int i = 0; i < bankAcntId.length; ++i) {
                if (sbTmp.length() > 0) {
                    sbTmp.append(",");
                }
                sbTmp.append("'").append(bankAcntId[i].toString()).append("'");
            }
        } else {
            sbTmp.append("''");
        }
        StringBuffer filterBuff = new StringBuffer("");
        String fields = null;
        Object[] args1 = new Object[]{SysContext.getSysContext().getLocale().toString()};
        switch (this.param.getDisplayType()) {
            case 0: {
                fields = MessageFormat.format(KSQL_RPTVIRTUAL_SUM_FIELD, args1);
                filterBuff.append(KSQL_GROUPBY_FIELD);
                break;
            }
            case 1: {
                fields = MessageFormat.format(KSQL_RPTVIRTUAL_FIELD, args1);
                break;
            }
            case 2: {
                fields = MessageFormat.format(KSQL_RPTVIRTUAL_FIELD, args1);
                filterBuff.append(KSQL_BANKTYPE_FILTER);
                break;
            }
            default: {
                fields = MessageFormat.format(KSQL_RPTVIRTUAL_SUM_FIELD, args1);
                filterBuff.append(KSQL_GROUPBY_FIELD);
            }
        }
        StringBuffer beginDate = new StringBuffer("{");
        beginDate.append(FMConstants.FORMAT_TIME.format(this.param.getBizDate())).append("}");
        StringBuffer endDate = new StringBuffer("{");
        endDate.append(FMConstants.FORMAT_TIME.format(DateTimeUtils.addDay((Date)this.param.getBizDate(), (long)1L)));
        endDate.append("}");
        Object[] args2 = new Object[]{fields, this.param.getBankInterFaceType(), beginDate.toString(), endDate.toString(), this.param.getCurrency().getId().toString(), sbTmp.toString(), filterBuff.toString()};
        return MessageFormat.format(KSQL_RPTVIRTUAL_DATA, args2);
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
        this.kdt.setRefresh(false);
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            String name = rs.getObject(FLD_BANKINTERFACETYPE).toString();
            row.getCell(FLD_BANKINTERFACETYPE).setValue((Object)name);
            Integer bankType = new Integer(rs.getObject(FLD_BANKTYPE).toString());
            name = BankLevelEnum.getEnum(bankType).toString();
            row.getCell(FLD_BANKTYPE).setValue((Object)name);
            if (this.param.getDisplayType() == 0 && bankType == 2) {
                row.getCell(FLD_BANKACNTNUMBER).setValue((Object)"");
                row.getCell(FLD_BANKACNTNAME).setValue((Object)"");
                row.getCell(FLD_COMPANYNUMBER).setValue((Object)"");
                row.getCell(FLD_COMPANYNAME).setValue((Object)"");
            } else {
                row.getCell(FLD_BANKACNTNUMBER).setValue(rs.getObject(FLD_BANKACNTNUMBER));
                row.getCell(FLD_BANKACNTNAME).setValue(rs.getObject(FLD_BANKACNTNAME));
                row.getCell(FLD_COMPANYNUMBER).setValue(rs.getObject(FLD_COMPANYNUMBER));
                row.getCell(FLD_COMPANYNAME).setValue(rs.getObject(FLD_COMPANYNAME));
            }
            row.getCell(FLD_PREBALANCE).setValue(rs.getObject(FLD_PREBALANCE));
            row.getCell(FLD_BALANCE).setValue(rs.getObject(FLD_BALANCE));
            row.getCell(FLD_CHANGEBALANCE).setValue(rs.getObject(FLD_CHANGEBALANCE));
            row.getCell(FLD_OVERDRAFTLIMIT).setValue(rs.getObject(FLD_OVERDRAFTLIMIT));
            row.getCell(FLD_INOVERDRAFTLIMIT).setValue(rs.getObject(FLD_INOVERDRAFTLIMIT));
            row.getCell(FLD_OVERUSELIMIT).setValue(rs.getObject(FLD_OVERUSELIMIT));
            row.getCell(FLD_OVERUNUSELIMIT).setValue(rs.getObject(FLD_OVERUNUSELIMIT));
            row.getCell(FLD_BANKLIMIT).setValue(rs.getObject(FLD_BANKLIMIT));
            row.getCell(FLD_USEBANKLIMIT).setValue(rs.getObject(FLD_USEBANKLIMIT));
            row.getCell(FLD_UNUSEBANKLIMIT).setValue(rs.getObject(FLD_UNUSEBANKLIMIT));
            row.getCell(FLD_ALLDRAFLIMIT).setValue(rs.getObject(FLD_ALLDRAFLIMIT));
            row.getCell(FLD_ALLUSELIMIT).setValue(rs.getObject(FLD_ALLUSELIMIT));
        }
    }

    public void initHeader() {
        super.initHeader();
        this.initTable();
    }

    private void initTable() {
        this.kdt.getGroupManager().setTotalize(true);
        this.initCustomHeader();
    }

    private void addColumn(String fieldName) {
        IColumn preBalance = this.kdt.addColumn();
        preBalance.setKey(fieldName);
    }

    private void addMoneyColumn(String fieldName) {
        IColumn moneyColumn = this.kdt.addColumn();
        moneyColumn.setKey(fieldName);
        this.formatCol(moneyColumn, this.precisionLocalCurrency);
    }

    private void addCustomRow() {
        IColumn bankInterfaceType = this.kdt.addColumn();
        bankInterfaceType.setKey(FLD_BANKINTERFACETYPE);
        bankInterfaceType.setGroup(true);
        this.addColumn(FLD_BANKTYPE);
        this.addColumn(FLD_BANKACNTNUMBER);
        this.addColumn(FLD_BANKACNTNAME);
        this.addColumn(FLD_COMPANYNUMBER);
        this.addColumn(FLD_COMPANYNAME);
        this.addMoneyColumn(FLD_PREBALANCE);
        this.addMoneyColumn(FLD_BALANCE);
        this.addMoneyColumn(FLD_CHANGEBALANCE);
        this.addMoneyColumn(FLD_OVERDRAFTLIMIT);
        this.addMoneyColumn(FLD_INOVERDRAFTLIMIT);
        this.addMoneyColumn(FLD_OVERUSELIMIT);
        this.addMoneyColumn(FLD_OVERUNUSELIMIT);
        this.addMoneyColumn(FLD_BANKLIMIT);
        this.addMoneyColumn(FLD_USEBANKLIMIT);
        this.addMoneyColumn(FLD_UNUSEBANKLIMIT);
        this.addMoneyColumn(FLD_ALLDRAFLIMIT);
        this.addMoneyColumn(FLD_ALLUSELIMIT);
    }

    private void setHeadRowTitle() {
        IRow rowH = this.kdt.addHeadRow();
        rowH.getCell(FLD_BANKINTERFACETYPE).setValue((Object)this.getResString("rpt_virtual_bankInterfaceType"));
        rowH.getCell(FLD_BANKTYPE).setValue((Object)this.getResString("rpt_virtual_bankType"));
        rowH.getCell(FLD_BANKACNTNUMBER).setValue((Object)this.getResString("rpt_virtual_bankAcntNumber"));
        rowH.getCell(FLD_BANKACNTNAME).setValue((Object)this.getResString("rpt_virtual_bankAcntName"));
        rowH.getCell(FLD_COMPANYNUMBER).setValue((Object)this.getResString("rpt_virtual_companynumber"));
        rowH.getCell(FLD_COMPANYNAME).setValue((Object)this.getResString("rpt_virtual_companyname"));
        rowH.getCell(FLD_PREBALANCE).setValue((Object)this.getResString("rpt_virtual_preBalance"));
        rowH.getCell(FLD_BALANCE).setValue((Object)this.getResString("rpt_virtual_balance"));
        rowH.getCell(FLD_CHANGEBALANCE).setValue((Object)this.getResString("rpt_virtual_changeBalance"));
        rowH.getCell(FLD_OVERDRAFTLIMIT).setValue((Object)this.getResString("rpt_virtual_overdraftLimit"));
        rowH.getCell(FLD_INOVERDRAFTLIMIT).setValue((Object)this.getResString("rpt_virtual_inOverdraftLimit"));
        rowH.getCell(FLD_OVERUSELIMIT).setValue((Object)this.getResString("rpt_virtual_overUseLimit"));
        rowH.getCell(FLD_OVERUNUSELIMIT).setValue((Object)this.getResString("rpt_virtual_overUnuseLimit"));
        rowH.getCell(FLD_BANKLIMIT).setValue((Object)this.getResString("rpt_virtual_ankLimit"));
        rowH.getCell(FLD_USEBANKLIMIT).setValue((Object)this.getResString("rpt_virtual_useBankLimit"));
        rowH.getCell(FLD_UNUSEBANKLIMIT).setValue((Object)this.getResString("rpt_virtual_unuseBankLimit"));
        rowH.getCell(FLD_ALLDRAFLIMIT).setValue((Object)this.getResString("rpt_virtual_allDrafLimit"));
        rowH.getCell(FLD_ALLUSELIMIT).setValue((Object)this.getResString("rpt_virtual_allUseLimit"));
    }

    protected void initCustomHeader() {
        this.addCustomRow();
        this.setHeadRowTitle();
    }

    protected void formatCol(IColumn col, int precision) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)precision));
    }

    protected String getResString(String key) {
        return EASResource.getString((String)TDSOURCE_PATH, (String)key);
    }
}

