/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.IScheduleJob;
import com.kingdee.eas.fm.be.JobTypeEnum;
import com.kingdee.eas.fm.be.ScheduleJobFactory;
import com.kingdee.eas.fm.be.client.AbstractScheduleJobImportUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ScheduleJobImportUI
extends AbstractScheduleJobImportUI {
    private static final String resourcePath = "com.kingdee.eas.fm.be.beResourse";
    private Map bankInterMap = new HashMap();
    private static final Logger logger = CoreUIObject.getLogger(ScheduleJobImportUI.class);

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        IScheduleJob iScheduleJob;
        boolean isSuccess;
        super.actionImport_actionPerformed(e);
        this.combAccInterfaceType.getSelectedItem();
        JobTypeEnum type = (JobTypeEnum)((Object)this.cboType.getSelectedItem());
        String interType = this.combAccInterfaceType.getSelectedItem().toString();
        int rows = this.tblMain.getRowCount();
        ArrayList<String> idList = new ArrayList<String>();
        String id = null;
        for (int i = 0; i < rows; ++i) {
            Boolean isSelected = (Boolean)this.tblMain.getRow(i).getCell("isSelected").getValue();
            if (isSelected == null || !isSelected.booleanValue()) continue;
            id = (String)this.tblMain.getRow(i).getCell("id").getValue();
            idList.add(id);
        }
        if (type == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Check_Type"));
            SysUtil.abort();
        }
        if (idList.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SelectAccBank"));
            SysUtil.abort();
        }
        if (isSuccess = (iScheduleJob = ScheduleJobFactory.getRemoteInstance()).batchSetSchedule(idList, type, interType)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SuccessSet"));
            this.setFilter();
            this.refresh(null);
            SysUtil.abort();
        }
        this.setFilter();
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveAll_actionPerformed(e);
        int rows = this.tblMain.getRowCount();
        for (int i = 0; i < rows; ++i) {
            this.tblMain.getRow(i).getCell("isSelected").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        int rows = this.tblMain.getRowCount();
        for (int i = 0; i < rows; ++i) {
            this.tblMain.getRow(i).getCell("isSelected").setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int rows = ScheduleJobImportUI.this.tblMain.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    ScheduleJobImportUI.this.tblMain.getRow(i).getCell("isSelected").setValue((Object)Boolean.FALSE);
                }
                ScheduleJobImportUI.this.tblMain.repaint();
            }
        });
        super.onLoad();
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.tblMain.checkParsed();
        this.tblMain.getColumn("isSelected").getStyleAttributes().setLocked(false);
        this.initBankInterface();
        this.cboType.removeItem((Object)JobTypeEnum.BANKPAYINGSTATE);
        this.cboType.removeItem((Object)JobTypeEnum.BEBANK);
        this.cboType.removeItem((Object)JobTypeEnum.BANKAGENTPAYSTATE);
        this.cboType.removeItem((Object)JobTypeEnum.BANKTRANSDOWNSTATE);
        this.cboType.removeItem((Object)JobTypeEnum.BANKTRANSUPSTATE);
        this.setFilter();
    }

    private void initBankInterface() throws BOSException {
        this.combAccInterfaceType.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        view.setFilter(filter);
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        if (colls.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Check_Interface"));
            SysUtil.abort();
        }
        int k = 0;
        this.bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (EmptyUtil.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.combAccInterfaceType.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
        if (EmptyUtil.isEmpty((Object)this.bankInterMap) || this.bankInterMap.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Check_Interface"));
            SysUtil.abort();
        }
        this.combAccInterfaceType.setSelectedIndex(0);
    }

    private void setFilter() {
        FilterInfo filter = new FilterInfo();
        String enums = this.combAccInterfaceType.getSelectedItem().toString();
        filter.getFilterItems().add(new FilterItemInfo("bankInterFace", (Object)enums));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
        String sql = "select FaccountBankId from t_be_schedulejob where FaccountBankId is not null";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.NOTINNER));
        SecureRandom random = new SecureRandom();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)String.valueOf(random.nextLong()), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bank.relatedCompany.id", null));
        FilterInfo filterNew = new FilterInfo();
        filterNew.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterNew.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)Boolean.FALSE, CompareType.EQUALS));
        filterNew.getFilterItems().add(new FilterItemInfo("isSetBankInterface", null));
        filterNew.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
        filterNew.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.NOTINNER));
        filterNew.getFilterItems().add(new FilterItemInfo("id", (Object)String.valueOf(random.nextLong()), CompareType.NOTEQUALS));
        filterNew.getFilterItems().add(new FilterItemInfo("bank.relatedCompany.id", null));
        if (this.prmtCompany.getValue() != null) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
            filterNew.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
            filterNew.setMaskString("#0 AND (#1 OR #2) AND #3 AND #4 AND #5 AND #6 AND #7");
        } else {
            filterNew.setMaskString("#0 AND (#1 OR #2) AND #3 AND #4 AND #5 AND #6");
        }
        if (this.isIncludeBankAll.isSelected()) {
            try {
                filter.mergeFilter(filterNew, "OR");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        this.mainQuery.setFilter(filter);
    }

    protected String getKeyFieldName() {
        return super.getKeyFieldName();
    }

    @Override
    protected void combAccInterfaceType_itemStateChanged(ItemEvent e) throws Exception {
        super.combAccInterfaceType_itemStateChanged(e);
        this.setFilter();
        super.execQuery();
        this.refresh(null);
    }

    protected void execQuery() {
        super.execQuery();
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null) {
            this.prmtCompany.setValue(e.getNewValue());
        }
        this.setFilter();
        super.execQuery();
        this.refresh(null);
    }

    @Override
    protected void prmtCompany_willShow(SelectorEvent e) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("isOuSealUp", (Object)"0"));
        evi.setFilter(filter);
        this.prmtCompany.setEntityViewInfo(evi);
    }

    @Override
    protected void isIncludeBankAll_itemStateChanged(ItemEvent e) throws Exception {
        super.isIncludeBankAll_itemStateChanged(e);
        this.setFilter();
        super.execQuery();
        this.refresh(null);
    }

    @Override
    protected void cboType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.cboType.getSelectedItem().equals((Object)JobTypeEnum.TRANSACTION_DETAIL)) {
            this.isIncludeBankAll.setEnabled(true);
            this.isIncludeBankAll.setVisible(true);
        } else {
            this.isIncludeBankAll.setEnabled(false);
            this.isIncludeBankAll.setVisible(false);
            this.isIncludeBankAll.setSelected(false);
        }
    }
}

