/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.IScheduleJob;
import com.kingdee.eas.fm.be.ScheduleJobCollection;
import com.kingdee.eas.fm.be.ScheduleJobFactory;
import com.kingdee.eas.fm.be.ScheduleJobInfo;
import com.kingdee.eas.fm.be.client.AbstractScheduleJobListUI;
import com.kingdee.eas.fm.be.client.ScheduleJobImportUI;
import com.kingdee.eas.fm.be.client.ScheduleJobUI;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class ScheduleJobListUI
extends AbstractScheduleJobListUI {
    private static final String resourcePath = "com.kingdee.eas.fm.be.beResourse";

    protected String getEditUIName() {
        return ScheduleJobUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ScheduleJobFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemImportData.setVisible(true);
        FMClientHelper.addSqlMenu((CoreUIObject)this, (KDMenu)this.menuEdit);
        this.actionLocate.setVisible(false);
        String timeFormat = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("dateTime").getStyleAttributes().setNumberFormat(timeFormat);
        this.tblMain.getColumn("beginRunTime").getStyleAttributes().setNumberFormat(timeFormat);
        this.tblMain.getColumn("lstTime").getStyleAttributes().setNumberFormat(timeFormat);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionStart.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_staruse"));
        this.actionStop.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_forbid"));
        this.actionBatchSet.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_input"));
    }

    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        ArrayList rs;
        super.actionStart_actionPerformed(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Check_isSelect"));
            SysUtil.abort();
        }
        if ((rs = ScheduleJobFactory.getRemoteInstance().startScheduleJob(idList)).size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"scheduleJobStart"));
            this.refresh(e);
        } else {
            int success = idList.size() - rs.size();
            StringBuffer errorDetail = new StringBuffer();
            String bankNumberTitle = EASResource.getString((String)resourcePath, (String)"scheduleJobNumber");
            String msgTitle = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"scheuleJobEStartMsg"), new Integer(success), new Integer(rs.size()));
            String LINE_SEPARATOR = System.getProperty("line.separator");
            for (int j = 0; j < rs.size(); ++j) {
                BankPayResult resultInfo = (BankPayResult)rs.get(j);
                if (!CheckUtils.exist((Object)resultInfo.getErrorDetail())) continue;
                errorDetail.append(bankNumberTitle).append(resultInfo.getNumber()).append(": ");
                errorDetail.append(resultInfo.getBankDetail()).append(LINE_SEPARATOR);
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msgTitle, (String)errorDetail.toString(), (int)0);
            this.refresh(e);
            SysUtil.abort();
        }
    }

    @Override
    public void actionStop_actionPerformed(ActionEvent e) throws Exception {
        super.actionStop_actionPerformed(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Check_isSelect"));
            SysUtil.abort();
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        IScheduleJob iScheduleJob = ScheduleJobFactory.getRemoteInstance();
        entityViewInfo.setFilter(filter);
        ScheduleJobCollection scheduleJobCollection = iScheduleJob.getScheduleJobCollection(entityViewInfo);
        int stopNumer = 0;
        if (scheduleJobCollection != null && scheduleJobCollection.size() > 0) {
            for (int i = 0; i < scheduleJobCollection.size(); ++i) {
                ScheduleJobInfo info = scheduleJobCollection.get(i);
                if (info.isIsEffected()) {
                    info.setIsEffected(false);
                    iScheduleJob.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), (CoreBaseInfo)info);
                    continue;
                }
                ++stopNumer;
            }
        }
        if (stopNumer == scheduleJobCollection.size() && stopNumer > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Check_StateStop"));
            SysUtil.abort();
        }
        this.refresh(e);
    }

    @Override
    public void actionBatchSet_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchSet_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ScheduleJobImportUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.refresh(null);
    }
}

