/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.be.SubmitPasswordFactory;
import com.kingdee.eas.fm.be.SubmitPasswordInfo;
import com.kingdee.eas.fm.be.client.AbstractSubmitPasswordEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class SubmitPasswordEditUI
extends AbstractSubmitPasswordEditUI {
    public static final String resourcePath = "com.kingdee.eas.fm.be.FmbeResource";
    private static final Logger logger = CoreUIObject.getLogger(SubmitPasswordEditUI.class);

    protected void verifyInput(ActionEvent e) throws Exception {
        boolean ifRightOldPassWord;
        super.verifyInput(e);
        if (!this.txtNewPassword1.getText().equals(this.txtNewPassword2.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"diff_password"));
            SysUtil.abort();
        }
        if (this.txtNewPassword2.getText().length() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"blankPassword"));
            SysUtil.abort();
        }
        if (!(ifRightOldPassWord = SubmitPasswordFactory.getRemoteInstance().checkOldPassword(this.txtOldPassWord.getText()))) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"wrong_oldPasswprd"));
            SysUtil.abort();
        }
        String passWord = this.txtNewPassword1.getText();
        int count = 0;
        if (passWord.length() < 8) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"Passwprd_length_less_8"));
            SysUtil.abort();
        }
        if (passWord.matches(".*\\d+.*")) {
            ++count;
        }
        if (passWord.matches(".*[A-Z]+.*")) {
            ++count;
        }
        if (passWord.matches(".*[a-z]+.*")) {
            ++count;
        }
        if (passWord.matches(".*[~!@#$%^&*( )_+|<>,.?/:;'\\[\\]{}\"]+.*")) {
            ++count;
        }
        if (count <= 1) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"Passwprd_contain_less_2"));
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        this.actionCancel.setEnabled(true);
        this.txtOldPassWord.setText("");
        this.txtNewPassword1.setText("");
        this.txtNewPassword2.setText("");
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK pkOut = LogUtil.beginLog(null, (String)"\u4fee\u6539\u63d0\u4ea4\u94f6\u4f01\u5bc6\u7801", (BOSObjectType)new SubmitPasswordInfo().getBOSType(), null, null, (String)"SubmitPassword_update");
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(this.getUserPk(), null, "SubmitPassword_add");
        super.actionSubmit_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pkOut);
        this.destroyWindow();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SubmitPasswordFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        SubmitPasswordInfo objectValue = new SubmitPasswordInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.remove((Component)this.toolBar);
        this.toolBar.setEnabled(false);
        this.toolBar.setVisible(false);
        this.actionCancel.setEnabled(true);
    }

    public boolean isModify() {
        return false;
    }

    @Override
    public void initUIToolBarLayout() {
    }
}

