/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.IBankFacade;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class TransDetailServiceClient
implements Callable {
    int threadSize = 5;
    protected int taskNum;
    private String[] oneBatchBankAcctIds;
    private String currencyId;
    private Date beginDate;
    private Date endDate;
    private BigDecimal miniAmount;
    private BigDecimal maxAmount;

    public TransDetailServiceClient() {
    }

    public TransDetailServiceClient(String currencyId, String[] param1, Date beginDate, Date endDate, BigDecimal miniAmount, BigDecimal maxAmount, int taskNum) {
        this.oneBatchBankAcctIds = param1;
        this.currencyId = currencyId;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.miniAmount = miniAmount;
        this.maxAmount = maxAmount;
        this.taskNum = taskNum;
    }

    public Map queryTransDetail(String currencyId, AccountBankInfo[] bankAccts, Date beginDate, Date endDate, BigDecimal miniAmount, BigDecimal maxAmount) throws BOSException, EASBizException {
        this.currencyId = currencyId;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.miniAmount = miniAmount;
        this.maxAmount = maxAmount;
        return this.mulThreadQueryTransDetail(bankAccts);
    }

    private Map queryTransDetail(String[] oneBatchBankAcctIds) throws BOSException, EASBizException {
        IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
        return bankFacade.getDetails(this.currencyId, oneBatchBankAcctIds, this.beginDate, this.endDate, this.miniAmount, this.maxAmount);
    }

    private Map mulThreadQueryTransDetail(AccountBankInfo[] bankAccts) throws BOSException {
        HashMap<String, Object> resultList = new HashMap<String, Object>();
        Map<String, List<String>> result = this.DivideGroupNew(bankAccts);
        if (this.threadSize > result.size()) {
            this.threadSize = result.size();
        }
        ExecutorService pool = Executors.newFixedThreadPool(this.threadSize);
        int i = 0;
        ArrayList list = new ArrayList();
        for (String bank : result.keySet()) {
            List<String> bankAcctIds = result.get(bank);
            if (bankAcctIds == null || bankAcctIds.size() <= 0) continue;
            String[] ids = new String[bankAcctIds.size()];
            TransDetailServiceClient c = this.getCommitToBeService(bankAcctIds.toArray(ids), i);
            Future f = pool.submit(c);
            list.add(f);
            ++i;
        }
        pool.shutdown();
        Map resultOne = null;
        HashMap returnStr = new HashMap();
        HashSet details = new HashSet();
        String failed = "";
        Integer failedcount = 0;
        for (Future future : list) {
            try {
                resultOne = (Map)future.get();
                returnStr.putAll((Map)resultOne.get("returnStr"));
                details.addAll((Set)resultOne.get("Details"));
                failed = resultOne.get("failed").equals(failed) ? failed : failed + resultOne.get("failed");
                failedcount = failedcount + (Integer)resultOne.get("failedcount");
            }
            catch (InterruptedException e) {
                throw new BOSException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new BOSException((Throwable)e);
            }
        }
        resultList.put("returnStr", returnStr);
        resultList.put("Details", details);
        resultList.put("failed", failed.toString());
        resultList.put("failedcount", new Integer(failedcount));
        return resultList;
    }

    private TransDetailServiceClient getCommitToBeService(String[] param1, int taskNum) {
        return new TransDetailServiceClient(this.currencyId, param1, this.beginDate, this.endDate, this.miniAmount, this.maxAmount, taskNum);
    }

    private Map<String, List<String>> DivideGroupNew(AccountBankInfo[] bankAccts) {
        HashMap<String, List<String>> group = new HashMap<String, List<String>>();
        for (int i = 0; i < bankAccts.length; ++i) {
            List<String> bankAcctIds;
            AccountBankInfo bankAcct = bankAccts[i];
            String bank = bankAcct.getBankInterFaceID();
            if (group.containsKey(bank)) {
                bankAcctIds = (List)group.get(bank);
                bankAcctIds.add(bankAcct.getId().toString());
                continue;
            }
            bankAcctIds = new ArrayList();
            bankAcctIds.add(bankAcct.getId().toString());
            group.put(bank, bankAcctIds);
        }
        return group;
    }

    public Object call() throws Exception {
        System.out.println(">>>" + this.taskNum + " \u4efb\u52a1\u542f\u52a8");
        Date dateTmp1 = new Date();
        Map resultMap = this.queryTransDetail(this.oneBatchBankAcctIds);
        Date dateTmp2 = new Date();
        long time = dateTmp2.getTime() - dateTmp1.getTime();
        System.out.println(">>>" + this.taskNum + " \u4efb\u52a1\u7ec8\u6b62; \u8017\u65f6" + time);
        return resultMap;
    }
}

