/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankAcntRelationEntryCollection;
import com.kingdee.eas.fm.be.BankAcntRelationFactory;
import com.kingdee.eas.fm.be.BankAcntRelationInfo;
import com.kingdee.eas.fm.be.client.AbstractVirtualDetailFilterUI;
import com.kingdee.eas.fm.be.client.VirtualDetailParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class VirtualDetailFilterUI
extends AbstractVirtualDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(VirtualDetailFilterUI.class);
    private static final String F7_BANK_ACNT_RELATION_QUERY = "com.kingdee.eas.fm.be.BankAcntRelationQuery";
    private static String resourcePath = "com.kingdee.eas.fm.be.BankAcntRelationResource";
    VirtualDetailParam param;

    public void init() throws EASBizException, BOSException {
        this.initF7BankInferfaceType();
        CashHelper.initCombCurrency((KDComboBox)this.kDComboCurrency, (boolean)false);
        Date date = new Date();
        this.kDDate.setValue((Object)date);
        this.kDDate.setEditable(false);
        this.chkShowBalanceOnly.setSelected(false);
        this.chkShowBalanceOnly.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Object getParam() {
        if (this.param == null) {
            this.param = new VirtualDetailParam();
        }
        this.param.setDate(this.kDDate.getSqlDate());
        this.param.setCompany(this.currentCompany);
        if (this.kDRBtnOnline.isSelected()) {
            this.param.setSearchType(1);
        } else {
            this.param.setSearchType(0);
        }
        BankAcntRelationInfo info = (BankAcntRelationInfo)this.prmtBankInterfaceType.getValue();
        try {
            info = BankAcntRelationFactory.getRemoteInstance().getBankAcntRelationInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), this.getSelectors());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
        this.param.setInfo(info);
        this.param.setBankInterface(info.getBankInterFace());
        String[] bankAcntId = this.getbankAcntId(info);
        this.param.setBankAcctId(bankAcntId);
        this.param.setCurrency((CurrencyInfo)this.kDComboCurrency.getSelectedItem());
        this.param.setDate(this.kDDate.getSqlDate());
        this.param.setShowBalanceOnly(this.chkShowBalanceOnly.isSelected());
        return this.param;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("bankInterfaceType"));
        sic.add(new SelectorItemInfo("firstAcnt.*"));
        sic.add(new SelectorItemInfo("secondOverAcnt.*"));
        sic.add(new SelectorItemInfo("bankOverAccountType"));
        sic.add(new SelectorItemInfo("overPer"));
        sic.add(new SelectorItemInfo("secondAcnt.bankAcntName"));
        sic.add(new SelectorItemInfo("secondAcnt.bankAcntNum"));
        sic.add(new SelectorItemInfo("secondAcnt.acntName"));
        sic.add(new SelectorItemInfo("secondAcnt.*"));
        sic.add(new SelectorItemInfo("secondAcnt.bankAcntID.*"));
        sic.add(new SelectorItemInfo("secondAcnt.id"));
        sic.add(new SelectorItemInfo("bankOverAccount"));
        sic.add(new SelectorItemInfo("bankInterfaceTypeName"));
        sic.add(new SelectorItemInfo("bankInterFace"));
        return sic;
    }

    private String[] getbankAcntId(BankAcntRelationInfo info) {
        String[] bankAcntId;
        block4: {
            block5: {
                block3: {
                    bankAcntId = null;
                    if (info.getFirstAcnt() == null || info.getSecondOverAcnt() == null) break block3;
                    bankAcntId = new String[info.getSecondAcnt().size() + 2];
                    bankAcntId[0] = info.getFirstAcnt().getId().toString();
                    bankAcntId[1] = info.getSecondOverAcnt().getId().toString();
                    BankAcntRelationEntryCollection entry = info.getSecondAcnt();
                    for (int i = 0; i < entry.size(); ++i) {
                        bankAcntId[i + 2] = entry.get(i).getBankAcntID().getId().toString();
                    }
                    break block4;
                }
                if (info.getFirstAcnt() == null || info.getSecondOverAcnt() != null) break block5;
                bankAcntId = new String[info.getSecondAcnt().size() + 1];
                bankAcntId[0] = info.getFirstAcnt().getId().toString();
                BankAcntRelationEntryCollection entry = info.getSecondAcnt();
                for (int i = 0; i < entry.size(); ++i) {
                    bankAcntId[i + 1] = entry.get(i).getBankAcntID().getId().toString();
                }
                break block4;
            }
            if (info.getFirstAcnt() != null || info.getSecondOverAcnt() == null) break block4;
            bankAcntId = new String[info.getSecondAcnt().size() + 1];
            bankAcntId[0] = info.getSecondOverAcnt().getId().toString();
            BankAcntRelationEntryCollection entry = info.getSecondAcnt();
            for (int i = 0; i < entry.size(); ++i) {
                bankAcntId[i + 1] = entry.get(i).getBankAcntID().getId().toString();
            }
        }
        return bankAcntId;
    }

    public void setParam(Object param) {
        this.param = (VirtualDetailParam)((Object)param);
        this.prmtBankInterfaceType.setValue((Object)this.param.getInfo());
        this.kDComboCurrency.setSelectedItem((Object)this.param.getCurrency());
        this.kDDate.setValue((Object)this.param.getDate());
        if (this.param.getSearchType() == 1) {
            this.kDRBtnOnline.setSelected(true);
            this.kDRBtnOffLine.setSelected(false);
        } else {
            this.kDRBtnOnline.setSelected(false);
            this.kDRBtnOffLine.setSelected(true);
        }
    }

    protected void setDefaultValue() {
        this.prmtBankInterfaceType.setValue(null);
        CashHelper.initCombCurrency((KDComboBox)this.kDComboCurrency, (boolean)false);
        this.kDDate.setValue((Object)new Date());
        this.kDRBtnOnline.setSelected(true);
        this.kDRBtnOffLine.setSelected(false);
    }

    @Override
    protected void kDRBtnOnline_stateChanged(ChangeEvent e) throws Exception {
        KDRadioButton onlineButton = (KDRadioButton)e.getSource();
        if (onlineButton.isSelected()) {
            Date date = new Date();
            this.kDDate.setValue((Object)date);
            this.chkShowBalanceOnly.setVisible(false);
            this.chkShowBalanceOnly.setSelected(false);
            this.kDDate.setEnabled(false);
        } else {
            this.kDDate.setEnabled(true);
            this.chkShowBalanceOnly.setVisible(true);
        }
        super.kDRBtnOnline_stateChanged(e);
    }

    private void initF7BankInferfaceType() {
        this.prmtBankInterfaceType.setData(null);
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        boolean val = ContextHelperFactory.getRemoteInstance().getBooleanParam("BE003", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (!(EmptyUtil.isEmpty((CoreBaseInfo)company) || !val && GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany))) {
            HashSet<String> list = new HashSet<String>();
            list.add(company.getId().toString());
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("hasEffected", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.prmtBankInterfaceType.setDisplayFormat("$bankInterFace$");
        this.prmtBankInterfaceType.setCommitFormat("$bankInterFace$");
        this.prmtBankInterfaceType.setEditFormat("$bankInterFace$");
        this.prmtBankInterfaceType.setQueryInfo(F7_BANK_ACNT_RELATION_QUERY);
        this.prmtBankInterfaceType.setEntityViewInfo(evi);
    }

    public boolean verify() {
        if (this.prmtBankInterfaceType.getData() == null) {
            this.showWarning(EASResource.getString((String)resourcePath, (String)"BankInterfaceType"));
            return false;
        }
        return true;
    }

    private void showWarning(String resName) {
        MsgBox.showWarning((String)resName);
        SysUtil.abort();
    }

    protected Class getParamClass() {
        return VirtualDetailParam.class;
    }
}

