/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.be.VirtualDetailFactory;
import com.kingdee.eas.fm.be.client.AbstractVirtualDetailListUI;
import com.kingdee.eas.fm.be.client.VirtualDetailFilterUI;
import com.kingdee.eas.fm.be.client.VirtualDetailParam;
import com.kingdee.eas.fm.be.client.VirtualDetailProgressBarUI;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.ProgressDialog;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class VirtualDetailListUI
extends AbstractVirtualDetailListUI {
    private static final Logger logger = CoreUIObject.getLogger(VirtualDetailListUI.class);
    private VirtualDetailFilterUI filterUI = null;
    private ProgressDialog progressDialog;
    VirtualDetailParam para;
    private String[] hideColumn = new String[]{"prebalance", "changeBalance", "overdraftLimit", "inOverdraftLimit", "overUseLimit", "overUnuseLimit", "bankLimit", "useBankLimit", "unuseBankLimit", "allDrafLimit", "allUseLimit"};
    private String transDetaiBalanceSql = new StringBuffer().append("select FBankInterfaceId as FBankInterfaceType, \n").append("     FCompanyID, \n").append("     FCurrencyID, \n").append("     FBankAccountID as FAccountBankID, \n").append("     FBalance \n").append("from (select FBankInterfaceId, \n").append("             FCompanyID, \n").append("             FCurrencyID, \n").append("             FBankAccountID, \n").append("             sum(ftransBalance) as FBalance \n").append("        from --3 \n").append("              (select B1.FBankInterfaceId as FBankInterfaceId, \n").append("                      B.FCompanyID as FCompanyID, \n").append("                      B.FCurrencyID as FCurrencyID, \n").append("                      B.FBankAccountID as FBankAccountID, \n").append("                      B.FtransBalance, \n").append("                      B.Fbiztime \n").append("                 from --2 \n").append("                       (select A2.FBankInterfaceId, \n").append("                               A2.FCompanyID, \n").append("                               A2.FCurrencyID, \n").append("                               A2.FBankAccountID, \n").append("                               A2.FBizTime as FBizTime, \n").append("                               ISNULL(max(A3.FlineNo), 0) as FlineNo \n").append("                          from --1 \n").append("                                (select B.FBankInterfaceId, \n").append("                                        A1.FCompanyID, \n").append("                                        A1.FCurrencyID, \n").append("                                        A1.FBankAccountID, \n").append("                                        max(A1.FBizTime) as FBizTime \n").append("                                   from T_BE_TransDetail as A1 \n").append("                                   Left join T_BD_AccountBanks B on A1.FBankAccountID = \n").append("                                                                    B.FID \n").append("                                  where 1 = 1 \n").append("                                    {0} ").append("                                    and A1.FCurrencyID = {1} \n").append("\t\t\t\t\t\t\t\t\t   and A1.FBankAccountID in ({2}) \n").append("                                  group by B.FBankInterfaceId, \n").append("                                           A1.FCompanyID, \n").append("                                           A1.FCurrencyID, \n").append("                                           A1.FBankAccountID) \n").append("                               --1 \n").append("                               as A2 \n").append("                          left Join T_BE_TransDetail A3 on A2.FCompanyID = \n").append("                                                           A3.FCompanyID \n").append("                                                       and A2.FCurrencyID = \n").append("                                                           A3.FCurrencyID \n").append("                                                       and A2.FBankAccountID = \n").append("                                                           A3.FBankAccountID \n").append("                                                       and A2.FBizTime = \n").append("                                                           A3.FBizTime \n").append("                         group by A2.FBankInterfaceId, \n").append("                                  A2.FCompanyID, \n").append("                                  A2.FCurrencyID, \n").append("                                  A2.FBankAccountID, \n").append("                                  A2.FBizTime) \n").append("                      --2 \n").append("                      as A \n").append("                 left JOIN (SELECT FCompanyID, \n").append("                                  FCurrencyID, \n").append("                                  FBankAccountID, \n").append("                                  FtransBalance, \n").append("                                  Fbiztime, \n").append("                                  ISNULL(FLineNo, 0) AS FLineNo \n").append("                             FROM T_BE_TransDetail) B on A.FCompanyID = \n").append("                                                         B.FCompanyID \n").append("                                                     and A.FCurrencyID = \n").append("                                                         B.FCurrencyID \n").append("                                                     and A.FBankAccountID = \n").append("                                                         B.FBankAccountID \n").append("                                                     and A.FBizTime = \n").append("                                                         B.FBizTime \n").append("                                                     and A.flineno = \n").append("                                                         B.FLineNo \n").append("                 left join T_BD_AccountBanks B1 on B.FBankAccountID = B1.FID \n").append("                                               AND B1.FisClosed = 0) \n").append("             --3 \n").append("             C \n").append("       group by FBankInterfaceId, FCompanyID, FCurrencyID, FBankAccountID) CC").toString();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompanyCommon);
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.tblMain.getColumn("virtualDate").getStyleAttributes().setNumberFormat(this.dformat);
        if (this.para.isShowBalanceOnly()) {
            this.hideColumn(true);
        } else {
            this.hideColumn(false);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new VirtualDetailFilterUI();
        }
        return this.filterUI;
    }

    public void executeQuery(FilterParam param) throws BOSException {
        this.para = (VirtualDetailParam)param;
        this.setCurrencyFormat(this.tblMain, this.para);
        if (this.para.getSearchType() == 1) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"para", (Object)this.para);
            uiContext.put((Object)"parent", (Object)this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VirtualDetailProgressBarUI.class.getName(), (Map)uiContext);
            ((VirtualDetailProgressBarUI)uiWindow.getUIObject()).setBounds(10, 10, 450, 150);
            uiWindow.show();
        }
        super.executeQuery(param);
        this.initLable(this.para);
        if (this.para.isShowBalanceOnly()) {
            this.rebuidBalance(this.para);
            this.hideColumn(true);
        } else {
            this.hideColumn(false);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.initLable(this.para);
        if (this.para.isShowBalanceOnly()) {
            this.rebuidBalance(this.para);
            this.hideColumn(true);
        } else {
            this.hideColumn(false);
        }
    }

    private void rebuidBalance(VirtualDetailParam para) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currencyId = "'" + para.getCurrency().getId().toString() + "'";
        String bankAcntId = "";
        for (int i = 0; i < para.getBankAcctId().length; ++i) {
            if (i != 0) {
                bankAcntId = bankAcntId + ", ";
            }
            bankAcntId = bankAcntId + "'" + para.getBankAcctId()[i] + "'";
        }
        Timestamp kDDateTo = new Timestamp(DateTimeUtils.truncateDate((java.util.Date)para.getDate()).getTime());
        Date endToDate = DateUtil.getSQLEnd((java.util.Date)kDDateTo);
        String bisTime = "and A1.FBizTime <= {ts '" + sdf.format(endToDate) + "'} \n";
        String sql = MessageFormat.format(this.transDetaiBalanceSql, bisTime, currencyId, bankAcntId);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("\u83b7\u53d6\u4ea4\u6613\u660e\u7ec6\u4f59\u989dSQL\u4e3a\uff1a" + sql));
        }
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        try {
            while (rowSet.next()) {
                String accountBankId = rowSet.getString("FAccountBankID");
                BigDecimal balance = rowSet.getBigDecimal("FBalance");
                if (EmptyUtil.isEmpty((Object)balance)) continue;
                resultMap.put(accountBankId, balance);
            }
        }
        catch (SQLException e) {
            this.handleException(e);
        }
        BigDecimal totalBalance = new BigDecimal("0");
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (resultMap.containsKey(row.getCell("bankAcntId").getValue().toString())) {
                row.getCell("balance").setValue(resultMap.get(row.getCell("bankAcntId").getValue().toString()));
            }
            totalBalance = totalBalance.add((BigDecimal)row.getCell("balance").getValue());
        }
        if (this.tblMain.getFootRow(0) != null) {
            this.tblMain.getFootRow(0).getCell("balance").setValue((Object)totalBalance);
        }
    }

    private void hideColumn(boolean isHide) {
        for (int i = 0; i < this.hideColumn.length; ++i) {
            this.tblMain.getColumn(this.hideColumn[i]).getStyleAttributes().setHided(isHide);
        }
    }

    private void initLable(VirtualDetailParam para) {
        String company = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"159_VirtualDetailListUI"), para.getCompany().getName());
        this.kDLabCompany.setBoundLabelText(company);
        if (para.getBankInterface() != null) {
            String bankinter = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"178_bankinterface"), para.getBankInterface().toString());
            this.kDLabelBankIntegerfaceType.setBoundLabelText(bankinter);
            this.kDLabelBankIntegerfaceType.setBoundLabelLength(this.kDLabelBankIntegerfaceType.getBoundLabelText().length());
        } else {
            this.kDLabelBankIntegerfaceType.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"160_VirtualDetailListUI"));
        }
        String currency = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"5_BankFacadeControllerBean"), para.getCurrency().getName());
        this.kDLabCurrency.setBoundLabelText(currency);
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        String day = dtformat.format(para.getDate());
        String date = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"161_VirtualDetailListUI"), day);
        this.kDLabelDate.setBoundLabelText(date);
    }

    protected boolean isFootVisible() {
        return true;
    }

    public void setCurrencyFormat(KDTable tblMain, VirtualDetailParam param) {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return VirtualDetailFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fm.be.client.VaitualDetailEditUI";
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

