/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankAcntRelationInfo;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.client.AbstractVirtualDetailProgressBarUI;
import com.kingdee.eas.fm.be.client.VirtualDetailListUI;
import com.kingdee.eas.fm.be.client.VirtualDetailParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class VirtualDetailProgressBarUI
extends AbstractVirtualDetailProgressBarUI {
    private static final Logger logger = CoreUIObject.getLogger(VirtualDetailProgressBarUI.class);
    VirtualDetailListUI virtualDetailListUI = null;
    VirtualDetailParam para = null;
    private Timer timer;
    int over = 0;
    private static String resourcePath = "com.kingdee.eas.fm.be.BankAcntRelationResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.para = (VirtualDetailParam)((Object)this.getUIContext().get("para"));
        this.virtualDetailListUI = (VirtualDetailListUI)((Object)this.getUIContext().get("parent"));
        VirtualDetailRun work = new VirtualDetailRun(this, this.para);
        this.setAction(work);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void setAction(Runnable work) {
        this.progressBar.setIndeterminate(true);
        Thread thread = new Thread(work);
        thread.start();
    }

    public void stop() {
        this.progressBar.setIndeterminate(false);
    }

    private void startTimer() {
        this.timer = new Timer(1000, new ActionListener(){
            long start = System.currentTimeMillis();

            @Override
            public void actionPerformed(ActionEvent e) {
                long end = System.currentTimeMillis();
                String tmpText = VirtualDetailProgressBarUI.this.pricessTime.getText().split(" ")[0];
                VirtualDetailProgressBarUI.this.pricessTime.setText(tmpText + " " + VirtualDetailProgressBarUI.this.formatTime(end - this.start));
            }
        });
        this.timer.setRepeats(true);
        this.timer.start();
    }

    private String formatTime(long time) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.formatNumber((time /= 1000L) / 60L / 60L % 60L)).append(':').append(this.formatNumber(time / 60L % 60L)).append(':').append(this.formatNumber(time % 60L));
        return sb.toString();
    }

    private String formatNumber(long t) {
        return t > 9L ? "" + t : "0" + t;
    }

    class VirtualDetailRun
    implements Runnable {
        VirtualDetailProgressBarUI virtualDetailProgressBar = null;
        VirtualDetailParam para = null;

        public VirtualDetailRun(VirtualDetailProgressBarUI virtualDetailProgressBar, VirtualDetailParam para) {
            this.virtualDetailProgressBar = virtualDetailProgressBar;
            this.para = para;
        }

        @Override
        public void run() {
            try {
                logger.info((Object)"\u542f\u52a8\u7ebf\u7a0b");
                VirtualDetailProgressBarUI.this.startTimer();
                logger.info((Object)"\u542f\u52a8\u65f6\u949f,\u8fdb\u884c\u67e5\u8be2");
                this.exec();
            }
            catch (EASBizException e) {
                logger.info((Object)"\u67e5\u8be2\u62a5\u9519");
                logger.error((Object)e);
                MsgBox.showInfo((String)e.getMessage());
            }
            catch (BOSException e) {
                logger.info((Object)"\u67e5\u8be2\u62a5\u9519");
                logger.error((Object)e);
                MsgBox.showInfo((String)e.getMessage());
            }
            catch (Exception e) {
                logger.info((Object)"\u67e5\u8be2\u62a5\u9519");
                logger.error((Object)e);
                MsgBox.showInfo((String)e.getMessage());
            }
            finally {
                logger.info((Object)"\u5173\u95ed\u6570\u636e");
                VirtualDetailProgressBarUI.this.timer.stop();
                this.virtualDetailProgressBar.stop();
                this.virtualDetailProgressBar.getUIWindow().close();
            }
        }

        public void exec() throws BOSException, EASBizException {
            IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
            BankAcntRelationInfo model = this.para.getInfo();
            CurrencyInfo currency = this.para.getCurrency();
            Date date = this.para.getDate();
            logger.info((Object)"\u8054\u673a\u53d6\u6570");
            Map result = bankFacade.getVirtualDetails(model, currency, date);
            if (result.containsKey("errorResult")) {
                logger.info((Object)("errorResult: " + result.get("errorResult").toString()));
                MsgBox.showInfo((String)result.get("errorResult").toString());
            } else if (result.containsKey("errorCount")) {
                String msg = EASResource.getString((String)resourcePath, (String)"errorCountMsg");
                msg = MessageFormat.format(msg, result.get("errorCount"));
                MsgBox.showConfirm3((Component)((Object)VirtualDetailProgressBarUI.this.virtualDetailListUI), (String)msg, (String)result.get("errorDetailMsg").toString());
            }
            logger.info((Object)"\u8054\u673a\u53d6\u6570\u7ed3\u675f");
            VirtualDetailProgressBarUI.this.over = 1;
        }
    }
}

