/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.util;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.basedata.assistant.PrintIntegrationInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankAgentPayBillTDProvider
implements BOSQueryDelegate {
    private static Logger logger = Logger.getLogger(BankAgentPayBillTDProvider.class);
    private Set ids = null;
    private IMetaDataPK qpk = null;
    private static final String SHREntryAmount = "XXXXXX";

    public BankAgentPayBillTDProvider() {
    }

    public BankAgentPayBillTDProvider(List id) {
        this.ids = new HashSet(id);
    }

    public BankAgentPayBillTDProvider(List id, IMetaDataPK qpk) {
        this.ids = new HashSet(id);
        this.qpk = qpk;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.qpk);
            exec.option().isAutoTranslateEnum = true;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
            ev.setFilter(filter);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
            int printedTimes = 0;
            while (iRowSet.next()) {
                String fid;
                ObjectUuidPK pk;
                String bosType;
                PrintIntegrationInfo printInfo;
                if (iRowSet.getString("SourceType").equals("SHR")) {
                    String companyID = iRowSet.getString("company.id");
                    boolean encryption = ContextHelperFactory.getRemoteInstance().getBooleanParam("CS112", (IObjectPK)new ObjectUuidPK(companyID));
                    if (encryption) {
                        IRowSetMetaData rsmd = iRowSet.getRowSetMetaData();
                        rsmd.setColumnType(rsmd.getColumnIndex("entrys.amount0"), 1);
                        iRowSet.updateString("entrys.amount0", SHREntryAmount);
                    }
                }
                if ((printInfo = pinfo.getBillPrintInfo(bosType = (pk = new ObjectUuidPK(fid = this.ids.iterator().next().toString())).getObjectType().toString(), fid)) != null) {
                    printedTimes = printInfo.getPrintedNumber();
                }
                try {
                    iRowSet.updateString("printCount", String.valueOf(printedTimes + 1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                logger.info((Object)("------------printCount = " + (printedTimes + 1)));
                logger.error((Object)("------------printCount = " + (printedTimes + 1)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iRowSet;
    }
}

