/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class InvoiceConfiguration {
    private static Logger logger = Logger.getLogger(InvoiceConfiguration.class);
    private static final String CONFIG_FILE = "be_invoice_config.xml";
    private String configFile;
    private boolean isInit;
    private String invoiceUrl;
    private String env;
    private String timeOut;
    private String token;
    private String bankReceiptPageUrl;
    private String apiPiaoZoneProd;
    private String apiPiaoZoneTest;
    private String detail;
    private String view;
    private String clientId;
    private String secret;
    private String phoneNumber;

    public static InvoiceConfiguration getInstance() {
        return Instance.configuration;
    }

    private InvoiceConfiguration() {
        this((String)null);
    }

    private InvoiceConfiguration(String configFile) {
        this.configFile = configFile;
        if (configFile == null || configFile.length() == 0) {
            String path = System.getProperty("EAS_HOME");
            this.configFile = path + "/server/properties/" + CONFIG_FILE;
        }
        this.init();
    }

    public void init() {
        try {
            Element root = this.getRoot(this.configFile);
            Element loginInfo = root.getChild("configitem");
            this.invoiceUrl = loginInfo.getChild("invoiceUrl").getText();
            this.clientId = loginInfo.getChild("clientId").getText();
            this.secret = loginInfo.getChild("secret").getText();
            this.phoneNumber = loginInfo.getChild("phoneNumber").getText();
            this.env = loginInfo.getChild("env").getText();
            this.timeOut = EmptyUtil.isEmpty((String)loginInfo.getChild("timeOut").getText()) ? loginInfo.getChild("timeOut").getText() : "10000";
            this.token = "/archivebase/scan/login/token";
            this.bankReceiptPageUrl = "/imgsys/bill/erp/bankReceipt/bankReceiptPageUrl";
            this.apiPiaoZoneProd = "https://api.piaozone.com";
            this.apiPiaoZoneTest = "https://api-dev.piaozone.com/test";
            this.detail = "/imgsys/bill/erp/bankReceipt/detail";
            this.view = "/imgsys/bill/erp/bankReceipt/detail";
            this.isInit = true;
        }
        catch (Exception e) {
            this.isInit = false;
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Element getRoot(String filePath) throws BOSException {
        try {
            FileInputStream is = new FileInputStream(new File(FilenameUtils.normalize((String)filePath)));
            Document doc = XMLParser.parseXML((InputStream)is);
            Element root = doc.getRootElement();
            return root;
        }
        catch (FileNotFoundException e) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1271_InvoiceConfiguration") + this.configFile);
        }
        catch (JDOMException e) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1272_InvoiceConfiguration") + e.getMessage());
        }
        catch (IOException e) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1273_InvoiceConfiguration") + e.getMessage());
        }
    }

    public boolean isInitialize() throws EASBizException, BOSException {
        this.isInit();
        return this.isInit;
    }

    public boolean isInit() {
        return this.isInit;
    }

    public void setInit(boolean isInit) {
        this.isInit = isInit;
    }

    public String getInvoiceUrl() {
        return this.invoiceUrl;
    }

    public void setInvoiceUrl(String invoiceUrl) {
        this.invoiceUrl = invoiceUrl;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(String timeOut) {
        this.timeOut = timeOut;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getBankReceiptPageUrl() {
        return this.bankReceiptPageUrl;
    }

    public void setBankReceiptPageUrl(String bankReceiptPageUrl) {
        this.bankReceiptPageUrl = bankReceiptPageUrl;
    }

    public String getApiPiaoZoneProd() {
        return this.apiPiaoZoneProd;
    }

    public void setApiPiaoZoneProd(String apiPiaoZoneProd) {
        this.apiPiaoZoneProd = apiPiaoZoneProd;
    }

    public String getApiPiaoZoneTest() {
        return this.apiPiaoZoneTest;
    }

    public void setApiPiaoZoneTest(String apiPiaoZoneTest) {
        this.apiPiaoZoneTest = apiPiaoZoneTest;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    private static class Instance {
        private static InvoiceConfiguration configuration = new InvoiceConfiguration();

        private Instance() {
        }
    }
}

