/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.util.InvoiceConfiguration;
import com.kingdee.eas.fm.be.util.MD5;
import java.util.Date;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class InvoiceUtil {
    private static Logger logger = Logger.getLogger(InvoiceUtil.class);
    private static InvoiceConfiguration invoice = InvoiceConfiguration.getInstance();

    public static String showInvoiceSigniture(Context ctx, JSONObject jsonObject, Map map) throws BOSException, EASBizException {
        String url = invoice.getInvoiceUrl() + invoice.getToken();
        String result = InvoiceUtil.httpsRequestPost(url, jsonObject.toString(), "utf-8");
        logger.error((Object)("========url====" + url));
        logger.error((Object)("========result====" + result));
        try {
            JSONObject parseObject = JSONObject.parseObject((String)result);
            if (!"0000".equals(parseObject.get((Object)"errcode"))) {
                result = "";
            } else {
                JSONObject data = (JSONObject)parseObject.get((Object)"data");
                result = data.get((Object)"accessToken") + "";
                logger.error((Object)("===result===" + result));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "";
        }
        return result;
    }

    public static String getPageUrl(Context ctx, String token, Map map) throws BOSException, EASBizException {
        String url = invoice.getInvoiceUrl() + invoice.getBankReceiptPageUrl() + "?access_token=" + token;
        String result = InvoiceUtil.httpsRequestGet(url, null, "utf-8");
        logger.error((Object)("========url====" + url));
        logger.error((Object)("========result====" + result));
        try {
            JSONObject parseObject = JSONObject.parseObject((String)result);
            if (!"0000".equals(parseObject.get((Object)"errcode"))) {
                result = "";
            } else {
                JSONObject data = (JSONObject)parseObject.get((Object)"data");
                result = data.get((Object)"bankReceiptPageUrl") + "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "";
        }
        return result;
    }

    public static String httpsRequestPost(String url, String param, String charset) throws EASBizException, BOSException {
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            httpClient = HttpClientBuilder.create().build();
            httpPost = new HttpPost(url);
            JSONObject paramArray = JSONObject.parseObject((String)param);
            paramArray.remove((Object)"coverBase64");
            logger.error((Object)("######be runner httpsRequestPost ticket url =" + url + " ticket param = " + paramArray));
            StringEntity se = new StringEntity(param, "UTF-8");
            se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
            se.setContentType("application/json");
            httpPost.setEntity((HttpEntity)se);
            int timeout = Integer.parseInt(invoice.getTimeOut());
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            httpPost.setConfig(config);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
                    logger.error((Object)("#####be runner common ticket result = " + result));
                }
            } else {
                logger.error((Object)("######be runner common ticket result = " + result));
            }
        }
        catch (ConnectTimeoutException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public static String httpsRequestGet(String url, String param, String charset) throws EASBizException, BOSException {
        CloseableHttpClient httpClient = null;
        HttpGet httpGet = null;
        String result = null;
        try {
            httpClient = HttpClientBuilder.create().build();
            httpGet = new HttpGet(url);
            int timeout = Integer.parseInt(invoice.getTimeOut());
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            httpGet.setConfig(config);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
                    logger.error((Object)("#####be runner common ticket result = " + result));
                }
            } else {
                logger.error((Object)("######be runner common ticket result = " + result));
            }
        }
        catch (ConnectTimeoutException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public static JSONObject getUserkeyJson(Context ctx, Map spareMap) throws EASBizException, BOSException {
        Long timeStamp = InvoiceUtil.getTimeStamp();
        JSONObject retunObject = new JSONObject();
        retunObject.put("clientId", (Object)invoice.getClientId());
        retunObject.put("sign", (Object)InvoiceUtil.getSaveInvoiceSigniture(invoice.getClientId(), invoice.getSecret(), timeStamp));
        retunObject.put("timestamp", (Object)timeStamp);
        retunObject.put("fphoneNumber", (Object)invoice.getPhoneNumber());
        retunObject.put("resource", (Object)2);
        retunObject.put("url", (Object)invoice.getApiPiaoZoneTest());
        return retunObject;
    }

    public static String getSaveInvoiceSigniture(String clientId, String clientSecret, Long timeStamp) {
        String signiture = clientId + clientSecret + timeStamp;
        return MD5.md5crypt(signiture);
    }

    public static Long getTimeStamp() {
        return new Date().getTime();
    }
}

