/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ThreadLocalDateUtil {
    private static final String date_format = "yyyyMMdd";
    private static ThreadLocal<DateFormat> threadLocal = new ThreadLocal();

    public static DateFormat getDateFormat() {
        DateFormat df = threadLocal.get();
        if (df == null) {
            df = new SimpleDateFormat(date_format);
            threadLocal.set(df);
        }
        return df;
    }

    public static String formatDate(Date date) throws ParseException {
        return ThreadLocalDateUtil.getDateFormat().format(date);
    }

    public static Date parse(String strDate) throws ParseException {
        return ThreadLocalDateUtil.getDateFormat().parse(strDate);
    }
}

