/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.ws;

import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.Base64;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;

public class WsseClientHandler
extends BasicHandler {
    private static final Logger logger = Logger.getLogger(WsseClientHandler.class);
    private static final String WSSE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String WSU_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";

    public void invoke(MessageContext msgContext) throws AxisFault {
        logger.debug((Object)"Enter: WsseClientHandler::invoke");
        try {
            Message msg = msgContext.getCurrentMessage();
            SOAPEnvelope se = msg.getSOAPEnvelope();
            SOAPHeaderElement wsseSecurity = new SOAPHeaderElement((Name)new PrefixedQName(WSSE_URI, "Security", "wsse"));
            wsseSecurity.setMustUnderstand(false);
            wsseSecurity.addChild(this.createUsernameToken(msgContext.getUsername(), msgContext.getPassword()));
            se.addHeader(wsseSecurity);
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw AxisFault.makeFault((Exception)e);
        }
        logger.debug((Object)"Exit: WsseClientHandler::invoke");
    }

    private MessageElement createUsernameToken(String usernameS, String passwordS) throws SOAPException {
        logger.debug((Object)"Enter: WsseClientHandler::createUsernameToken");
        String nonceS = this.generateNonce();
        byte[] nonceB = Base64.decode((String)nonceS);
        String createdS = this.generateTimestamp();
        if (StringUtils.isEmpty((String)createdS) || StringUtils.isEmpty((String)passwordS)) {
            throw new SOAPException(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"99_WsseClientHandler"));
        }
        byte[] createdB = WsseClientHandler.utf8decode(createdS);
        byte[] passwordB = WsseClientHandler.utf8decode(passwordS);
        MessageElement usernameToken = new MessageElement((Name)new PrefixedQName(WSSE_URI, "UsernameToken", "wsse"));
        MessageElement username = new MessageElement((Name)new PrefixedQName(WSSE_URI, "Username", "wsse"));
        username.setObjectValue((Object)usernameS);
        usernameToken.addChild(username);
        MessageElement password = new MessageElement((Name)new PrefixedQName(WSSE_URI, "Password", "wsse"));
        password.addAttribute("", "Type", "wsse:PasswordDigest");
        password.setObjectValue((Object)WsseClientHandler.getBase64Digest(nonceB, createdB, passwordB));
        usernameToken.addChild(password);
        MessageElement nonce = new MessageElement((Name)new PrefixedQName(WSSE_URI, "Nonce", "Wsse"));
        nonce.setObjectValue((Object)nonceS);
        usernameToken.addChild(nonce);
        MessageElement created = new MessageElement((Name)new PrefixedQName(WSU_URI, "Created", "wsu"));
        created.setObjectValue((Object)createdS);
        usernameToken.addChild(created);
        logger.debug((Object)"Exit: WsseClientHandler::createUsernameToken");
        return usernameToken;
    }

    private static byte[] utf8decode(String input) {
        byte[] ret = null;
        try {
            ret = input.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return ret;
    }

    private String generateNonce() {
        return "MjgzbWFyc0BnbWFpbC5jb20=";
    }

    private String generateTimestamp() {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return dateFormatter.format(new Date());
    }

    private static synchronized String getBase64Digest(byte[] nonce, byte[] created, byte[] password) {
        try {
            MessageDigest messageDigester = MessageDigest.getInstance("SHA-1");
            messageDigester.reset();
            messageDigester.update(nonce);
            messageDigester.update(created);
            messageDigester.update(password);
            return Base64.encode((byte[])messageDigester.digest());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

