/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class ClearingHouseHelper {
    public static final String SPLIT_CHAR = "!";

    public static BankInfo getReceiveCh(Context ctx, BankInfo submitCh, BankInfo confirmCh) throws EASBizException, BOSException {
        String submitChId;
        if (submitCh == null || confirmCh == null) {
            return null;
        }
        String confirmChId = confirmCh.getId().toString();
        boolean isLowerCh = ClearingHouseHelper.isLowerCh(ctx, confirmChId, submitChId = submitCh.getId().toString());
        if (isLowerCh) {
            boolean isDirectLowerCh = ClearingHouseHelper.isDirectLowerCh(ctx, confirmChId, submitChId);
            if (isDirectLowerCh) {
                return confirmCh;
            }
            return ClearingHouseHelper.getDirectLowerAndUpperCh(ctx, submitChId, confirmChId);
        }
        return ClearingHouseHelper.getDirectUpperCh(ctx, submitChId);
    }

    public static BankInfo getClearingHouse(Context ctx, String companyId) throws EASBizException, BOSException {
        return ClearingHouseHelper.getBizInterface(ctx).getClearingHouse(companyId);
    }

    public static CompanyOrgUnitInfo getChCompany(Context ctx, String chId) throws BOSException, EASBizException {
        if (chId == null) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(chId);
        IBank iBank = ClearingHouseHelper.getBizInterface(ctx);
        if (!iBank.exists((IObjectPK)pk)) {
            return null;
        }
        BankInfo chInfo = iBank.getBankInfo((IObjectPK)pk, ClearingHouseHelper.getSelector());
        return chInfo.getRelatedCompany();
    }

    private static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("parent.*");
        sic.add("parentInGroup.*");
        sic.add("relatedCompany.*");
        return sic;
    }

    public static boolean isLowerCh(Context ctx, String chId1, String chId2) throws EASBizException, BOSException {
        String chLongNumber2;
        if (FMHelper.isEmpty((String)chId1) || FMHelper.isEmpty((String)chId2)) {
            throw new IllegalArgumentException(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"70_ClearingHouseHelper"));
        }
        BankInfo chInfo1 = ClearingHouseHelper.getBizInterface(ctx).getBankInfo((IObjectPK)new ObjectUuidPK(chId1));
        BankInfo chInfo2 = ClearingHouseHelper.getBizInterface(ctx).getBankInfo((IObjectPK)new ObjectUuidPK(chId2));
        String chLongNumber1 = chInfo1.getLongNumberInGroup();
        int index = chLongNumber1.indexOf((chLongNumber2 = chInfo2.getLongNumberInGroup()) + SPLIT_CHAR);
        return index >= 0;
    }

    public static boolean isDirectLowerCh(Context ctx, String chId1, String chId2) throws BOSException {
        String sql = "SELECT * FROM T_BD_BANK WHERE FID = ?  AND FParentInGroupID = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{chId1, chId2});
        try {
            return rs.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isIndirectLowerCh(Context ctx, String chId1, String chId2) throws BOSException, EASBizException {
        return ClearingHouseHelper.isLowerCh(ctx, chId1, chId2) && !ClearingHouseHelper.isDirectLowerCh(ctx, chId1, chId2);
    }

    public static boolean isUpperCh(Context ctx, String chId1, String chId2) throws EASBizException, BOSException {
        if (FMHelper.isEmpty((String)chId1) || FMHelper.isEmpty((String)chId2)) {
            throw new IllegalArgumentException(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"70_ClearingHouseHelper"));
        }
        BankInfo chInfo1 = ClearingHouseHelper.getBizInterface(ctx).getBankInfo((IObjectPK)new ObjectUuidPK(chId1));
        BankInfo chInfo2 = ClearingHouseHelper.getBizInterface(ctx).getBankInfo((IObjectPK)new ObjectUuidPK(chId2));
        String chLongNumber1 = chInfo1.getLongNumberInGroup();
        String chLongNumber2 = chInfo2.getLongNumberInGroup();
        int index = chLongNumber2.indexOf(chLongNumber1 + SPLIT_CHAR);
        return index >= 0;
    }

    public static boolean isDirectUpperCh(Context ctx, String chId1, String chId2) throws BOSException {
        return ClearingHouseHelper.isDirectLowerCh(ctx, chId2, chId1);
    }

    public static boolean isIndirectUpperCh(Context ctx, String chId1, String chId2) throws EASBizException, BOSException {
        return ClearingHouseHelper.isUpperCh(ctx, chId1, chId2) && !ClearingHouseHelper.isDirectUpperCh(ctx, chId1, chId2);
    }

    public static BankCollection getAllLowerChColl(Context ctx, String chId) throws EASBizException, BOSException {
        BankInfo chInfo = ClearingHouseHelper.getBizInterface(ctx).getBankInfo((IObjectPK)new ObjectUuidPK(chId));
        String longNumber = chInfo.getLongNumberInGroup();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumberInGroup", (Object)(longNumber + SPLIT_CHAR), CompareType.LIKE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().addObjectCollection((IObjectCollection)ClearingHouseHelper.getSelector());
        return ClearingHouseHelper.getBizInterface(ctx).getBankCollection(evi);
    }

    public static BankCollection getDirectLowerChColl(Context ctx, String chId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parentInGroup.id", (Object)chId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().addObjectCollection((IObjectCollection)ClearingHouseHelper.getSelector());
        return ClearingHouseHelper.getBizInterface(ctx).getBankCollection(evi);
    }

    public static BankCollection getAllUpperChColl(Context ctx, String chId) throws EASBizException, BOSException {
        if (chId == null) {
            return null;
        }
        IBank iBank = ClearingHouseHelper.getBizInterface(ctx);
        BankInfo chInfo = iBank.getBankInfo((IObjectPK)new ObjectUuidPK(chId));
        String longNumber = chInfo.getLongNumberInGroup();
        if (longNumber.indexOf(SPLIT_CHAR) == -1) {
            return null;
        }
        Set set = ClearingHouseHelper.getUpLongNumberSet(longNumber);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumberInGroup", (Object)set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().addObjectCollection((IObjectCollection)ClearingHouseHelper.getSelector());
        return iBank.getBankCollection(evi);
    }

    private static Set getUpLongNumberSet(String longNumber) {
        String[] array = longNumber.split(SPLIT_CHAR);
        String temp = null;
        int len = array.length;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < len; ++i) {
            temp = array[0];
            for (int j = 1; j <= i; ++j) {
                temp = temp + SPLIT_CHAR + array[j];
            }
            set.add(temp);
        }
        return set;
    }

    public static BankInfo getDirectUpperCh(Context ctx, String chId) throws EASBizException, BOSException {
        if (chId == null) {
            return null;
        }
        BankInfo chInfo = ClearingHouseHelper.getBizInterface(ctx).getBankInfo((IObjectPK)new ObjectUuidPK(chId));
        String directUpLongNumber = ClearingHouseHelper.getDirectUpLongNumber(chInfo.getLongNumberInGroup());
        return ClearingHouseHelper.getChInfo(ctx, directUpLongNumber);
    }

    private static BankInfo getChInfo(Context ctx, String longNumber) throws BOSException {
        if (longNumber == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumberInGroup", (Object)longNumber));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().addObjectCollection((IObjectCollection)ClearingHouseHelper.getSelector());
        BankCollection upChColl = ClearingHouseHelper.getBizInterface(ctx).getBankCollection(evi);
        if (upChColl.isEmpty()) {
            return null;
        }
        return upChColl.get(0);
    }

    private static String getDirectUpLongNumber(String longNumber) {
        if (longNumber == null) {
            return null;
        }
        int index = longNumber.lastIndexOf(SPLIT_CHAR);
        if (index == -1) {
            return null;
        }
        return longNumber.substring(0, index);
    }

    public static BankInfo getDirectLowerAndUpperCh(Context ctx, String chId1, String chId2) throws EASBizException, BOSException {
        BankInfo chInfo1 = ClearingHouseHelper.getBizInterface(ctx).getBankInfo((IObjectPK)new ObjectUuidPK(chId1));
        BankInfo chInfo2 = ClearingHouseHelper.getBizInterface(ctx).getBankInfo((IObjectPK)new ObjectUuidPK(chId2));
        String longNumber1 = chInfo1.getLongNumberInGroup();
        String longNumber2 = chInfo2.getLongNumberInGroup();
        String longNumber = ClearingHouseHelper.getDirectLowerAndUpperLongNumber(longNumber1, longNumber2);
        return ClearingHouseHelper.getChInfo(ctx, longNumber);
    }

    private static String getDirectLowerAndUpperLongNumber(String longNumber1, String longNumber2) {
        if (FMHelper.isEmpty((String)longNumber1) || FMHelper.isEmpty((String)longNumber2)) {
            return null;
        }
        int index = longNumber2.indexOf(longNumber1 + SPLIT_CHAR);
        if (index == -1) {
            return null;
        }
        String[] array1 = longNumber1.split(SPLIT_CHAR);
        String[] array2 = longNumber2.split(SPLIT_CHAR);
        String result = longNumber1 + SPLIT_CHAR + array2[array1.length];
        return result;
    }

    private static IBank getBizInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return BankFactory.getRemoteInstance();
        }
        return BankFactory.getLocalInstance((Context)ctx);
    }
}

