/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.PKUtils;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.KAClassficationDetailCollection;
import com.kingdee.eas.basedata.assistant.KAClassficationDetailFactory;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.BalanceDirectionEnum;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.IInAcct;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.LedgerTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SubsidiaryBalanceEntryInfo;
import com.kingdee.eas.fm.fs.SummaryLedgerInfo;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class FSHelper {
    private static final Logger logger = CoreUIObject.getLogger(FSHelper.class);
    private static final String[] innerDepositKeys = new String[]{"type", "innerAcct", "currency"};
    private static final String[] innerSettKeys = new String[]{"type", "innerAcct", "currency"};
    private static final String[] sumInnerDepositKeys = new String[]{"type", "innerAccount", "currency"};
    private static final String[] sumInnerSettKeys = new String[]{"type", "innerAccount", "currency"};
    private static final String[] CODES = new String[]{"type", "innerAccount", "bankAcct", "currency"};
    public static final List sumKeys = Collections.unmodifiableList(Arrays.asList(CODES));
    private static final String resourcePath = "com.kingdee.eas.fm.fs.FSResource";
    public static final String TRYBALANCETYPE_KEY = "tryBalanceType";
    public static final String TRYBALANCEDIFF_KEY = "tryBalanceDiff";
    public static final String SETTDEBIT_KEY = "settDebit";
    public static final String SETTCREDIT_KEY = "settCredit";
    public static final String SETTBALANCE_KEY = "settBalance";
    public static final String ACCRUALDEBIT_KEY = "accrualDebit";
    public static final String ACCRUALCREDIT_KEY = "accrualCredit";
    public static final String ACCRUALBALANCE_KEY = "accrualBalance";
    public static final String FEEDEBIT_KEY = "feeDebit";
    public static final String FEECREDIT_KEY = "feeCredit";
    public static final String FEEBALANCE_KEY = "feeBalance";
    public static final String KA_InnerSett = "6001";
    public static final String KA_InnerSett_id = "00000000-0000-0000-0000-000000000033F9F423C0";
    public static final String KA_InnerDeposite = "6003";
    public static final String KA_All = "6005";
    public static final String KA_InnerDeposite_id = "00000000-0000-0000-0000-000000000035F9F423C0";
    public static final Map KAcach = new HashMap();
    public static final String PARAM_SAVE_ACCEPT = "TM004";
    public static int noAcctBank = 0;
    public static int oneTrueAcctBank = 1;
    public static int oneVirtualAcctBank = 2;
    public static int moreTrueAcctBank = 3;
    public static int oneTrueOneVirtualAcctBank = 4;
    public static int moreTrueOneVirtualAcctBank = 5;
    public static int moreTrueMoreVirtualAcctBank = 6;

    public static BankInfo getClearingHouseInfoByInnerAcct(Context ctx, String innerAcctId) throws BOSException, EASBizException {
        IInnerAccount iInnerAcct = null;
        iInnerAcct = ctx == null ? InnerAccountFactory.getRemoteInstance() : InnerAccountFactory.getLocalInstance(ctx);
        InnerAccountInfo innerAcctInfo = iInnerAcct.getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAcctId));
        String companyId = innerAcctInfo.getCompany().getId().toString();
        return FSHelper.getClearingHouseInfo(ctx, companyId);
    }

    public static Set getCompanySetByCompanyid(Context ctx, Set ids) throws BOSException {
        IInAcct iInAcct = null;
        iInAcct = ctx == null ? InAcctFactory.getRemoteInstance() : InAcctFactory.getLocalInstance(ctx);
        Set set = iInAcct.getUpAndcurCompanyID(ids);
        return set;
    }

    public static CompanyOrgUnitInfo getCHCompanyInfo(Context ctx, String innerAcctId) throws BOSException, EASBizException {
        IInnerAccount iInnerAcct = null;
        iInnerAcct = ctx == null ? InnerAccountFactory.getRemoteInstance() : InnerAccountFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("company.baseCurrency.*"));
        sic.add(new SelectorItemInfo("company.baseExchangeTable.*"));
        InnerAccountInfo innerAcctInfo = iInnerAcct.getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAcctId), sic);
        return innerAcctInfo.getCompany();
    }

    public static CompanyOrgUnitInfo getCHCompanyInfo(Context ctx) throws BOSException, EASBizException {
        BankInfo chInfo = FSHelper.getClearingHouseInfo(ctx, null);
        if (chInfo == null) {
            return null;
        }
        String companyId = chInfo.getRelatedCompany().getId().toString();
        ICompanyOrgUnit iCompany = null;
        iCompany = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.*"));
        sic.add(new SelectorItemInfo("baseExchangeTable.*"));
        return iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
    }

    public static Date getDailySettledDate(Context ctx, String companyId) throws EASBizException, BOSException {
        return FSHelper.getClearingHouseInfo(ctx, companyId).getSettleDate();
    }

    public static Date getCHOpenDate(Context ctx, String companyId) throws EASBizException, BOSException {
        return FSHelper.getClearingHouseInfo(ctx, companyId).getOpenDate();
    }

    public static BigDecimal getExchangeRate(Context ctx, CurrencyInfo sourceCur) throws BOSException, EASBizException {
        BOSUuid sourceCurID;
        BOSUuid desCurID;
        ExchangeTableInfo baseExchangeTable = new ExchangeTableInfo();
        CurrencyInfo desCur = new CurrencyInfo();
        String companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        CompanyOrgUnitInfo companyInfo = FSHelper.getClearingHouseInfo(ctx, companyId).getRelatedCompany();
        if (companyInfo.getBaseCurrency() != null) {
            desCur = companyInfo.getBaseCurrency();
        }
        if (companyInfo.getBaseExchangeTable() != null) {
            baseExchangeTable = companyInfo.getBaseExchangeTable();
        }
        if ((desCurID = desCur.getId()).equals((Object)(sourceCurID = sourceCur.getId()))) {
            return Constants.ONE;
        }
        ObjectUuidPK destCurrpk = new ObjectUuidPK(desCurID);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCurID);
        ObjectUuidPK excTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, new Date(System.currentTimeMillis()));
        if (erInfo != null) {
            return erInfo.getConvertRate();
        }
        return Constants.ZERO;
    }

    public static BigDecimal getExchangeRate(Context ctx, CompanyOrgUnitInfo companyInfo, CurrencyInfo sourceCur) throws BOSException, EASBizException {
        BOSUuid sourceCurID;
        BOSUuid desCurID;
        ExchangeTableInfo baseExchangeTable = new ExchangeTableInfo();
        CurrencyInfo desCur = new CurrencyInfo();
        if (companyInfo.getBaseCurrency() != null) {
            desCur = companyInfo.getBaseCurrency();
        }
        if (companyInfo.getBaseExchangeTable() != null) {
            baseExchangeTable = companyInfo.getBaseExchangeTable();
        }
        if ((desCurID = desCur.getId()).equals((Object)(sourceCurID = sourceCur.getId()))) {
            return Constants.ONE;
        }
        ObjectUuidPK destCurrpk = new ObjectUuidPK(desCurID);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCurID);
        ObjectUuidPK excTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, new Date(System.currentTimeMillis()));
        if (erInfo != null) {
            return erInfo.getConvertRate();
        }
        return Constants.ZERO;
    }

    public static BigDecimal getLocalAmount(Context ctx, BigDecimal amount, CurrencyInfo sourceCur) throws EASBizException, BOSException {
        BigDecimal exchangeRate = FMHelper.checkBigDecimal((BigDecimal)FSHelper.getExchangeRate(ctx, sourceCur));
        amount = FMHelper.checkBigDecimal((BigDecimal)amount);
        return amount.multiply(exchangeRate);
    }

    public static String getKeyString(IObjectValue iter, String[] keys) {
        return PKUtils.getKeyString((IObjectValue)iter, (String[])keys);
    }

    public static String getKeyString(String[] values) {
        StringBuffer sb = new StringBuffer(values.length * 10);
        for (int i = 0; i < values.length; ++i) {
            sb.append("_");
            if (values[i] == null) {
                sb.append("null");
                continue;
            }
            sb.append(values[i]);
        }
        return sb.toString();
    }

    public static Map getSubHashSearchMap(IObjectCollection iObjCol) {
        HashMap<String, SubsidiaryBalanceEntryInfo> map = new HashMap<String, SubsidiaryBalanceEntryInfo>();
        String[] keys = null;
        Object iObjVal = null;
        SubsidiaryBalanceEntryInfo subInfo = null;
        int colSize = iObjCol.size();
        for (int i = 0; i < colSize; ++i) {
            subInfo = (SubsidiaryBalanceEntryInfo)iObjCol.getObject(i);
            keys = subInfo.getType().equals((Object)LedgerTypeEnum.INNERDEPOSIT) ? innerDepositKeys : innerSettKeys;
            map.put(PKUtils.getKeyString((IObjectValue)subInfo, (String[])keys), subInfo);
        }
        return map;
    }

    public static Map getSumHashSearchMap(IObjectCollection iObjCol) {
        HashMap<String, SummaryLedgerInfo> map = new HashMap<String, SummaryLedgerInfo>();
        SummaryLedgerInfo sumInfo = null;
        int colSize = iObjCol.size();
        for (int i = 0; i < colSize; ++i) {
            sumInfo = (SummaryLedgerInfo)iObjCol.getObject(i);
            map.put(PKUtils.getKeyString((IObjectValue)sumInfo, (String[])FSHelper.getStrings(sumKeys)), sumInfo);
        }
        return map;
    }

    public static KAClassficationDetailCollection getDetailCollection(Context ctx, String kaId, String type) {
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add("id");
        ev.getSelector().add("name");
        ev.getSelector().add("number");
        ev.getSelector().add("accountlink.*");
        ev.getSelector().add("accountitemlink.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kaclassficlink.id", (Object)kaId));
        if (type.equals(KA_InnerSett)) {
            filter.getFilterItems().add(new FilterItemInfo("accountitemlink.id", (Object)KA_InnerSett_id));
        }
        if (type.equals(KA_InnerDeposite)) {
            filter.getFilterItems().add(new FilterItemInfo("accountitemlink.id", (Object)KA_InnerDeposite_id));
        }
        if (type.equals(KA_All)) {
            filter.getFilterItems().add(new FilterItemInfo("accountitemlink.id", (Object)KA_InnerSett_id));
            filter.getFilterItems().add(new FilterItemInfo("accountitemlink.id", (Object)KA_InnerDeposite_id));
            filter.setMaskString("#0 and (#1 or #2) ");
        }
        ev.setFilter(filter);
        KAClassficationDetailCollection kac = null;
        try {
            kac = ctx != null ? KAClassficationDetailFactory.getLocalInstance((Context)ctx).getKAClassficationDetailCollection(ev) : KAClassficationDetailFactory.getRemoteInstance().getKAClassficationDetailCollection(ev);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return kac;
    }

    public static AccountViewInfo getAccount(InnerAccountInfo innAcc) {
        try {
            return FSHelper.getAccount(null, innAcc);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static AccountViewInfo getAccount(Context ctx, InnerAccountInfo innAcc) throws EASBizException {
        if (innAcc == null || innAcc.getClhClassification() == null) {
            throw new FSException(FSException.ACCOUNTMSG_1, new String[]{innAcc.getName()});
        }
        KAClassficationDetailCollection kdColl = FSHelper.getDetailCollection(ctx, innAcc.getClhClassification().getId().toString(), KA_InnerSett);
        if (kdColl == null || kdColl.size() == 0) {
            throw new FSException(FSException.ACCOUNTMSG_2, new String[]{innAcc.getName()});
        }
        AccountViewInfo accountlink = kdColl.get(0).getAccountlink();
        if (accountlink != null) {
            return accountlink;
        }
        throw new FSException(FSException.ACCOUNTMSG_3, new String[]{innAcc.getName(), kdColl.get(0).getAccountitemlink().getName()});
    }

    public static AccountViewInfo getInnerDepositAccount(Context ctx, InnerAccountInfo innAcc) throws EASBizException {
        if (innAcc == null || innAcc.getClhClassification() == null) {
            throw new FSException(FSException.ACCOUNTMSG_1, new String[]{innAcc.getName()});
        }
        KAClassficationDetailCollection kdColl = FSHelper.getDetailCollection(ctx, innAcc.getClhClassification().getId().toString(), KA_InnerDeposite);
        if (kdColl == null || kdColl.size() == 0) {
            throw new FSException(FSException.ACCOUNTMSG_2, new String[]{innAcc.getName()});
        }
        AccountViewInfo accountlink = kdColl.get(0).getAccountlink();
        if (accountlink != null) {
            return accountlink;
        }
        throw new FSException(FSException.ACCOUNTMSG_3, new String[]{innAcc.getName(), kdColl.get(0).getAccountitemlink().getName()});
    }

    public static BalanceDirectionEnum getBalanceDirection(BigDecimal bigValue) {
        if (bigValue == null) {
            throw new IllegalArgumentException("bigValue is null!");
        }
        return BalanceDirectionEnum.getEnum(bigValue.signum());
    }

    public static AccountViewInfo getAccountViewByClassifcation(String kaId, String kaItemId) throws EASBizException, BOSException {
        String key = kaId + kaItemId;
        AccountViewInfo info = (AccountViewInfo)KAcach.get(key);
        if (info != null) {
            return info;
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add("accountlink.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountitemlink.id", (Object)kaItemId));
        filter.getFilterItems().add(new FilterItemInfo("kaclassficlink.id", (Object)kaId));
        KAClassficationDetailCollection kac = KAClassficationDetailFactory.getRemoteInstance().getKAClassficationDetailCollection(ev);
        if (kac == null || kac.size() != 1) {
            throw new BOSException("not exist!");
        }
        info = kac.get(0).getAccountlink();
        KAcach.put(key, info);
        return info;
    }

    public static AccountBankInfo getAcctBankByInnerAcct(Context ctx, InnerAccountInfo innerAccount) throws BOSException {
        if (innerAccount == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        view.getSelector().add("account.*");
        view.getSelector().add("ctrlStrategy.*");
        view.getSelector().add("bank.*");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("InnerAcct.id", (Object)innerAccount.getId().toString()));
        IAccountBank iAccountBank = null;
        iAccountBank = ctx == null ? AccountBankFactory.getRemoteInstance() : AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankCollection accountBank = iAccountBank.getAccountBankCollection(view);
        if (accountBank.size() == 0) {
            return null;
        }
        if (accountBank.size() == 1) {
            return accountBank.get(0);
        }
        if (accountBank.size() > 1) {
            int n = accountBank.size();
            for (int i = 0; i < n; ++i) {
                AccountBankInfo acct = accountBank.get(i);
                if (!acct.getBank().isInGroup()) continue;
                return acct;
            }
            return null;
        }
        return null;
    }

    public static AccountBankCollection getAcctBankByInnerAcctCol(Context ctx, InnerAccountInfo innerAccount) throws BOSException {
        if (innerAccount == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        view.getSelector().add("acctName");
        view.getSelector().add("bank.*");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("InnerAcct.id", (Object)innerAccount.getId().toString()));
        IAccountBank iAccountBank = null;
        iAccountBank = ctx == null ? AccountBankFactory.getRemoteInstance() : AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankCollection accountBank = iAccountBank.getAccountBankCollection(view);
        return accountBank;
    }

    public static AccountBankInfo getVirtualAcctBankByInnerAcct(Context ctx, InnerAccountInfo innerAccount) throws BOSException {
        if (innerAccount == null) {
            return null;
        }
        AccountBankCollection accountBank = FSHelper.getAcctBankByInnerAcctCol(ctx, innerAccount);
        if (accountBank == null || accountBank.size() == 0) {
            return null;
        }
        int n = accountBank.size();
        for (int i = 0; i < n; ++i) {
            AccountBankInfo acct = accountBank.get(i);
            if (!acct.getBank().isInGroup()) continue;
            return acct;
        }
        return null;
    }

    public static AccountViewInfo getAcctByInnerAcct(Context ctx, InnerAccountInfo innerAccount) throws BOSException, EASBizException {
        AccountBankInfo accountBank = FSHelper.getAcctBankByInnerAcct(ctx, innerAccount);
        if (accountBank == null) {
            return null;
        }
        String acctId = accountBank.getAccount().getId().toString();
        IAccountView iAccountView = null;
        iAccountView = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance((Context)ctx);
        return iAccountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(acctId));
    }

    public static AccountViewInfo getAcctByAcctBank(Context ctx, AccountBankInfo acctBank) throws BOSException, EASBizException {
        String acctId = acctBank.getAccount().getId().toString();
        IAccountView iAccountView = null;
        iAccountView = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance((Context)ctx);
        return iAccountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(acctId));
    }

    public static InnerAccountInfo getInnerAcctByNumber(Context ctx, String number) throws BOSException {
        if (EmptyUtil.isEmpty((String)number)) {
            return null;
        }
        IInnerAccount innerAccount = null;
        innerAccount = ctx == null ? InnerAccountFactory.getRemoteInstance() : InnerAccountFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        InnerAccountCollection coll = innerAccount.getInnerAccountCollection(evi);
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        return coll.get(0);
    }

    public static void setDlByRecPay(Context ctx, SettlementBillInfo info) throws EASBizException, BOSException {
        InnerAccountInfo payeeInnerAcctInfo = info.getPayeeInnerAcct();
        InnerAccountInfo payerInnerAcctInfo = info.getPayerInnerAcct();
        String companyId = info.getCompany().getId().toString();
        info.setIsDlByRec(FSHelper.isEqualInnerAcctCompanyAndCompany(ctx, payeeInnerAcctInfo, companyId));
        info.setIsDlByPay(FSHelper.isEqualInnerAcctCompanyAndCompany(ctx, payerInnerAcctInfo, companyId));
    }

    public static boolean isEqualInnerAcctCompanyAndCompany(Context ctx, InnerAccountInfo innerAcctInfo, String companyId) throws EASBizException, BOSException {
        if (innerAcctInfo == null) {
            return false;
        }
        String innerAcctCompanyId = null;
        if (innerAcctInfo.getCompany() == null) {
            ObjectUuidPK pk = new ObjectUuidPK(innerAcctInfo.getId());
            innerAcctInfo = ctx == null ? InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)pk) : InnerAccountFactory.getLocalInstance(ctx).getInnerAccountInfo((IObjectPK)pk);
        }
        innerAcctCompanyId = innerAcctInfo.getCompany().getId().toString();
        return innerAcctCompanyId.equals(companyId);
    }

    public static String[] getStrings(List aList) {
        if (aList == null) {
            return null;
        }
        String[] strings = new String[aList.size()];
        for (int i = 0; i < aList.size(); ++i) {
            strings[i] = (String)aList.get(i);
        }
        return strings;
    }

    public static void main(String[] args) {
        String[] a = FSHelper.getStrings(sumKeys);
        logger.info((Object)a[3]);
    }

    public static int getAcctBankMappingType(AccountBankCollection coll) {
        if (coll == null || coll.size() == 0) {
            return noAcctBank;
        }
        if (coll.size() == 1) {
            if (coll.get(0).getBank().isInGroup()) {
                return oneVirtualAcctBank;
            }
            return oneTrueAcctBank;
        }
        int trueBankCount = 0;
        int virtualBankCount = 0;
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            AccountBankInfo acct = coll.get(i);
            if (acct.getBank().isInGroup()) {
                ++virtualBankCount;
                continue;
            }
            ++trueBankCount;
        }
        if (trueBankCount == virtualBankCount) {
            if (trueBankCount == 1) {
                return oneTrueOneVirtualAcctBank;
            }
            return moreTrueMoreVirtualAcctBank;
        }
        if (trueBankCount > 1 && virtualBankCount == 0) {
            return moreTrueAcctBank;
        }
        if (trueBankCount > 1 && virtualBankCount == 1) {
            return moreTrueOneVirtualAcctBank;
        }
        return moreTrueMoreVirtualAcctBank;
    }

    public static AccountBankInfo getVirtualAcctBank(AccountBankCollection coll) {
        int mappingType = FSHelper.getAcctBankMappingType(coll);
        if (mappingType == oneVirtualAcctBank) {
            return coll.get(0);
        }
        if (mappingType == oneTrueOneVirtualAcctBank || mappingType == moreTrueOneVirtualAcctBank) {
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                AccountBankInfo acct = coll.get(i);
                if (!acct.getBank().isInGroup()) continue;
                return acct;
            }
            return null;
        }
        return null;
    }

    public static BankInfo getClearingHouseInfo(Context ctx, String companyId) throws BOSException, EASBizException {
        IBank iBank = null;
        if (ctx == null) {
            if (EmptyUtil.isEmpty((String)companyId)) {
                companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            }
            iBank = BankFactory.getRemoteInstance();
        } else {
            if (EmptyUtil.isEmpty((String)companyId)) {
                companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
            }
            iBank = BankFactory.getLocalInstance((Context)ctx);
        }
        return iBank.getClearingHouse(companyId);
    }

    public static boolean getBooleanParamValue(Context ctx, String companyId, String param) {
        ObjectUuidPK pk = null;
        if (!EmptyUtil.isEmpty((String)companyId)) {
            pk = new ObjectUuidPK(companyId);
        }
        if (ctx == null) {
            return ContextHelperFactory.getRemoteInstance().getBooleanParam(param, (IObjectPK)pk);
        }
        return ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam(param, (IObjectPK)pk);
    }
}

