/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.IReceiveAcctBuilder;
import com.kingdee.eas.fm.fs.ReceiveAccountFactory;
import com.kingdee.eas.fm.fs.ReceiveAccountInfo;
import com.kingdee.eas.fm.fs.ReceiveAcctHelper;
import com.kingdee.eas.fm.fs.ReceiveAcctSourceEnum;
import com.kingdee.eas.fm.fs.ReceiveAcctStatusEnum;
import java.util.Date;

public class RecAcctReceiveAcctBuilder
implements IReceiveAcctBuilder {
    @Override
    public ReceiveAccountInfo getReceiveAcctInfo(Context ctx, String billId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("settleAcceptCH.*");
        sic.add("settleConfirmCH.*");
        sic.add("submitCH.*");
        ReceiveAccountInfo srcInfo = ReceiveAccountFactory.getLocalInstance(ctx).getReceiveAccountInfo((IObjectPK)new ObjectUuidPK(billId), sic);
        return this.buildDestInfo(ctx, srcInfo);
    }

    private ReceiveAccountInfo buildDestInfo(Context ctx, ReceiveAccountInfo srcInfo) {
        ReceiveAccountInfo destInfo = new ReceiveAccountInfo();
        Date date = new Date();
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        destInfo.setId(BOSUuid.create((BOSObjectType)destInfo.getBOSType()));
        destInfo.setSubmitCH(srcInfo.getSubmitCH());
        destInfo.setSubmitDate(date);
        destInfo.setCompany(srcInfo.getCompany());
        destInfo.setIsBackBill(true);
        destInfo.setSource(ReceiveAcctSourceEnum.RECEIVEACCOUNT);
        destInfo.setSrcSettlementBill(srcInfo.getSrcSettlementBill());
        destInfo.setBizDate(srcInfo.getBizDate());
        destInfo.setType(srcInfo.getType());
        destInfo.setDoForRecPay(srcInfo.getDoForRecPay());
        destInfo.setCurrency(srcInfo.getCurrency());
        destInfo.setAmount(srcInfo.getAmount().negate());
        destInfo.setDescription(srcInfo.getDescription());
        destInfo.setUpReckoningAcct(srcInfo.getUpReckoningAcct());
        destInfo.setDownReckoningAcct(srcInfo.getDownReckoningAcct());
        destInfo.setAccountBank(srcInfo.getAccountBank());
        destInfo.setSettlementType(srcInfo.getSettlementType());
        destInfo.setSettleNumber(srcInfo.getSettleNumber());
        destInfo.setSettleAcceptCH(srcInfo.getSettleAcceptCH());
        destInfo.setSettleConfirmCH(srcInfo.getSettleConfirmCH());
        destInfo.setCreator(user);
        destInfo.setStatus(ReceiveAcctStatusEnum.UNDEALED);
        destInfo.setFivouchered(false);
        destInfo.setUpBillId(srcInfo.getId().toString());
        String companyId = destInfo.getCompany().getId().toString();
        String confirmCompanyId = destInfo.getSettleConfirmCH().getRelatedCompany().getId().toString();
        String acceptCompanyId = destInfo.getSettleAcceptCH().getRelatedCompany().getId().toString();
        destInfo.setVoucherEnum(ReceiveAcctHelper.getRecAcctVoucherEnum(companyId, confirmCompanyId, acceptCompanyId));
        return destInfo;
    }
}

