/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.BackRecAcctSendAcctBuilder;
import com.kingdee.eas.fm.fs.IRecAcctCheckBuilder;
import com.kingdee.eas.fm.fs.IReceiveAccount;
import com.kingdee.eas.fm.fs.ISendAccount;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.InnerBackRecAcctSettleBillBuilder;
import com.kingdee.eas.fm.fs.InnerNormalRecAcctSettleBillBuilder;
import com.kingdee.eas.fm.fs.NormalRecAcctSendAcctBuilder;
import com.kingdee.eas.fm.fs.OuterBackRecAcctSettleBillBuilder;
import com.kingdee.eas.fm.fs.OuterNormalRecAcctSettleBillBuilder;
import com.kingdee.eas.fm.fs.RecAcctVoucherEnum;
import com.kingdee.eas.fm.fs.ReceiveAccountCollection;
import com.kingdee.eas.fm.fs.ReceiveAccountException;
import com.kingdee.eas.fm.fs.ReceiveAccountFactory;
import com.kingdee.eas.fm.fs.ReceiveAccountInfo;
import com.kingdee.eas.fm.fs.ReceiveAcctStatusEnum;
import com.kingdee.eas.fm.fs.SendAccountFactory;
import com.kingdee.eas.fm.fs.SendAccountInfo;
import com.kingdee.eas.fm.fs.SendAcctStatusEnum;
import com.kingdee.eas.fm.fs.SendRecAcctTypeEnum;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ReceiveAcctHelper {
    public static final int CHECK = 1;
    public static final int BACK_BILL = 2;
    public static final int SETTLE = 3;
    public static final int CHECK_DISPOSE = 10;
    public static final int CHECK_BACK = 11;
    public static final int SETTLE_SETTLE = 30;
    public static final int SETTLE_COMMIT2BE = 31;
    public static final int SETTLE_WRITEOFF = 32;

    public static void beforeCheck(Context ctx, Set idSet) throws BOSException, EASBizException {
        ReceiveAccountCollection coll = ReceiveAcctHelper.getColl(ctx, idSet);
        ReceiveAccountInfo recInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            recInfo = coll.get(i);
            ReceiveAcctHelper.beforeCheck(ctx, recInfo);
        }
    }

    public static void beforeCheck(Context ctx, ReceiveAccountInfo recInfo) throws BOSException, EASBizException {
        if (!recInfo.getStatus().equals((Object)ReceiveAcctStatusEnum.UNDEALED)) {
            throw new ReceiveAccountException(ReceiveAccountException.CHECKERROR, new String[]{recInfo.getNumber()});
        }
    }

    public static void beforeBackBill(Context ctx, Set idSet) throws BOSException, EASBizException {
        ReceiveAccountCollection coll = ReceiveAcctHelper.getColl(ctx, idSet);
        ReceiveAccountInfo recInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            recInfo = coll.get(i);
            ReceiveAcctHelper.beforeBackBill(ctx, recInfo);
        }
    }

    public static void beforeBackBill(Context ctx, ReceiveAccountInfo recInfo) throws ReceiveAccountException, BOSException, EASBizException {
        String downBillId = recInfo.getDownBillId();
        if (!recInfo.getStatus().equals((Object)ReceiveAcctStatusEnum.CHECKED) || FMHelper.isEmpty((String)downBillId)) {
            throw new ReceiveAccountException(ReceiveAccountException.BACKBILLERROR, new String[]{recInfo.getNumber()});
        }
        boolean isSendAcct = BOSUuid.read((String)downBillId).getType().equals((Object)new SendAccountInfo().getBOSType());
        if (!isSendAcct) {
            throw new ReceiveAccountException(ReceiveAccountException.BACKBILLERROR, new String[]{recInfo.getNumber()});
        }
        SendAccountInfo sendInfo = ReceiveAcctHelper.getSendAcctInterface(ctx).getSendAccountInfo((IObjectPK)new ObjectUuidPK(downBillId));
        if (!recInfo.getStatus().equals((Object)ReceiveAcctStatusEnum.CHECKED) || !sendInfo.getStatus().equals((Object)SendAcctStatusEnum.BACKED)) {
            throw new ReceiveAccountException(ReceiveAccountException.BACKBILLERROR, new String[]{recInfo.getNumber()});
        }
    }

    public static void beforeSettle(Context ctx, Set idSet) throws BOSException, EASBizException {
        IContextHelper ctxHelper = null;
        ctxHelper = ctx == null ? ContextHelperFactory.getRemoteInstance() : ContextHelperFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = ctxHelper.getCurrentCompany();
        String companyId = company.getId().toString();
        ReceiveAccountCollection coll = ReceiveAcctHelper.getColl(ctx, idSet);
        ReceiveAccountInfo recInfo = null;
        CompanyOrgUnitInfo confirmChCompany = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            recInfo = coll.get(i);
            confirmChCompany = recInfo.getSettleConfirmCH().getRelatedCompany();
            if (recInfo.getStatus().equals((Object)ReceiveAcctStatusEnum.CHECKED) && confirmChCompany.getId().toString().equals(companyId) && recInfo.getType().equals((Object)SendRecAcctTypeEnum.OUTERSETTLE)) continue;
            throw new ReceiveAccountException(ReceiveAccountException.SETTLEERROR, new String[]{recInfo.getNumber()});
        }
    }

    public static void beforeSettle(Context ctx, ReceiveAccountInfo recInfo) throws BOSException, EASBizException {
        IContextHelper ctxHelper = null;
        ctxHelper = ctx == null ? ContextHelperFactory.getRemoteInstance() : ContextHelperFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = ctxHelper.getCurrentCompany();
        String companyId = company.getId().toString();
        CompanyOrgUnitInfo confirmChCompany = recInfo.getSettleConfirmCH().getRelatedCompany();
        if (!(recInfo.getStatus().equals((Object)ReceiveAcctStatusEnum.CHECKED) && confirmChCompany.getId().toString().equals(companyId) && recInfo.getType().equals((Object)SendRecAcctTypeEnum.OUTERSETTLE))) {
            throw new ReceiveAccountException(ReceiveAccountException.SETTLEERROR, new String[]{recInfo.getNumber()});
        }
    }

    private static ReceiveAccountCollection getColl(Context ctx, Set idSet) throws BOSException {
        if (idSet == null || idSet.isEmpty()) {
            return new ReceiveAccountCollection();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("settleAcceptCH.*");
        evi.getSelector().add("settleConfirmCH.*");
        evi.getSelector().add("submitCH.*");
        evi.getSelector().add("upReckoningAcct.*");
        evi.getSelector().add("downReckoningAcct.*");
        return ReceiveAcctHelper.getRecAcctInterface(ctx).getReceiveAccountCollection(evi);
    }

    private static IReceiveAccount getRecAcctInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return ReceiveAccountFactory.getRemoteInstance();
        }
        return ReceiveAccountFactory.getLocalInstance(ctx);
    }

    private static ISendAccount getSendAcctInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return SendAccountFactory.getRemoteInstance();
        }
        return SendAccountFactory.getLocalInstance(ctx);
    }

    public static IRecAcctCheckBuilder getBuilder(boolean isBackBill, boolean isConfirmCh, boolean isAcceptCh, SendRecAcctTypeEnum type) {
        IRecAcctCheckBuilder builder = null;
        if (!isBackBill && isConfirmCh && type.equals((Object)SendRecAcctTypeEnum.INNERSETTLE)) {
            builder = new InnerNormalRecAcctSettleBillBuilder();
        } else if (isBackBill && isAcceptCh && type.equals((Object)SendRecAcctTypeEnum.INNERSETTLE)) {
            builder = new InnerBackRecAcctSettleBillBuilder();
        } else if (!isBackBill && isConfirmCh && type.equals((Object)SendRecAcctTypeEnum.OUTERSETTLE)) {
            builder = new OuterNormalRecAcctSettleBillBuilder();
        } else if (isBackBill && isAcceptCh && type.equals((Object)SendRecAcctTypeEnum.OUTERSETTLE)) {
            builder = new OuterBackRecAcctSettleBillBuilder();
        } else if (!isBackBill && !isConfirmCh) {
            builder = new NormalRecAcctSendAcctBuilder();
        } else if (isBackBill && !isAcceptCh) {
            builder = new BackRecAcctSendAcctBuilder();
        }
        return builder;
    }

    public static void signCheck(Context ctx, String billId, String result) throws BOSException {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String userId = user.getId().toString();
        StringBuffer sql = new StringBuffer();
        Object[] params = null;
        if (FMHelper.isEmpty((String)result)) {
            sql.append("UPDATE T_FS_ReceiveAccount SET FResult = null, FCheckerId = ?, ").append(" FLastHandlerId = ?, FStatus = ? WHERE FID = ?");
            params = new Object[]{userId, userId, "checked", billId};
        } else {
            sql.append("UPDATE T_FS_ReceiveAccount SET FResult = ?, FCheckerId = ?, ").append(" FLastHandlerId = ?, FStatus = ? WHERE FID = ?");
            params = new Object[]{result, userId, userId, "checked", billId};
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    public static void signAntiCheck(Context ctx, String billId) throws BOSException {
        String sql = "UPDATE T_FS_ReceiveAccount SET FCheckerId = null, FLastHandlerId = null, FStatus = ? WHERE FID = ? ";
        Object[] params = new Object[]{"undealed", billId};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    public static void signBackBill(Context ctx, String billId, String result) throws BOSException {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String userId = user.getId().toString();
        String sql = "UPDATE T_FS_ReceiveAccount SET FResult = ?, FBackerId = ?, FLastHandlerId = ?, FStatus = ? WHERE FID = ? ";
        Object[] params = new Object[]{result, userId, userId, "backBilled", billId};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    public static void signSettle(Context ctx, String billId) throws BOSException, EASBizException {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String userId = user.getId().toString();
        String sql = "UPDATE T_FS_ReceiveAccount SET FCashierId = ?, FLastHandlerId = ?, FStatus = ? WHERE FID = ?";
        Object[] params = new Object[]{userId, userId, "settleed", billId};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        ReceiveAcctHelper.signSettlementBill(ctx, billId, userId);
    }

    private static void signSettlementBill(Context ctx, String billId, String userId) throws BOSException, EASBizException {
        ReceiveAccountInfo info = ReceiveAccountFactory.getLocalInstance(ctx).getReceiveAccountInfo((IObjectPK)new ObjectUuidPK(billId));
        if (info == null || info.getSrcSettlementBill() == null) {
            return;
        }
        String srcBillId = info.getSrcSettlementBill().getId().toString();
        String sql = "UPDATE T_FS_SettlementBill SET FCashierID = ? WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{userId, srcBillId});
    }

    public static void signAntiSettle(Context ctx, String billId) throws BOSException, EASBizException {
        String sql = "UPDATE T_FS_ReceiveAccount SET FCashierId = NULL, FLastHandlerId = FCheckerId, FStatus = ? WHERE FID = ?";
        Object[] params = new Object[]{"checked", billId};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        ReceiveAcctHelper.signAntiSettlementBill(ctx, billId);
    }

    private static void signAntiSettlementBill(Context ctx, String billId) throws BOSException, EASBizException {
        ReceiveAccountInfo info = ReceiveAccountFactory.getLocalInstance(ctx).getReceiveAccountInfo((IObjectPK)new ObjectUuidPK(billId));
        if (info == null || info.getSrcSettlementBill() == null) {
            return;
        }
        String srcBillId = info.getSrcSettlementBill().getId().toString();
        String sql = "UPDATE T_FS_SettlementBill SET FCashierID = NULL WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{srcBillId});
    }

    public static void signVoucher(Context ctx, String billId) throws BOSException {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String userId = user.getId().toString();
        String sql = "UPDATE T_FS_ReceiveAccount SET FAccountantId = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userId, billId});
    }

    public static void signDelVoucher(Context ctx, String billId) throws BOSException {
        String sql = "UPDATE T_FS_ReceiveAccount SET FAccountantId = NULL WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
    }

    public static void writeDownBillId(Context ctx, String billId, String downBillId) throws BOSException, EASBizException {
        String sql = "UPDATE T_FS_ReceiveAccount SET FDownBillId = ? WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{downBillId, billId});
    }

    public static void genDownBill(Context ctx, ReceiveAccountInfo recInfo, boolean isConfirmCh, boolean isAcceptCh, boolean isBackBill, SendRecAcctTypeEnum type) throws BOSException, EASBizException {
        String recBillId = recInfo.getId().toString();
        IRecAcctCheckBuilder builder = ReceiveAcctHelper.getBuilder(isBackBill, isConfirmCh, isAcceptCh, type);
        BillBaseInfo downBillInfo = builder.getBillBaseInfo(ctx, recBillId);
        if (downBillInfo != null) {
            SettlementBillInfo info;
            String downBillId = downBillInfo.getId().toString();
            IBillBase iBillBase = ReceiveAcctHelper.getBizInterface(ctx, downBillId);
            iBillBase.submit((CoreBaseInfo)downBillInfo);
            if (iBillBase instanceof ISettlementBill && !(info = ((ISettlementBill)iBillBase).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(downBillId))).isIsAccepted()) {
                ArrayList<String> idList = new ArrayList<String>();
                idList.add(downBillId);
                SettleFacadeFactory.getLocalInstance(ctx).accept(idList);
            }
            HashMap<String, String> idMap = new HashMap<String, String>();
            idMap.put(recBillId, downBillId);
            FMHelper.saveBOTRelation((Context)ctx, idMap);
            ReceiveAcctHelper.writeDownBillId(ctx, recBillId, downBillId);
        }
    }

    public static void deleteDownBill(Context ctx, String downBillId) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)downBillId)) {
            return;
        }
        IBillBase iBillBase = ReceiveAcctHelper.getBizInterface(ctx, downBillId);
        if (iBillBase instanceof ISettlementBill) {
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(downBillId);
            SettleFacadeFactory.getLocalInstance(ctx).cancelAccept(idList, false);
        }
        iBillBase.delete((IObjectPK)new ObjectUuidPK(downBillId));
    }

    private static IBillBase getBizInterface(Context ctx, String billId) throws BOSException {
        Object iBillBase = null;
        BOSObjectType bosType = BOSUuid.read((String)billId).getType();
        if (bosType.equals((Object)new SettlementBillInfo().getBOSType())) {
            iBillBase = SettlementBillFactory.getLocalInstance(ctx);
        } else if (bosType.equals((Object)new SendAccountInfo().getBOSType())) {
            iBillBase = SendAccountFactory.getLocalInstance(ctx);
        }
        return iBillBase;
    }

    public static void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        if (e == null || e.getLastRow() == -1) {
            return;
        }
        tblMain.checkParsed();
        IRow row = null;
        String currencyId = null;
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell("currency.id").getValue();
            if (currencyId == null) continue;
            FMClientHelper.setNumberFormat((IRow)row, (String)"amount", (String)currencyId);
        }
    }

    public static RecAcctVoucherEnum getRecAcctVoucherEnum(String companyId, String confirmCompanyId, String acceptCompanyId) {
        if (companyId.equals(confirmCompanyId)) {
            return RecAcctVoucherEnum.CONFIRMCH;
        }
        if (companyId.equals(acceptCompanyId)) {
            return RecAcctVoucherEnum.ACCEPTCH;
        }
        return RecAcctVoucherEnum.NONE;
    }
}

