/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class SettlementSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    protected SettlementBillInfo settleInfo = null;

    public SettlementSubsidiaryBookProvider() {
    }

    public SettlementSubsidiaryBookProvider(SettlementBillInfo settleInfo) {
        this.settleInfo = settleInfo;
    }

    @Override
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        if (this.settleInfo == null) {
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(billId);
            return this.getCollection(ctx, idSet);
        }
        SettlementBillCollection coll = new SettlementBillCollection();
        coll.add(this.settleInfo);
        return this.getCollection(ctx, coll);
    }

    public SubsidiaryLedgerCollection getCollection(Context ctx, Set ids) throws BOSException, EASBizException {
        SettlementBillCollection coll = this.getSettleBillCo4Accept(ctx, ids);
        return this.getCollection(ctx, coll);
    }

    private SubsidiaryLedgerCollection getCollection(Context ctx, SettlementBillCollection coll) throws EASBizException, BOSException {
        int size = coll.size();
        SubsidiaryLedgerCollection subsidiaryColl = new SubsidiaryLedgerCollection();
        for (int i = 0; i < size; ++i) {
            SettlementBillInfo info = coll.get(i);
            subsidiaryColl.addCollection(this.createSubsidiaryLedgerBills(ctx, info, true, true));
        }
        return subsidiaryColl;
    }

    public SubsidiaryLedgerCollection getPayeeOrPayerCollection(Context ctx, Set ids, boolean isCreatePayee, boolean isCreatePayer) throws BOSException, EASBizException {
        SettlementBillCollection coll = this.getSettleBillCo4Accept(ctx, ids);
        int size = coll.size();
        SubsidiaryLedgerCollection subsidiaryColl = new SubsidiaryLedgerCollection();
        for (int i = 0; i < size; ++i) {
            SettlementBillInfo info = coll.get(i);
            subsidiaryColl.addCollection(this.createSubsidiaryLedgerBills(ctx, info, isCreatePayee, isCreatePayer));
        }
        return subsidiaryColl;
    }

    public SettlementBillCollection getSettleBillCo4Accept(Context ctx, Set ids) throws BOSException {
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("settleType.payThroughBE");
        cel.add("payeeInnerAcct.id");
        cel.add("payeeInnerAcct.name");
        cel.add("payeeInnerAcct.*");
        cel.add("payeeInnerAcct.company.*");
        cel.add("payeeInnerAcct.applyUnit.id");
        cel.add("payeeInnerAcct.clhClassification.id");
        cel.add("payeeInnerAcct.clhClassification.*");
        cel.add("payerInnerAcct.id");
        cel.add("payerInnerAcct.name");
        cel.add("payerInnerAcct.*");
        cel.add("payerInnerAcct.number");
        cel.add("payerInnerAcct.clhClassification.id");
        cel.add("payerInnerAcct.clhClassification.*");
        cel.add("payerInnerAcct.company.*");
        cel.add("payerInnerAcct.applyUnit.id");
        cel.add("payerBankAcct.*");
        cel.add("payeeBankAcct.*");
        ISettlementBill iSettlementBill = SettlementBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().addObjectCollection((IObjectCollection)cel);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        SettlementBillCollection coll = iSettlementBill.getSettlementBillCollection(view);
        return coll;
    }

    public SubsidiaryLedgerCollection createSubsidiaryLedgerBills(Context ctx, SettlementBillInfo settleInfo, boolean isCreatePayee, boolean isCreatePayer) throws EASBizException, BOSException {
        CompanyOrgUnitInfo chCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String companyId = chCompany.getId().toString();
        String payerInnerAcctCompanyId = null;
        String payeeInnerAcctCompanyId = null;
        int type = settleInfo.getType().getValue();
        SubsidiaryLedgerCollection subLedgerColl = new SubsidiaryLedgerCollection();
        switch (type) {
            case 2: 
            case 10: {
                if (settleInfo.getPayerInnerAcct() == null) break;
                subLedgerColl.addCollection(this.createPayerSubsidiaryLedger(ctx, settleInfo));
                break;
            }
            case 100: {
                if (settleInfo.getPayerInnerAcct() == null) break;
                subLedgerColl.addCollection(this.createPayerSubsidiaryLedger(ctx, settleInfo));
                break;
            }
            case 1: {
                if (settleInfo.getPayeeInnerAcct() == null) break;
                subLedgerColl.addCollection(this.createPayeeSubsidiaryLedger(ctx, settleInfo));
                break;
            }
            case 4: {
                if (settleInfo.getPayerInnerAcct() != null) {
                    payerInnerAcctCompanyId = settleInfo.getPayerInnerAcct().getCompany().getId().toString();
                }
                if (settleInfo.getPayeeInnerAcct() != null) {
                    payeeInnerAcctCompanyId = settleInfo.getPayeeInnerAcct().getCompany().getId().toString();
                }
                if (payerInnerAcctCompanyId != null && settleInfo.isIsDlByPay() && isCreatePayer) {
                    subLedgerColl.addCollection(this.createPayerSubsidiaryLedger(ctx, settleInfo));
                }
                if (payeeInnerAcctCompanyId == null || !settleInfo.isIsDlByRec() || !isCreatePayee) break;
                subLedgerColl.addCollection(this.createPayeeSubsidiaryLedger(ctx, settleInfo));
                break;
            }
            case 3: {
                if (settleInfo.getPayerInnerAcct() != null) {
                    payerInnerAcctCompanyId = settleInfo.getPayerInnerAcct().getCompany().getId().toString();
                }
                if (settleInfo.getPayeeInnerAcct() != null) {
                    payeeInnerAcctCompanyId = settleInfo.getPayeeInnerAcct().getCompany().getId().toString();
                }
                if (payerInnerAcctCompanyId != null && settleInfo.isIsDlByPay() && isCreatePayer) {
                    subLedgerColl.addCollection(this.createPayerSubsidiaryLedger(ctx, settleInfo));
                }
                if (payeeInnerAcctCompanyId == null || !settleInfo.isIsDlByRec() || !isCreatePayee) break;
                subLedgerColl.addCollection(this.createPayeeSubsidiaryLedger(ctx, settleInfo));
                break;
            }
            case 52: {
                if (settleInfo.getPayerInnerAcct() != null) {
                    payerInnerAcctCompanyId = settleInfo.getPayerInnerAcct().getCompany().getId().toString();
                }
                if (settleInfo.getPayeeInnerAcct() != null) {
                    payeeInnerAcctCompanyId = settleInfo.getPayeeInnerAcct().getCompany().getId().toString();
                }
                if (payerInnerAcctCompanyId != null && settleInfo.isIsDlByPay()) {
                    subLedgerColl.addCollection(this.createPayerSubsidiaryLedger(ctx, settleInfo));
                }
                if (payeeInnerAcctCompanyId == null || !settleInfo.isIsDlByRec()) break;
                subLedgerColl.addCollection(this.createPayeeSubsidiaryLedger(ctx, settleInfo));
                break;
            }
            case 51: {
                if (settleInfo.getPayerInnerAcct() != null) {
                    payerInnerAcctCompanyId = settleInfo.getPayerInnerAcct().getCompany().getId().toString();
                }
                if (settleInfo.getPayeeInnerAcct() != null) {
                    payeeInnerAcctCompanyId = settleInfo.getPayeeInnerAcct().getCompany().getId().toString();
                }
                if (payerInnerAcctCompanyId != null && settleInfo.isIsDlByPay()) {
                    subLedgerColl.addCollection(this.createPayerSubsidiaryLedger(ctx, settleInfo));
                }
                if (payeeInnerAcctCompanyId == null || !settleInfo.isIsDlByRec()) break;
                subLedgerColl.addCollection(this.createPayeeSubsidiaryLedger(ctx, settleInfo));
            }
        }
        return subLedgerColl;
    }

    private SubsidiaryLedgerCollection createPayerSubsidiaryLedger(Context ctx, SettlementBillInfo settlementBill) throws EASBizException, BOSException {
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        SubsidiaryLedgerInfo depositInfo = this.createSubBaseInfo(ctx, settlementBill);
        depositInfo.setDebitAmount(Constants.ZERO);
        depositInfo.setCreditAmount(settlementBill.getAmount());
        depositInfo.setCompany(settlementBill.getPayerInnerAcct().getCompany());
        depositInfo.setApplyUnit(settlementBill.getPayerInnerAcct().getApplyUnit());
        depositInfo.setInnerAccount(settlementBill.getPayerInnerAcct());
        depositInfo.setCurrency(settlementBill.getCurrency());
        depositInfo.setCpInnerAccount(settlementBill.getPayeeInnerAcct());
        depositInfo.setCpCurrency(settlementBill.getCurrency());
        depositInfo.setSettleType(settlementBill.getInnerSetteType());
        depositInfo.setSettleNumber(settlementBill.getInnerSettleNumber());
        depositInfo.setFpitem(settlementBill.getPayerPlanItem());
        coll.add(depositInfo);
        return coll;
    }

    private SubsidiaryLedgerCollection createPayeeSubsidiaryLedger(Context ctx, SettlementBillInfo settlementBill) throws EASBizException, BOSException {
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        SubsidiaryLedgerInfo depositInfo = this.createSubBaseInfo(ctx, settlementBill);
        depositInfo.setDebitAmount(settlementBill.getAmount());
        depositInfo.setCreditAmount(Constants.ZERO);
        depositInfo.setCompany(settlementBill.getPayeeInnerAcct().getCompany());
        depositInfo.setApplyUnit(settlementBill.getPayeeInnerAcct().getApplyUnit());
        depositInfo.setInnerAccount(settlementBill.getPayeeInnerAcct());
        depositInfo.setCurrency(settlementBill.getCurrency());
        depositInfo.setCpInnerAccount(settlementBill.getPayerInnerAcct());
        depositInfo.setCpCurrency(settlementBill.getCurrency());
        depositInfo.setSettleType(settlementBill.getInnerSetteType());
        depositInfo.setSettleNumber(settlementBill.getInnerSettleNumber());
        depositInfo.setFpitem(settlementBill.getPayeePlanItem());
        coll.add(depositInfo);
        return coll;
    }

    private SubsidiaryLedgerInfo createSubBaseInfo(Context ctx, SettlementBillInfo settlementBill) throws EASBizException, BOSException {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        SubsidiaryLedgerInfo info = new SubsidiaryLedgerInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        BankInfo clearingHouse = FSHelper.getClearingHouseInfo(ctx, settlementBill.getCompany().getId().toString());
        String companyId = settlementBill.getCompany().getId().toString();
        String tm119 = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("TM119", (IObjectPK)new ObjectUuidPK(companyId));
        if (settlementBill.getAcceptedDate() != null) {
            if (settlementBill.getAcceptedDate().after(clearingHouse.getSettleDate())) {
                info.setDate(settlementBill.getAcceptedDate());
            } else {
                info.setDate(clearingHouse.getSettleDate());
            }
        } else if (settlementBill.getBizDate().after(clearingHouse.getSettleDate())) {
            info.setDate(settlementBill.getBizDate());
        } else {
            info.setDate(clearingHouse.getSettleDate());
        }
        if ("1".equals(tm119)) {
            if (this.isBookSubInSettle(ctx, settlementBill.getType(), companyId)) {
                Date currentDate = new Date();
                if (info.getDate().before(currentDate)) {
                    info.setDate(DateTimeUtils.truncateDate((Date)currentDate));
                }
            }
        } else if ("2".equals(tm119) && settlementBill.getSettleType() != null && settlementBill.getSettleType().isPayThroughBE() && this.isBookSubInSettle(ctx, settlementBill.getType(), companyId)) {
            Date currentDate = new Date();
            if (info.getDate().before(currentDate)) {
                info.setDate(DateTimeUtils.truncateDate((Date)currentDate));
            }
        }
        if (settlementBill.getType().equals((Object)SettBizTypeEnum.LINKPAY)) {
            info.setBizType(SubsidiaryBillTypeEnum.getEnum(5));
        } else {
            info.setBizType(SubsidiaryBillTypeEnum.getEnum(settlementBill.getType().getValue()));
        }
        info.setBillNumber(settlementBill.getNumber());
        info.setBillId(settlementBill.getId());
        info.setPayerBankAcct(settlementBill.getPayerBankAcctNum());
        info.setPayeeBankAcct(settlementBill.getPayeeBankAcctNum());
        info.setExchangeRate(settlementBill.getExchange());
        info.setBookkeeper(user);
        info.setDescription(settlementBill.getDescription());
        info.setIsDownLoad(false);
        return info;
    }

    private boolean isBookSubInSettle(Context ctx, SettBizTypeEnum bizType, String companyId) {
        boolean val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM013", (IObjectPK)new ObjectUuidPK(companyId));
        boolean val_rec = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM101", (IObjectPK)new ObjectUuidPK(companyId));
        boolean isPayout = SettBizTypeEnum.PAYOUTSIDE == bizType || SettBizTypeEnum.PAYOUTDIFFCUR == bizType || SettBizTypeEnum.LINKPAY == bizType;
        boolean isRec = SettBizTypeEnum.RECOUTSIDE == bizType;
        return val && isPayout || val_rec && isRec;
    }
}

