/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IRptHandler;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fs.AvgTypeEnum;
import com.kingdee.eas.fm.fs.IInAcct;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.client.AvgAnalysisFilterParam;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class AbstractAvgAnalysisHandler
implements IRptHandler {
    protected static final int AVG_QUARTER = 1;
    protected static final int AVG_MONTH = 0;
    protected static final int AVG_YEAR = 2;

    public abstract void initTree(AvgAnalysisFilterParam var1, KDTree var2) throws BOSException;

    public abstract void initTable(AvgAnalysisFilterParam var1, KDTable var2) throws BOSException;

    public abstract void fillData(AvgAnalysisFilterParam var1, Object var2, KDTable var3, EntityViewInfo var4) throws SQLException, EASBizException, BOSException;

    public void setCurrencyFormat(KDTable tblMain, AvgAnalysisFilterParam param) {
        String numberFtm = param.getCurrencyId() == null ? "%r-[ ]{###,###,##0.00}15.2n" : FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)param.getCurrencyId()));
        for (int i = 2; i < tblMain.getColumnCount(); ++i) {
            tblMain.getColumn(i).getStyleAttributes().setNumberFormat(numberFtm);
            tblMain.getColumn(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    protected void setNumberFormat(IRow row, String columnKey, String currencyID) {
        String numberFormat = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyID));
        row.getCell(columnKey).getStyleAttributes().setNumberFormat(numberFormat);
    }

    protected void fillEnumData(AvgAnalysisFilterParam param, CompanyOrgUnitInfo company, IInAcct inacct, CycleRangeInfo info, KDTable tblMain, CurrencyInfo currency, String colName) throws BOSException, EASBizException {
        BigDecimal avg = null;
        AvgTypeEnum avgTypeEnum = null;
        ArrayList<AvgTypeEnum> list = new ArrayList<AvgTypeEnum>();
        list.add(AvgTypeEnum.CASH);
        list.add(AvgTypeEnum.DEPOSIT);
        int listSize = list.size();
        IRow row = tblMain.addRow();
        int flag = 0;
        for (int k = 0; k < listSize; ++k) {
            avgTypeEnum = (AvgTypeEnum)((Object)list.get(k));
            avg = this.getAvg(company, inacct, info, currency, avgTypeEnum);
            String headName = avgTypeEnum.getName();
            row.getCell(headName).setValue((Object)avg);
            if (avg.compareTo(Constants.ZERO) == 0) continue;
            ++flag;
        }
        if (colName.equals("company")) {
            row.getCell(colName).setValue((Object)company.toString());
        } else {
            row.getCell(colName).setValue((Object)info.toString());
        }
        row.getCell("currency").setValue((Object)currency.getName());
        if (flag == 0) {
            tblMain.removeRow(tblMain.getRowCount() - 1);
        }
    }

    private BigDecimal getAvg(CompanyOrgUnitInfo company, IInAcct inacct, CycleRangeInfo info, CurrencyInfo currency, AvgTypeEnum avgTypeEnum) throws BOSException, EASBizException {
        BigDecimal avg;
        ICashManagement cashInacct = CashManagementFactory.getRemoteInstance();
        switch (avgTypeEnum.getValue()) {
            case 3: {
                avg = inacct.inAcct(company.getNumber(), null, currency.getNumber(), info.getBeginDate(), info.getEndDate(), InAcctDataTypeEnum.WAY);
                break;
            }
            case 1: {
                avg = Constants.ZERO;
                if (company.getAccountTable() == null) {
                    return avg;
                }
                avg = cashInacct.cash(company.getNumber(), CashDataSourceEnum.C, company.getAccountTable().getNumber(), null, null, currency.getNumber(), info.getBeginDate(), info.getEndDate(), CashDataTypeEnum.AY, false);
                break;
            }
            default: {
                avg = Constants.ZERO;
                if (company.getAccountTable() == null) {
                    return avg;
                }
                avg = cashInacct.cash(company.getNumber(), CashDataSourceEnum.B, company.getAccountTable().getNumber(), null, null, currency.getNumber(), info.getBeginDate(), info.getEndDate(), CashDataTypeEnum.AY, false);
            }
        }
        return avg;
    }

    protected CompanyOrgUnitCollection getAllCompanyOrgUnit() throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add("name");
        ev.getSelector().add("number");
        ev.getSelector().add("accountTable.id");
        ev.getSelector().add("accountTable.number");
        CompanyOrgUnitCollection coll = null;
        ICompanyOrgUnit company = CompanyOrgUnitFactory.getRemoteInstance();
        coll = company.getCompanyOrgUnitCollection(ev);
        return coll;
    }
}

