/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.common.HashSearchEngine;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.IInnerAccountInit;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.InnerAccountInitFactory;
import com.kingdee.eas.fm.fs.SummaryLedgerCollection;
import com.kingdee.eas.fm.fs.SummaryLedgerInfo;
import com.kingdee.eas.fm.fs.client.DepositInitHandler;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.client.EASResource;
import java.util.Date;
import java.util.Iterator;

public abstract class AbstractInitHandler {
    public final String[] strArray = new String[]{"applyUnit.number", "applyUnit", "innerAccount.number"};
    public static final String DEP_COL = "depositor";
    public static final String INN_COL = "innerAccount";
    public static final String BAN_COL = "bankAccount";
    public static final String DEB_COL = "debit";
    public static final String CRE_COL = "credit";
    public static final String BAL_COL = "balance";
    public static final String COMNUMBER_COL = "companyNum";
    public static final String INACCTNUM_COL = "inacctNum";
    private CurrencyInfo currency;
    private Date beginDate;
    public static final String resPath = "com.kingdee.eas.fm.fs.FSClientResource";
    public static final String DEPOSITOR = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"depositor");
    public static final String INNERACCT = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"innerAcct");
    public static final String YEARDEBITAMT = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"yearDebitAmt");
    public static final String YEARCREDITAMT = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"yearCreditAmt");
    public static final String OPENBALANCE = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"openBalance");
    public static final String SAVESUCCEED = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"saveSucceed");
    public static final String YEARDEBITCOUNT = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"yearDebitCount");
    public static final String YEARCREDITCOUNT = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"yearCreditCount");
    public static final String COMPANYNUM = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"companynum");
    public static final String INACCTNUM = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"inacctnum");
    public static final String BANKACCT = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"bankAcct");
    protected BankInfo clearingHouseInfo = null;

    public static AbstractInitHandler getInstance() {
        DepositInitHandler handler = null;
        handler = new DepositInitHandler();
        return handler;
    }

    public BankInfo getClearingHouseInfo() {
        return this.clearingHouseInfo;
    }

    public void setClearingHouseInfo(BankInfo clearingHouseInfo) {
        this.clearingHouseInfo = clearingHouseInfo;
    }

    public void initTable(KDTable table, boolean isFirstDay) {
        table.getColumn(DEP_COL).setMergeable(true);
        table.getColumn(DEP_COL).setGroup(true);
        table.getColumn(INN_COL).setMergeable(true);
        table.getColumn(INN_COL).setGroup(true);
        table.getMergeManager().setMergeMode(5);
        table.getGroupManager().setGroup(true);
    }

    public void save() {
    }

    public void exportExcel() {
    }

    public void importExcel() {
    }

    private SummaryLedgerCollection getCurrentSLC() throws BOSException, Exception {
        IInnerAccountInit manager = InnerAccountInitFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        FilterItemInfo currency = new FilterItemInfo("currency", (Object)this.getCurrency().getId(), CompareType.EQUALS);
        if (this.clearingHouseInfo == null) {
            this.clearingHouseInfo = FSClientHelper.getClearingHouse();
        }
        FilterItemInfo bizDate = new FilterItemInfo("bizDate", (Object)this.clearingHouseInfo.getOpenDate(), CompareType.LESS);
        FilterItemInfo bizNullDate = new FilterItemInfo("bizDate", null, CompareType.EQUALS);
        fic.add(currency);
        fic.add(bizDate);
        fic.add(bizNullDate);
        fic.add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        fi.setMaskString("#0 and (#1 or #2) and #3");
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("innerAccount.*"));
        SorterItemCollection sorter = evi.getSorter();
        sorter.add(new SorterItemInfo("company.name"));
        sorter.add(new SorterItemInfo("innerAccount.name"));
        SummaryLedgerCollection slCol = (SummaryLedgerCollection)manager.getColl(evi);
        return slCol;
    }

    private SummaryLedgerCollection createNewSLC() throws Exception {
        SummaryLedgerCollection newCol = new SummaryLedgerCollection();
        InnerAccountCollection iac = this.getInnerAcctCol();
        if (iac == null) {
            return null;
        }
        Iterator iter = iac.iterator();
        while (iter.hasNext()) {
            InnerAccountInfo innerAcctInfo = (InnerAccountInfo)iter.next();
            SummaryLedgerInfo selfCapitalSLI = new SummaryLedgerInfo();
            selfCapitalSLI.setCompany(innerAcctInfo.getCompany());
            selfCapitalSLI.setApplyUnit(innerAcctInfo.getApplyUnit());
            selfCapitalSLI.setInnerAccount(innerAcctInfo);
            innerAcctInfo.setDisplayFormat("$number$-$name$");
            newCol.add(selfCapitalSLI);
        }
        return newCol;
    }

    public SummaryLedgerCollection getColl() throws Exception {
        SummaryLedgerCollection coll = this.createNewSLC();
        SummaryLedgerCollection slCol = this.getCurrentSLC();
        HashSearchEngine searchEngin = new HashSearchEngine((IObjectCollection)coll, new String[]{INN_COL});
        int i = 0;
        if (slCol != null && slCol.size() > 0) {
            Iterator iter = slCol.iterator();
            while (iter.hasNext()) {
                SummaryLedgerInfo info = (SummaryLedgerInfo)iter.next();
                if (!searchEngin.evaluate((IObjectValue)info)) continue;
                SummaryLedgerInfo emptyInfo = (SummaryLedgerInfo)searchEngin.getResult();
                emptyInfo.setDebitTotal(info.getDebitTotal());
                emptyInfo.setCreditTotal(info.getCreditTotal());
                emptyInfo.setEndBalance(info.getEndBalance());
                emptyInfo.setDebitCounts(info.getDebitCounts());
                emptyInfo.setCreditCounts(info.getCreditCounts());
                ++i;
            }
        }
        return coll;
    }

    public void loadField(KDTable table) throws Exception {
        table.getColumn(DEP_COL).setMergeable(true);
        table.getColumn(DEP_COL).setGroup(true);
        table.getColumn(INN_COL).setMergeable(true);
        table.getColumn(INN_COL).setGroup(true);
        table.getMergeManager().setMergeMode(5);
        table.getGroupManager().setGroup(true);
    }

    public void loadField(KDTable table, SummaryLedgerCollection summaryColl) {
    }

    public SummaryLedgerCollection storeField(KDTable table) throws Exception {
        return null;
    }

    public void importGL() {
    }

    protected InnerAccountCollection getInnerAcctCol() throws Exception {
        IInnerAccount manager = InnerAccountFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        if (this.clearingHouseInfo == null) {
            this.clearingHouseInfo = FSClientHelper.getClearingHouse();
        }
        FilterItemInfo fii = new FilterItemInfo("openDepositDate", (Object)this.clearingHouseInfo.getOpenDate(), CompareType.LESS);
        fic.add(fii);
        fic.add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        evi.setFilter(fi);
        SelectorItemCollection sci = evi.getSelector();
        sci.add(new SelectorItemInfo("id"));
        sci.add(new SelectorItemInfo("*"));
        sci.add(new SelectorItemInfo("company.name"));
        sci.add(new SelectorItemInfo("company.id"));
        sci.add(new SelectorItemInfo("applyUnit.name"));
        sci.add(new SelectorItemInfo("applyUnit.id"));
        sci.add(new SelectorItemInfo("applyUnit.number"));
        evi.getSorter().add(new SorterItemInfo("applyUnit.name"));
        evi.getSorter().add(new SorterItemInfo("name"));
        InnerAccountCollection innerAcctCol = manager.getInnerAccountCollection(evi);
        return innerAcctCol;
    }

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currency = currency;
    }

    public FilterInfo getFilterInfo() throws Exception {
        return null;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public void setColumnLocked(KDTable table) {
    }
}

