/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class AmusementUI
extends CoreUIObject {
    public static void createAmusementUI(CoreUIObject setUI) {
        try {
            IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
            UIContext uiContext = new UIContext((Object)setUI);
            IUIWindow wnd = fy.create("com.kingdee.eas.fm.fs.client.AmusementUI", (Map)uiContext);
            wnd.show();
        }
        catch (UIException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public static void createInThisUI(CoreUIObject setUI) {
        AmusementUI amuse = null;
        try {
            amuse = new AmusementUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        setUI.setLayout(null);
        SecureRandom random = new SecureRandom();
        AmusementUI amusementUI = amuse;
        ((Object)((Object)amusementUI)).getClass();
        BoundBall ball = amusementUI.new BoundBall(random.nextInt(setUI.getWidth()), random.nextInt(setUI.getHeight()), 5, random.nextInt(15), random.nextInt(360), setUI.getWidth(), setUI.getHeight() - 20);
        ball.addAreasByComponents(setUI.getComponents());
        setUI.add((Component)ball);
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setLayout(null);
        SecureRandom random = new SecureRandom();
        WeightBall ball = new WeightBall(random.nextInt(500), random.nextInt(500), random.nextInt(90));
        ball.setSpeed(10.0f);
        ball.setWindowHeight(800);
        ball.setWindowWidth(900);
        this.add(ball);
    }

    public class ClickBall
    extends WindowMoveBall {
        public ClickBall(int x, int y, int acr) {
            super(x, y, acr);
            this.setTextColor(Color.BLACK);
            this.setText("0");
            Color newColor = new Color(this.color.getRed(), this.color.getGreen(), this.color.getGreen(), 100);
            this.setColor(newColor);
        }

        @Override
        protected void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClickBall.this.setColor(ClickBall.this.getNextColor());
                    int i = Integer.parseInt(ClickBall.this.text);
                    ClickBall.this.setText(++i + "");
                }
            });
        }

        private Color getNextColor() {
            int alpha = this.getColor().getAlpha() - 10;
            if (alpha < 0) {
                alpha = 0;
            }
            Color newColor = new Color(this.color.getRed(), this.color.getGreen(), this.color.getGreen(), alpha);
            return newColor;
        }
    }

    public class WeightBall
    extends WindowMoveBall {
        @Override
        protected Point getNextPos() {
            Point point = super.getNextPos();
            point.setLocation((double)point.x, (double)point.y * 1.01);
            return point;
        }

        public WeightBall(int x, int y, int acr) {
            super(x, y, acr);
        }
    }

    public class BoundBall
    extends WindowMoveBall {
        List areaList;

        public BoundBall(int x, int y, int acr, int speed, int initDirection, int windowWidth, int windowHeight) {
            super(x, y, acr, speed, initDirection, windowWidth, windowHeight);
            this.areaList = new ArrayList();
        }

        public BoundBall(int x, int y, int acr) {
            super(x, y, acr);
            this.areaList = new ArrayList();
        }

        @Override
        protected Point getNextPos() {
            Point nextPoint = super.getNextPos();
            for (int i = 0; i < this.areaList.size(); ++i) {
                IArea area = (IArea)this.areaList.get(i);
                if (area.pointInArea(this.center)) {
                    return nextPoint;
                }
                if (!area.pointInArea(nextPoint)) continue;
                if (area.xInArea(this.center.x)) {
                    this.reboundByX();
                    return new Point(this.center.x + (nextPoint.x - this.center.x) / 2, this.center.y);
                }
                if (area.yInArea(this.center.y)) {
                    this.reboundByY();
                    return new Point(this.center.x, this.center.y + (nextPoint.y - this.center.y) / 2);
                }
                this.direction -= 180;
                this.adjustDirection();
            }
            return nextPoint;
        }

        public void addAreasByComponents(Component[] components) {
            for (int i = 0; i < components.length; ++i) {
                Component component = components[i];
                RectArea area = new RectArea(component.getLocation(), component.getWidth(), component.getHeight());
                this.areaList.add(area);
            }
        }

        public void addArea(IArea area) {
            this.areaList.add(area);
        }
    }

    public class WindowMoveBall
    extends LineMoveBall {
        private int windowWidth;
        private int windowHeight;

        public WindowMoveBall(int x, int y, int acr) {
            this(x, y, acr, 2000, 2000);
        }

        public WindowMoveBall(int x, int y, int acr, int windowWidth, int windowHeight) {
            super(x, y, acr);
            this.windowWidth = windowWidth;
            this.windowHeight = windowHeight;
            if (x < acr) {
                x = acr;
            }
            if (y < acr) {
                y = acr;
            }
        }

        public WindowMoveBall(int x, int y, int acr, int speed, int initDirection, int windowWidth, int windowHeight) {
            this(x, y, acr, windowWidth, windowHeight);
            this.speed = speed;
            this.direction = initDirection;
        }

        @Override
        protected Point getNextPos() {
            Point nextPos = super.getNextPos();
            int nextX = nextPos.x;
            int nextY = nextPos.y;
            if (nextX - this.acr < 0 || nextX + this.acr > this.windowWidth) {
                this.reboundByY();
                return this.center;
            }
            if (nextY - this.acr < 0 || nextY + this.acr > this.windowHeight) {
                this.reboundByX();
                return this.center;
            }
            return nextPos;
        }

        public void reboundByY() {
            this.direction = 360 - this.direction;
            this.adjustDirection();
        }

        public void reboundByX() {
            this.direction = 180 - this.direction;
            this.adjustDirection();
        }

        public int getWindowHeight() {
            return this.windowHeight;
        }

        public void setWindowHeight(int windowHeight) {
            this.windowHeight = windowHeight;
        }

        public int getWindowWidth() {
            return this.windowWidth;
        }

        public void setWindowWidth(int windowWidth) {
            this.windowWidth = windowWidth;
        }
    }

    public class LineMoveBall
    extends MoveBall {
        protected int direction;

        public LineMoveBall(Point center, int acr) {
            super(center.x, center.y, acr);
        }

        public LineMoveBall(int x, int y, int acr) {
            super(x, y, acr);
            this.direction = 45;
        }

        public LineMoveBall(int x, int y, int acr, int speed) {
            this(x, y, acr, speed, 45);
        }

        public LineMoveBall(int x, int y, int acr, int speed, int direction) {
            super(x, y, acr, speed);
            this.direction = direction;
        }

        @Override
        protected Point getNextPos() {
            int nextX = this.center.x + new Double((double)(this.speed + 1.0f) * Math.sin((double)(this.direction * 2) * Math.PI / 360.0)).intValue();
            int nextY = this.center.y + new Double((double)(this.speed + 1.0f) * Math.cos((double)(this.direction * 2) * Math.PI / 360.0)).intValue();
            return new Point(nextX, nextY);
        }

        public void adjustDirection() {
            while (this.direction < 0) {
                this.direction += 360;
            }
            while (this.direction > 360) {
                this.direction -= 360;
            }
        }
    }

    public class MoveBall
    extends Ball {
        private Timer timer;
        private TimerTask task;
        public float speed;

        protected void finalize() throws Throwable {
            super.finalize();
            this.destroy();
        }

        @Override
        protected void destroy() {
            this.task.cancel();
            this.timer.cancel();
        }

        private void setTimer() {
            this.task = new TimerTask(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MoveBall.this.vefityThread();
                            MoveBall.this.setPos(MoveBall.this.getNextPos());
                        }
                    });
                }
            };
            this.timer.schedule(this.task, 0L, 50L);
        }

        public MoveBall(Point center, int acr) {
            this(center, acr, 0);
        }

        public MoveBall(int x, int y, int acr) {
            this(x, y, acr, 0);
        }

        public MoveBall(Point center, int acr, int speed) {
            this(center.x, center.y, acr, speed);
        }

        public MoveBall(int x, int y, int acr, int speed) {
            super(x, y, acr);
            this.timer = new Timer(true);
            this.task = null;
            this.speed = speed;
            if (speed != -1) {
                this.setTimer();
            }
        }

        public void setSpeed(float speed) {
            this.speed = speed;
        }

        protected Point getNextPos() {
            return this.center;
        }

        private void vefityThread() {
        }
    }

    public class Ball
    extends JComponent {
        public Color color;
        public Color textColor;
        public Point center;
        public int acr;
        public String text;
        public SecureRandom random = new SecureRandom();

        protected void mouseReleased(MouseEvent e) {
        }

        protected void mousePressed(MouseEvent e) {
        }

        protected void mouseExited(MouseEvent e) {
        }

        protected void mouseEntered(MouseEvent e) {
        }

        protected void mouseClicked(MouseEvent e) {
        }

        protected void mouseMoved(MouseEvent e) {
        }

        protected void mouseDragged(MouseEvent e) {
        }

        public Ball(Point center, int acr) {
            this(center.x, center.y, acr);
        }

        public Ball(int x, int y, int acr) {
            this(x, y, acr, null);
        }

        public Ball(int x, int y, int acr, Color color) {
            this.color = color != null ? color : new Color(this.random.nextInt(255), this.random.nextInt(255), this.random.nextInt(255));
            this.resize(x, y, acr);
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
        }

        protected void destroy() {
        }

        @Override
        public void paint(Graphics g) {
            if (this.getParent().getComponentCount() == 0) {
                this.destroy();
            }
            super.paint(g);
            this.setOpaque(true);
            g.setColor(this.color);
            g.fillArc(1, 1, this.getWidth() - 2, this.getHeight() - 2, 0, 360);
            g.setColor(this.textColor);
            if (this.text != null) {
                int len = this.text.length();
                g.drawString(this.text, this.center.x - 5 * len, this.center.y - 3);
            }
        }

        public void resize(int x, int y, int acr) {
            this.center = new Point(x, y);
            this.acr = acr;
            this.setBounds(x - acr, y - acr, acr * 2, acr * 2);
        }

        public void resize(Point center, int acr) {
            this.center = center;
            this.acr = acr;
            this.setBounds(center.x - acr, center.y - acr, acr * 2, acr * 2);
        }

        public void setPos(int x, int y) {
            this.center = new Point(x, y);
            this.setBounds(x - this.acr, y - this.acr, this.acr * 2, this.acr * 2);
        }

        public void setPos(Point point) {
            this.center = point;
            this.setBounds(this.center.x - this.acr, this.center.y - this.acr, this.acr * 2, this.acr * 2);
        }

        public int getAcr() {
            return this.acr;
        }

        public void setAcr(int acr) {
            this.acr = acr;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Color getTextColor() {
            return this.textColor;
        }

        public void setTextColor(Color textColor) {
            this.textColor = textColor;
        }
    }

    public class RectArea
    implements IArea {
        public Point leftTop;
        public int width;
        public int height;

        public RectArea(Point leftTopPoint, int width, int height) {
            this.leftTop = leftTopPoint;
            this.width = width;
            this.height = height;
        }

        @Override
        public boolean pointInArea(Point point) {
            return point.x > this.leftTop.x && point.x <= this.leftTop.x + this.width && point.y > this.leftTop.y && point.y < this.leftTop.y + this.height;
        }

        @Override
        public boolean xInArea(int x) {
            return x > this.leftTop.x && x <= this.leftTop.x + this.width;
        }

        @Override
        public boolean yInArea(int y) {
            return y > this.leftTop.y && y < this.leftTop.y + this.height;
        }
    }

    public static interface IArea {
        public boolean pointInArea(Point var1);

        public boolean xInArea(int var1);

        public boolean yInArea(int var1);
    }
}

