/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ApplyTransDownCommonDataProvider
implements BOSQueryDelegate {
    private Set ids = null;
    private IMetaDataPK qpk = null;

    public ApplyTransDownCommonDataProvider(Set id, IMetaDataPK qpk) {
        this.ids = id;
        this.qpk = qpk;
    }

    public ApplyTransDownCommonDataProvider(List id, IMetaDataPK qpk) {
        this.ids = new HashSet(id);
        this.qpk = qpk;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.qpk);
            exec.option().isAutoTranslateEnum = true;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
            ev.setFilter(filter);
            R1PrintDataSortItem[] sortItems = ds.getSortFields();
            if (sortItems != null && sortItems.length > 0) {
                for (int i = 0; i < sortItems.length; ++i) {
                    String fieldName = sortItems[i].getSortField();
                    if (EmptyUtil.isEmpty((String)fieldName) || "id".equals(fieldName)) continue;
                    SorterItemInfo sort = new SorterItemInfo(fieldName);
                    if (0 == sortItems[i].getSortType()) {
                        sort.setSortType(SortType.ASCEND);
                    } else {
                        sort.setSortType(SortType.DESCEND);
                    }
                    ev.getSorter().add(sort);
                }
            }
            if (ev.getSorter() == null || ev.getSorter().size() == 0) {
                SorterItemInfo companySort = new SorterItemInfo("company.name");
                SorterItemInfo numberSort = new SorterItemInfo("number");
                SorterItemInfo approveSort = new SorterItemInfo("MultiApprove.createTime");
                companySort.setSortType(SortType.ASCEND);
                numberSort.setSortType(SortType.ASCEND);
                approveSort.setSortType(SortType.DESCEND);
                ev.getSorter().add(companySort);
                ev.getSorter().add(numberSort);
                ev.getSorter().add(approveSort);
            }
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e);
        }
        return iRowSet;
    }
}

