/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.FeeTypeF7ContextUtil;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fm.bond.BondUtil;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.ApplyTransDownFactory;
import com.kingdee.eas.fm.fs.ApplyTransDownInfo;
import com.kingdee.eas.fm.fs.ApplyTransDownStateEnum;
import com.kingdee.eas.fm.fs.client.AbstractApplyTransDownEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class ApplyTransDownEditUI
extends AbstractApplyTransDownEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ApplyTransDownEditUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.IN);
        FeeTypeF7ContextUtil.initFeeTypeTree((IUIObject)this, (KDBizPromptBox)this.prmtfeeType, (boolean)true);
    }

    @Override
    protected void initF7Control() throws Exception {
        super.initF7Control();
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
    }

    @Override
    protected void initUIFormat() {
        super.initUIFormat();
    }

    @Override
    public void loadFields() {
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        FMClientHelper.setSelectObject((KDComboBox)this.cbbCurrency, (Object)this.editData.getCurrency());
        try {
            FinUtils.initExchangeRate((BasicFormattedTextField)this.txtLocalCurExRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)((CurrencyInfo)this.cbbCurrency.getSelectedItem()), (CurrencyInfo)this.currentCurrency, (Date)((Date)this.pkBizDate.getValue()));
        }
        catch (Exception e) {
            this.cbbCurrency.setSelectedItem(null);
            this.handUIExceptionAndAbort(e);
        }
        super.loadFields();
        this.storeFields();
        this.initOldData(this.getDataObject());
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ApplyTransDownFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ApplyTransDownInfo info = new ApplyTransDownInfo();
        info.setBizDate(BondUtil.getNowDate());
        info.setCurrency(this.currentCurrency);
        info.setAmount(FMConstants.ZERO);
        info.setLocalCurExRate(FMConstants.ONE);
        info.setAmountLocalCur(FMConstants.ZERO);
        info.setPlanTransDate(BondUtil.getNowDate());
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCompany(this.currentCompany);
        info.setIsApprove(false);
        info.setState(ApplyTransDownStateEnum.SAVE);
        Map map = this.getUIContext();
        String action = (String)map.get("COPY");
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        if (action != null && id != null && action.equals("COPY")) {
            try {
                ApplyTransDownInfo oldInfo = (ApplyTransDownInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                info = oldInfo.copy(info);
                ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)info.getCurrency(), (CurrencyInfo)this.currentCurrency, (Date)info.getBizDate());
                BigDecimal convertRate = exchangeRateInfo == null ? FMConstants.ONE : exchangeRateInfo.getConvertRate();
                info.setLocalCurExRate(convertRate);
                FMClientHelper.initNumber((CoreBaseInfo)info, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
                map.remove("COPY");
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIExceptionAndAbort(e);
            }
        }
        return info;
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FmMbgHelper.checkBizUnitInfo(null, (IObjectValue)this.editData);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("feeType.*"));
        sic.add(new SelectorItemInfo("accountBank.*"));
        sic.add(new SelectorItemInfo("accountBank.subAccount.*"));
        sic.add(new SelectorItemInfo("accountBank.subAccount.accountBank.*"));
        sic.add(new SelectorItemInfo("subAccountBank.*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("transCompany.*"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("mbgNumber"));
        sic.add(new SelectorItemInfo("mbgName"));
        return sic;
    }

    @Override
    protected void initDataStatus() {
        super.initDataStatus();
    }

    @Override
    protected void initCommonOprtStatus() {
        super.initCommonOprtStatus();
    }

    @Override
    protected void initAddNewStatus() {
        if (this.getDataObject() != null && ApplyTransDownStateEnum.SUBMIT.equals((Object)((ApplyTransDownInfo)this.getDataObject()).getState())) {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(true);
        }
    }

    @Override
    protected void initEditStatus() {
        if (this.getDataObject() != null && ApplyTransDownStateEnum.SUBMIT.equals((Object)((ApplyTransDownInfo)this.getDataObject()).getState())) {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(true);
        }
    }

    @Override
    protected void initViewStatus() {
        super.initViewStatus();
    }

    @Override
    protected void initFindViewStatus() {
        super.initFindViewStatus();
    }

    @Override
    protected void initOtherOprtStatus() {
        super.initOtherOprtStatus();
    }

    @Override
    protected void initBillStatus() {
        super.initBillStatus();
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    protected void resetActionStatus() {
        super.resetActionStatus();
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.fs.app.ApplyTransDown", null, (IObjectValue)this.editData);
    }
}

