/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.AutoTransFactory;
import com.kingdee.eas.fm.fs.AutoTransInfo;
import com.kingdee.eas.fm.fs.IAutoTrans;
import com.kingdee.eas.fm.fs.TransBillException;
import com.kingdee.eas.fm.fs.client.AbstractAutoTransListUI;
import com.kingdee.eas.fm.fs.client.AutoTransEditUI;
import com.kingdee.eas.fm.fs.client.AutoTransFilterUI;
import com.kingdee.eas.fm.fs.client.AutoTransHistoryListUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoTransListUI
extends AbstractAutoTransListUI {
    private static final Logger logger = CoreUIObject.getLogger(AutoTransListUI.class);
    private boolean isAutoTransDown = true;
    private AutoTransFilterUI filterUI;
    String param = null;
    public static final String srcPath = "com.kingdee.eas.fm.fs.TransBillResource";

    public void onLoad() throws Exception {
        this.param = (String)this.getUIContext().get("UIClassParam");
        if (!FMHelper.isEmpty((String)this.param) && this.param.equalsIgnoreCase("autoTransUp")) {
            this.isAutoTransDown = false;
        }
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.onshows();
        String timeFormat = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("transTime").getStyleAttributes().setNumberFormat(FMHelper.getTimeFormatString());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentCompany)) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionCancel.setVisible(false);
            this.actionCancelCancel.setVisible(false);
            this.actionViewTransDetail.setVisible(false);
            this.actionViewTransDetail.setVisible(false);
        }
        this.actionViewTransDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_allgathersee"));
    }

    public void onshows() throws EASBizException, BOSException, Exception {
        if (!this.isAutoTransDown) {
            this.tblMain.getColumn("entrys_province.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("entrys.city.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("entrys.beBank.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("entrys.outBgItemName").getStyleAttributes().setHided(true);
        }
        String title = this.getUITitle();
        if (!FMHelper.isEmpty((String)this.param)) {
            title = EASResource.getString((String)srcPath, (String)this.param) + EASResource.getString((String)srcPath, (String)"titleSet");
        }
        this.setUITitle(title);
        this.changeButtonStatus();
    }

    protected void execQuery() {
        FilterInfo filter = new FilterInfo();
        if (this.isAutoTransDown) {
            filter.getFilterItems().add(new FilterItemInfo("isTransDown", (Object)new Integer(1)));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isTransDown", (Object)new Integer(0)));
        }
        try {
            this.mainQuery.getFilter().mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
        super.execQuery();
        if (!this.isAutoTransDown) {
            this.tblMain.getColumn("entrys_province.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("entrys.city.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("entrys.beBank.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("entrys.outBgItemName").getStyleAttributes().setHided(true);
        }
    }

    protected String getEditUIName() {
        return AutoTransEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AutoTransFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new AutoTransFilterUI(this.isAutoTransDown);
        }
        return this.filterUI;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"BizType", (Object)this.param);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.changeButtonStatus();
    }

    private void changeButtonStatus() throws EASBizException, BOSException, Exception {
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        if (rowNumber == -1) {
            return;
        }
        IRow row = this.tblMain.getRow(rowNumber);
        String id = row.getCell("id").getValue().toString();
        AutoTransInfo info = ((IAutoTrans)this.getBizInterface()).getAutoTransInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.isState()) {
            this.actionCancelCancel.setEnabled(false);
            this.actionCancel.setEnabled(true);
        } else {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(true);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = this.tblMain.getColumn("entrys.id").getColumnIndex();
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        boolean state;
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        if (i >= 0 && (state = Boolean.valueOf(this.tblMain.getRow(i).getCell("state").getValue().toString()).booleanValue())) {
            throw new TransBillException(TransBillException.STATECANNOTDELETE, new Object[]{EASResource.getString((String)srcPath, (String)this.param)});
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        boolean state;
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        if (i >= 0 && (state = Boolean.valueOf(this.tblMain.getRow(i).getCell("state").getValue().toString()).booleanValue())) {
            throw new TransBillException(TransBillException.STATECANNOTMIDIFY, new Object[]{EASResource.getString((String)srcPath, (String)this.param)});
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ((IAutoTrans)this.getBizInterface()).openOrClose(FMHelper.list2Set((List)idList), false);
        this.refresh(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ((IAutoTrans)this.getBizInterface()).openOrClose(FMHelper.list2Set((List)idList), true);
        this.refresh(e);
    }

    @Override
    public void actionViewTransDetail_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        IRow row;
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && (row = this.tblMain.getRow(rowIndex = selectBlock.getTop())) != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"id", row.getCell("id").getValue());
            uiContext.put((Object)"isAutoTransDown", (Object)this.isAutoTransDown);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(AutoTransHistoryListUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
    }
}

