/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.AccountBankPropertyEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPFormulaCollection;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fp.FPHelper;
import com.kingdee.eas.fm.fs.AvgTypeEnum;
import com.kingdee.eas.fm.fs.ISummaryLedger;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InacctTypeEnum;
import com.kingdee.eas.fm.fs.SummaryLedgerFactory;
import com.kingdee.eas.fm.fs.client.AbstractAvgAnalysisHandler;
import com.kingdee.eas.fm.fs.client.AvgAnalysisFilterParam;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Iterator;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class AvgAnalysisByTypeHandler
extends AbstractAvgAnalysisHandler {
    private String resourcePath = "com.kingdee.eas.fm.fs.client.AvgAnalysisResource";

    @Override
    public void fillData(AvgAnalysisFilterParam param, Object condition, KDTable tblMain, EntityViewInfo mainQuery) throws SQLException, EASBizException, BOSException {
        CycleTypeEnum cycleType;
        int beginYear = param.getBeginYear();
        int beginMonth = param.getBeginMonth() - 1;
        int endYear = param.getEndYear();
        int endMonth = param.getEndMonth() - 1;
        AvgTypeEnum avgTypeEnum = (AvgTypeEnum)((Object)condition);
        if (param.getAvgRptType() == 0) {
            cycleType = CycleTypeEnum.MONTH;
        } else if (param.getAvgRptType() == 1) {
            cycleType = CycleTypeEnum.QUARTER;
            beginMonth *= 3;
            endMonth *= 3;
        } else {
            cycleType = CycleTypeEnum.YEAR;
        }
        CycleRangeCollection coll = FPHelper.genCycleRanges((CycleTypeEnum)cycleType, (FPCycleIntervalEnum)FPCycleIntervalEnum.ONE, (int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
        CompanyOrgUnitCollection companyCol = null;
        String[] companyIds = param.getCompanyIds();
        companyCol = FMClientHelper.getCompanyOrgUnitCollection((String[])companyIds);
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyCollection currencyCollection = new CurrencyCollection();
        if (param.getCurrencyId() != null) {
            CurrencyInfo currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(param.getCurrencyId()));
            currencyCollection.add(currency);
        } else {
            currencyCollection = iCurrency.getCurrencyCollection(true);
        }
        FPFormulaCollection paramColl = new FPFormulaCollection();
        int colSize = this.setParam(paramColl, avgTypeEnum, coll, companyCol, currencyCollection);
        ISummaryLedger iSummaryLedger = SummaryLedgerFactory.getRemoteInstance();
        FPFormulaCollection resultcoll = null;
        resultcoll = avgTypeEnum.equals((Object)AvgTypeEnum.CURRENT_DEPOSIT) ? iSummaryLedger.exec(InacctTypeEnum.INACCT, paramColl) : iSummaryLedger.exec(InacctTypeEnum.CASH_INACCT, paramColl);
        int flag = 0;
        int rowCount = -1;
        Object[] params = null;
        String companyName = null;
        String currencyName = null;
        int cycleRangeColSize = coll.size();
        for (int i = 0; i < colSize; ++i) {
            params = resultcoll.get(i * cycleRangeColSize).getParams();
            if (avgTypeEnum.equals((Object)AvgTypeEnum.CURRENT_DEPOSIT)) {
                companyName = (String)params[9];
                currencyName = (String)params[10];
            } else {
                companyName = (String)params[10];
                currencyName = (String)params[11];
            }
            flag = 0;
            IRow row = tblMain.addRow();
            row.getCell("company").setValue((Object)companyName);
            row.getCell("currency").setValue((Object)currencyName);
            ++rowCount;
            for (int j = 0; j < cycleRangeColSize; ++j) {
                BigDecimal avg = resultcoll.get(i * cycleRangeColSize + j).getResult();
                row.getCell(j + 2).setValue((Object)avg);
                if (avg.compareTo(Constants.ZERO) == 0) continue;
                ++flag;
            }
            if (flag != 0) continue;
            tblMain.removeRow(rowCount);
            --rowCount;
        }
        this.setTotal(tblMain, param.getCurrencyId());
    }

    private int setParam(FPFormulaCollection paramColl, AvgTypeEnum avgTypeEnum, CycleRangeCollection coll, CompanyOrgUnitCollection companyCol, CurrencyCollection currencyCollection) throws SQLException, EASBizException, BOSException {
        FPFormulaInfo paramInfo = null;
        int currencyColSize = currencyCollection.size();
        int companyColSize = companyCol.size();
        int cycleRangeColSize = coll.size();
        int size = companyColSize;
        for (int i = 0; i < currencyColSize; ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            PeriodInfo periodInfo = null;
            for (int j = 0; j < companyColSize; ++j) {
                CompanyOrgUnitInfo company = companyCol.get(j);
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
                    --size;
                    continue;
                }
                periodInfo = SystemStatusCtrolFactory.getRemoteInstance().getStartPeriod(SystemEnum.CASHMANAGEMENT.getValue(), company.getId().toString());
                if (periodInfo == null) {
                    --size;
                    continue;
                }
                if (company.getAccountTable() == null) {
                    --size;
                    continue;
                }
                block6: for (int k = 0; k < cycleRangeColSize; ++k) {
                    CycleRangeInfo info = coll.get(k);
                    switch (avgTypeEnum.getValue()) {
                        case 3: {
                            paramInfo = new FPFormulaInfo();
                            paramInfo.setParams(new Object[]{company.getNumber(), null, AccountBankPropertyEnum.Current, null, currency.getNumber(), null, info.getBeginDate(), info.getEndDate(), InAcctDataTypeEnum.WAY, company.getName(), currency.getName()});
                            paramColl.add(paramInfo);
                            continue block6;
                        }
                        case 1: {
                            paramInfo = new FPFormulaInfo();
                            paramInfo.setParams(new Object[]{company.getNumber(), CashDataSourceEnum.C, company.getAccountTable().getNumber(), null, null, currency.getNumber(), info.getBeginDate(), info.getEndDate(), CashDataTypeEnum.AY, Boolean.FALSE, company.getName(), currency.getName()});
                            paramColl.add(paramInfo);
                            continue block6;
                        }
                        default: {
                            paramInfo = new FPFormulaInfo();
                            paramInfo.setParams(new Object[]{company.getNumber(), CashDataSourceEnum.B, company.getAccountTable().getNumber(), null, null, currency.getNumber(), info.getBeginDate(), info.getEndDate(), CashDataTypeEnum.AY, Boolean.FALSE, company.getName(), currency.getName()});
                            paramColl.add(paramInfo);
                        }
                    }
                }
            }
        }
        return size * currencyColSize;
    }

    @Override
    public void initTable(AvgAnalysisFilterParam param, KDTable tblMain) throws BOSException {
        CycleTypeEnum cycleType;
        tblMain.checkParsed();
        FMClientHelper.clearTable((KDTable)tblMain);
        IRow headRow = tblMain.addHeadRow();
        tblMain.addColumn().setKey("company");
        headRow.getCell("company").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Company"));
        tblMain.addColumn().setKey("currency");
        headRow.getCell("currency").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Currency"));
        int beginYear = param.getBeginYear();
        int beginMonth = param.getBeginMonth() - 1;
        int endYear = param.getEndYear();
        int endMonth = param.getEndMonth() - 1;
        if (param.getAvgRptType() == 0) {
            cycleType = CycleTypeEnum.MONTH;
        } else if (param.getAvgRptType() == 1) {
            cycleType = CycleTypeEnum.QUARTER;
            beginMonth *= 3;
            endMonth *= 3;
        } else {
            cycleType = CycleTypeEnum.YEAR;
        }
        CycleRangeCollection coll = FPHelper.genCycleRanges((CycleTypeEnum)cycleType, (FPCycleIntervalEnum)FPCycleIntervalEnum.ONE, (int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
        int CycleRangeColSize = coll.size();
        for (int i = 0; i < CycleRangeColSize; ++i) {
            CycleRangeInfo info = coll.get(i);
            tblMain.addColumn().setKey(info.genDateKey());
            headRow.getCell(info.genDateKey()).setValue((Object)info.toString());
        }
    }

    @Override
    public void initTree(AvgAnalysisFilterParam param, KDTree treeList) throws BOSException {
        Iterator avgTypeIterator = AvgTypeEnum.iterator();
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)this.resourcePath, (String)"AvgType"));
        DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
        child.setUserObject((Object)AvgTypeEnum.CASH);
        root.add((MutableTreeNode)child);
        child = new DefaultKingdeeTreeNode();
        child.setUserObject((Object)AvgTypeEnum.DEPOSIT);
        root.add((MutableTreeNode)child);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        treeList.setModel((TreeModel)model);
    }

    private void setTotal(KDTable tblMain, String currencyId) {
        for (int i = 0; i < tblMain.getColumnCount(); ++i) {
            tblMain.getColumn(i).setMergeable(false);
        }
        tblMain.getColumn("currency").setGroup(true);
        tblMain.getColumn("currency").setStat(true);
        tblMain.getGroupManager().setOrientation(1);
        IRow row0 = tblMain.getGroupManager().getStatRowTemplate(-1);
        row0.getStyleAttributes().setHided(true);
        IRow row1 = tblMain.getGroupManager().getStatRowTemplate(0);
        row1.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row1.getCell(0).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"MoneyTotal"));
        String numberFtm = currencyId == null ? "%r-[ ]{###,###,##0.00}0.2n" : FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
        for (int i = 2; i < tblMain.getColumnCount(); ++i) {
            row1.getCell(i).setExpressions("SUM");
            row1.getCell(i).getStyleAttributes().setNumberFormat(numberFtm);
            row1.getCell(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        tblMain.getGroupManager().group();
    }
}

