/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.CapitalSourceEnum;
import com.kingdee.eas.fm.fs.CapitalStockTypeEnum;
import com.kingdee.eas.fm.fs.client.AbstractCapitalStockFilterUI;
import com.kingdee.eas.fm.fs.client.CapitalStockFilterParam;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Date;
import java.util.Set;

public class CapitalStockFilterUI
extends AbstractCapitalStockFilterUI {
    private String resourcePath = "com.kingdee.eas.fm.fs.client.CapitalStockResource";
    private String resourcePath1 = "com.kingdee.eas.fm.fs.FSClientResource";

    protected void init() throws Exception {
        FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cboCapitalSource.addItem((Object)CapitalSourceEnum.OUTERCAPITAL);
        super.init();
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    @Override
    protected void cboType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.cboType.getSelectedItem().equals((Object)CapitalStockTypeEnum.FINALCAPITAL)) {
            this.dtpBeginDate.setEnabled(false);
        } else {
            this.dtpBeginDate.setEnabled(true);
        }
    }

    public Object getParam() {
        CapitalStockFilterParam para = new CapitalStockFilterParam();
        String[] companyIds = this.getCompanyIds();
        para.setCompanyIds(companyIds);
        if (this.cboCurrency.getSelectedItem() != null) {
            if (!(this.cboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
                para.setCurrencyId(((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString());
                para.setCurrencyName((String)AccessHelper.getCboAttribute((KDComboBox)this.cboCurrency, (String)"name"));
            } else {
                para.setCurrencyName(FMSysDefinedEnum.SELECT_ALL.getAlias());
            }
        }
        para.setCapitalSource(((IntEnum)this.cboCapitalSource.getSelectedItem()).getValue());
        para.setCapitalStockRptType(((IntEnum)this.cboType.getSelectedItem()).getValue());
        para.setBeginDate(this.dtpBeginDate.getSqlDate());
        para.setEndDate(this.dtpEndDate.getSqlDate());
        para.setIA(this.chkIA.isSelected());
        para.setDispCompanyTotal(this.chkDispCompanyTotal.isSelected());
        para.setDispTotal(this.chkDispTotal.isSelected());
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof CapitalStockFilterParam)) {
            return;
        }
        CapitalStockFilterParam filterParam = (CapitalStockFilterParam)param;
        String[] companyIds = filterParam.getCompanyIds();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort((Throwable)e);
        }
        String currencyId = filterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                this.cboCurrency.setSelectedItem((Object)currencyInfo);
            } else {
                this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.cboCapitalSource.setSelectedItem((Object)CapitalSourceEnum.getEnum(filterParam.getCapitalSource()));
        this.cboType.setSelectedItem((Object)CapitalStockTypeEnum.getEnum(filterParam.getCapitalStockRptType()));
        this.dtpBeginDate.setValue((Object)filterParam.getBeginDate());
        this.dtpEndDate.setValue((Object)filterParam.getEndDate());
        this.chkIA.setSelected(filterParam.isIA());
        this.chkDispCompanyTotal.setSelected(filterParam.isDispCompanyTotal());
        this.chkDispTotal.setSelected(filterParam.isDispTotal());
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)this.resourcePath1, (KDDatePicker)this.dtpEndDate, (String)"NoDate");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)this.resourcePath1, (KDDatePicker)this.dtpBeginDate, (String)"NoDate");
        if (((IntEnum)this.cboType.getSelectedItem()).getValue() == 2 && DateTimeUtils.truncateDate((Date)this.dtpEndDate.getSqlDate()).before(DateTimeUtils.truncateDate((Date)this.dtpBeginDate.getSqlDate()))) {
            this.dtpBeginDate.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath1, (String)"CheckDateFromTo"));
            SysUtil.abort();
        }
        return true;
    }

    protected void initCompanyState() {
        super.initCompanyState();
        if (FSClientHelper.isClearingHouseCompanyId("")) {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
            String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            Set idSet = FMClientHelper.getUserCompanyIds((String)currentUserId);
            this.setCompanyIdSet(idSet);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.cboType.setSelectedItem((Object)CapitalStockTypeEnum.FINALCAPITAL);
        this.dtpBeginDate.setEnabled(false);
        this.chkDispCompanyTotal.setSelected(true);
        this.chkDispTotal.setSelected(false);
        Date now = new Date();
        this.dtpBeginDate.setValue((Object)now);
        this.dtpEndDate.setValue((Object)now);
    }

    protected Class getParamClass() {
        return CapitalStockFilterParam.class;
    }
}

