/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.CollectionUtil;
import com.kingdee.eas.base.core.util.CurrencyUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountBankPropertyEnum;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IRptHandler;
import com.kingdee.eas.fm.fp.FPFormulaCollection;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fs.CapitalStockTypeEnum;
import com.kingdee.eas.fm.fs.ISummaryLedger;
import com.kingdee.eas.fm.fs.InacctTypeEnum;
import com.kingdee.eas.fm.fs.SummaryLedgerFactory;
import com.kingdee.eas.fm.fs.client.CapitalStockFilterParam;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CapitalStockHandler
implements IRptHandler {
    private String resourcePath = "com.kingdee.eas.fm.fs.client.CapitalStockResource";
    private boolean isCacheFilled = false;
    private static Logger logger = CoreUIObject.getLogger(CapitalStockHandler.class);
    private static Map company2BankAccts = new HashMap();
    private static Map company2ClearingHouse = new HashMap();
    private AccountBankCollection allBankAcct = null;
    private boolean isOld;

    public IRowSet getRowset(IMetaDataPK mainQueryPK, EntityViewInfo mainQuery, CapitalStockFilterParam p) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        EntityViewInfo ev = (EntityViewInfo)mainQuery.clone();
        exec.setObjectView(ev);
        String sql = exec.getSQL();
        StringBuffer sb = new StringBuffer(128);
        if (p.getCapitalStockRptType() == 1) {
            sb.append("SELECT ");
            sb.append(" COMPANYNAME,INNERACCOUNTNAME,CAPITALTYPE,INNERACCOUNTTYPE,");
            sb.append("CURRENCYNAME, SUM(BEGINBALANCE) AS BEGINBALANCE,");
            sb.append(" SUM(DEBITTOTAL) AS DEBITTOTAL, SUM(CREDITTOTAL) AS CREDITTOTAL, ");
            sb.append(" SUM(ENDBALANCE) AS ENDBALANCE");
            sb.append(" from (");
            sb.append(sql);
            sb.append(") a");
            if (p.isDispTotal() && !p.isDispCompanyTotal()) {
                sb.append("  GROUP BY CURRENCYNAME,COMPANYNAME,INNERACCOUNTNAME,CAPITALTYPE,INNERACCOUNTTYPE ");
            } else {
                sb.append("  GROUP BY COMPANYNAME,CURRENCYNAME,INNERACCOUNTNAME,CAPITALTYPE,INNERACCOUNTTYPE ");
            }
        } else {
            sb.append("SELECT ");
            sb.append("a.COMPANYNAME,a.INNERACCOUNTNAME,a.CAPITALTYPE,");
            sb.append("a.INNERACCOUNTTYPE,a.CURRENCYNAME,");
            sb.append("a.ENDBALANCE,");
            sb.append("b.DEBITTOTAL,");
            sb.append("b.CREDITTOTAL,");
            sb.append("(a.ENDBALANCE-b.DEBITTOTAL+b.CREDITTOTAL) BEGINBALANCE ");
            sb.append(" FROM ");
            sb.append("(SELECT ");
            sb.append(" COMPANYID,COMPANYNAME,INNERACCOUNTNAME,INNERACCOUNTID,");
            sb.append(" CAPITALTYPE,INNERACCOUNTTYPE,CURRENCYID,CURRENCYNAME,SUM(ENDBALANCE) AS ENDBALANCE");
            sb.append(" FROM (");
            sb.append(sql);
            sb.append(") a");
            sb.append(" WHERE BIZDATE={");
            sb.append(Constants.FORMAT_DAY.format(this.adjustEndDate(p.getEndDate())));
            sb.append("} ");
            if (p.isDispTotal() && !p.isDispCompanyTotal()) {
                sb.append(" GROUP BY CURRENCYID,CURRENCYNAME,COMPANYID,COMPANYNAME,INNERACCOUNTID,INNERACCOUNTNAME ,");
                sb.append(" CAPITALTYPE,INNERACCOUNTTYPE");
            } else {
                sb.append(" GROUP BY COMPANYID,COMPANYNAME,CURRENCYID,CURRENCYNAME,INNERACCOUNTID,INNERACCOUNTNAME ,");
                sb.append(" CAPITALTYPE,INNERACCOUNTTYPE");
            }
            sb.append(" )a");
            sb.append(" LEFT JOIN ");
            sb.append("(SELECT");
            sb.append(" COMPANYID,INNERACCOUNTID,CURRENCYID,CAPITALTYPE,");
            sb.append(" SUM(ISNULL(DEBITTOTAL,0)) AS DEBITTOTAL,SUM(ISNULL(CREDITTOTAL,0)) AS CREDITTOTAL");
            sb.append(" from (");
            sb.append(sql);
            sb.append(" ) b");
            if (p.isDispTotal() && !p.isDispCompanyTotal()) {
                sb.append(" GROUP BY CURRENCYID,COMPANYID,INNERACCOUNTID,CAPITALTYPE ");
            } else {
                sb.append(" GROUP BY COMPANYID,CURRENCYID,INNERACCOUNTID,CAPITALTYPE ");
            }
            sb.append(" ) b");
            sb.append("  ON A.COMPANYID=B.COMPANYID AND A.CURRENCYID=B.CURRENCYID");
            sb.append("  AND A.INNERACCOUNTID=B.INNERACCOUNTID AND A.CAPITALTYPE=B.CAPITALTYPE");
        }
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        return rs;
    }

    public void insertHeader(KDTable tblMain, int capitalSource) {
        this.insertOuterCapitalHeader(tblMain);
    }

    private void insertOuterCapitalHeader(KDTable tblMain) {
        tblMain.setRefresh(false);
        IRow headRow = tblMain.addHeadRow();
        tblMain.addColumn().setKey("company");
        tblMain.addColumn().setKey("currency");
        tblMain.addColumn().setKey("bank");
        tblMain.addColumn().setKey("account");
        tblMain.addColumn().setKey("type");
        tblMain.addColumn().setKey("beginBalance");
        tblMain.addColumn().setKey("increase");
        tblMain.addColumn().setKey("decrease");
        tblMain.addColumn().setKey("endBalance");
        headRow.getCell("company").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Company"));
        headRow.getCell("type").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Type"));
        headRow.getCell("account").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Account"));
        headRow.getCell("bank").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"bankName"));
        headRow.getCell("currency").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Currency"));
        headRow.getCell("beginBalance").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"BeginBalance"));
        headRow.getCell("increase").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Increase"));
        headRow.getCell("decrease").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Decrease"));
        headRow.getCell("endBalance").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"EndBalance"));
        tblMain.setRefresh(true);
        tblMain.repaint();
    }

    private void insertInnerCapitalHeader(KDTable tblMain) {
        tblMain.setRefresh(false);
        IRow headRow = tblMain.addHeadRow();
        tblMain.addColumn().setKey("currencyCopy");
        tblMain.getColumn("currencyCopy").getStyleAttributes().setHided(true);
        tblMain.addColumn().setKey("company");
        tblMain.addColumn().setKey("account");
        tblMain.addColumn().setKey("currency");
        tblMain.addColumn().setKey("accountType");
        tblMain.addColumn().setKey("capitalType");
        tblMain.addColumn().setKey("beginBalance");
        tblMain.addColumn().setKey("increase");
        tblMain.addColumn().setKey("decrease");
        tblMain.addColumn().setKey("endBalance");
        headRow.getCell("company").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Company"));
        headRow.getCell("account").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"InnerAccount"));
        headRow.getCell("capitalType").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"CapitalType"));
        headRow.getCell("accountType").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"AccountType"));
        headRow.getCell("currency").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Currency"));
        headRow.getCell("beginBalance").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"BeginBalance"));
        headRow.getCell("increase").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Increase"));
        headRow.getCell("decrease").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Decrease"));
        headRow.getCell("endBalance").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"EndBalance"));
        tblMain.setRefresh(true);
        tblMain.repaint();
    }

    public void fillData(KDTable tblMain, CapitalStockFilterParam param, IMetaDataPK mainQueryPK, EntityViewInfo mainQuery) throws SQLException, EASBizException, BOSException {
        tblMain.setRefresh(false);
        this.isOld = false;
        this.fillOuterData(tblMain, param);
        tblMain.setRefresh(true);
        tblMain.reLayoutAndPaint();
    }

    private void fillInnerData(KDTable tblMain, CapitalStockFilterParam param, IMetaDataPK mainQueryPK, EntityViewInfo mainQuery) throws SQLException, BOSException {
        IRowSet rs = this.getRowset(mainQueryPK, mainQuery, param);
        if (rs == null || rs.size() == 0) {
            return;
        }
        rs.beforeFirst();
        boolean isAfterSettDate = this.isAfterSettDate(param.getBeginDate());
        while (rs.next()) {
            IRow row = tblMain.addRow();
            row.getCell("company").setValue((Object)rs.getString("companyName"));
            row.getCell("account").setValue((Object)rs.getString("INNERACCOUNTNAME"));
            row.getCell("accountType").setValue((Object)AccountBankPropertyEnum.getEnum((int)rs.getInt("INNERACCOUNTTYPE")));
            row.getCell("currency").setValue((Object)rs.getString("CURRENCYNAME"));
            row.getCell("currencyCopy").setValue((Object)rs.getString("CURRENCYNAME"));
            row.getCell("beginBalance").setValue((Object)rs.getBigDecimal("BEGINBALANCE"));
            if (isAfterSettDate) {
                row.getCell("increase").setValue((Object)Constants.ZERO);
                row.getCell("decrease").setValue((Object)Constants.ZERO);
            } else {
                row.getCell("increase").setValue((Object)rs.getBigDecimal("DEBITTOTAL"));
                row.getCell("decrease").setValue((Object)rs.getBigDecimal("CREDITTOTAL"));
            }
            row.getCell("endBalance").setValue((Object)rs.getBigDecimal("ENDBALANCE"));
        }
    }

    private CurrencyCollection getRealCurCol() throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(128);
        sb.append("select distinct fcurrencyid from ( select fcurrencyid  from  t_fs_summaryledger union  select fcurrencyid from t_cas_journal) a");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        HashSet<String> list = new HashSet<String>();
        try {
            while (rs.next()) {
                list.add(rs.getString("fcurrencyid"));
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
            return CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", list, CompareType.INCLUDE));
        view.setFilter(fi);
        CurrencyCollection coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
        return coll;
    }

    public CompanyOrgUnitCollection getCompanyOrgUnitCollection(String[] companyIds) throws BOSException {
        if (EmptyUtil.isEmpty((Object[])companyIds)) {
            return new CompanyOrgUnitCollection();
        }
        Set set = CollectionUtil.asSet((String[])companyIds);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.getSelector().add("*");
        ev.getSelector().add("accountTable.id");
        ev.getSelector().add("accountTable.number");
        ev.getSorter().add(new SorterItemInfo("longnumber"));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        String sql = "select distinct FCompanyId from T_BD_SystemStatusCtrol where FSystemStatusID = 'e45c1988-00fd-1000-e000-33f9c0a8100d02A5514C' and FIsStart = 1";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        ev.setFilter(filter);
        CompanyOrgUnitCollection coll = null;
        ICompanyOrgUnit company = CompanyOrgUnitFactory.getRemoteInstance();
        coll = company.getCompanyOrgUnitCollection(ev);
        return coll;
    }

    private void fillOuterData(KDTable tblMain, CapitalStockFilterParam param) throws EASBizException, BOSException {
        if (this.isOld) {
            CurrencyInfo currency;
            String[] companyIds = param.getCompanyIds();
            CompanyOrgUnitCollection companyCol = null;
            companyCol = this.getCompanyOrgUnitCollection(companyIds);
            int companyColSize = companyCol.size();
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            CurrencyCollection currencyCollection = null;
            if (param.getCurrencyId() != null) {
                currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(param.getCurrencyId()));
                currencyCollection = new CurrencyCollection();
                currencyCollection.add(currency);
            } else {
                currencyCollection = this.getRealCurCol();
            }
            int currencyColSize = currencyCollection.size();
            FPFormulaCollection paramColl = new FPFormulaCollection();
            FPFormulaCollection transferParamColl = new FPFormulaCollection();
            if (param.isDispTotal() && !param.isDispCompanyTotal()) {
                for (int j = 0; j < currencyColSize; ++j) {
                    currency = currencyCollection.get(j);
                    for (int i = 0; i < companyColSize; ++i) {
                        CompanyOrgUnitInfo company = companyCol.get(i);
                        if (GLUtil.isCompanyUnion((CompanyOrgUnitInfo)company)) continue;
                        this.setCashDataParam(param.getCapitalStockRptType(), company.getNumber(), company.getAccountTable().getNumber(), company.getName(), currency.getNumber(), currency.getName(), param.getBeginDate(), param.getEndDate(), paramColl);
                        this.setBankDataParamSupportCache(param.getCapitalStockRptType(), company.getId().toString(), company.getNumber(), company.getAccountTable().getNumber(), company.getName(), currency.getNumber(), currency.getName(), param.getBeginDate(), param.getEndDate(), paramColl, transferParamColl, companyIds);
                    }
                }
            } else {
                for (int i = 0; i < companyColSize; ++i) {
                    CompanyOrgUnitInfo company = companyCol.get(i);
                    if (GLUtil.isCompanyUnion((CompanyOrgUnitInfo)company)) continue;
                    for (int j = 0; j < currencyColSize; ++j) {
                        currency = currencyCollection.get(j);
                        this.setCashDataParam(param.getCapitalStockRptType(), company.getNumber(), company.getAccountTable().getNumber(), company.getName(), currency.getNumber(), currency.getName(), param.getBeginDate(), param.getEndDate(), paramColl);
                        this.setBankDataParamSupportCache(param.getCapitalStockRptType(), company.getId().toString(), company.getNumber(), company.getAccountTable().getNumber(), company.getName(), currency.getNumber(), currency.getName(), param.getBeginDate(), param.getEndDate(), paramColl, transferParamColl, companyIds);
                    }
                }
            }
            if (param.getCapitalStockRptType() == 2) {
                this.fillCashAndBankData_Change(tblMain, paramColl, transferParamColl);
            } else {
                this.fillCashAndBankData_Final(tblMain, paramColl, transferParamColl);
            }
        } else {
            CurrencyInfo currency;
            String[] companyIds = param.getCompanyIds();
            CompanyOrgUnitCollection companyCol = null;
            companyCol = this.getCompanyOrgUnitCollection(companyIds);
            int companyColSize = companyCol.size();
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            CurrencyCollection currencyCollection = null;
            if (param.getCurrencyId() != null) {
                currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(param.getCurrencyId()));
                currencyCollection = new CurrencyCollection();
                currencyCollection.add(currency);
            } else {
                currencyCollection = this.getRealCurCol();
            }
            int currencyColSize = currencyCollection.size();
            FPFormulaCollection paramColl = new FPFormulaCollection();
            FPFormulaCollection transferParamColl = new FPFormulaCollection();
            if (param.isDispTotal() && !param.isDispCompanyTotal()) {
                for (int j = 0; j < currencyColSize; ++j) {
                    currency = currencyCollection.get(j);
                    for (int i = 0; i < companyColSize; ++i) {
                        CompanyOrgUnitInfo company = companyCol.get(i);
                        if (GLUtil.isCompanyUnion((CompanyOrgUnitInfo)company)) continue;
                        this.setCashDataParam(param.getCapitalStockRptType(), company.getNumber(), company.getAccountTable().getNumber(), company.getName(), currency.getNumber(), currency.getName(), param.getBeginDate(), param.getEndDate(), paramColl);
                        this.setBankDataParamSupportCache(param.getCapitalStockRptType(), company.getId().toString(), company.getNumber(), company.getAccountTable().getNumber(), company.getName(), currency.getNumber(), currency.getName(), param.getBeginDate(), param.getEndDate(), paramColl, transferParamColl, companyIds);
                    }
                }
            } else {
                for (int i = 0; i < companyColSize; ++i) {
                    CompanyOrgUnitInfo company = companyCol.get(i);
                    if (GLUtil.isCompanyUnion((CompanyOrgUnitInfo)company)) continue;
                    for (int j = 0; j < currencyColSize; ++j) {
                        currency = currencyCollection.get(j);
                        this.setCashDataParam(param.getCapitalStockRptType(), company.getId().toString(), company.getAccountTable().getNumber(), company.getName(), currency.getId().toString(), currency.getName(), param.getBeginDate(), param.getEndDate(), paramColl);
                        this.setBankDataParamSupportCache(param.getCapitalStockRptType(), company.getId().toString(), company.getId().toString(), company.getAccountTable().getNumber(), company.getName(), currency.getId().toString(), currency.getName(), param.getBeginDate(), param.getEndDate(), paramColl, transferParamColl, companyIds);
                    }
                }
            }
            if (FMHelper.isEmpty((AbstractObjectCollection)paramColl)) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resourcePath, (String)"IsNullParam"));
                SysUtil.abort();
            }
            if (param.getCapitalStockRptType() == 2) {
                this.fillCashAndBankData_Change(tblMain, paramColl, transferParamColl);
            } else {
                this.fillCashAndBankData_Final(tblMain, paramColl, transferParamColl);
            }
        }
    }

    private void setCashDataParam(int rptType, String companyNumber, String accountTableNumber, String companyName, String currencyNumber, String currencyName, Date beginDate, Date endDate, FPFormulaCollection paramColl) {
        FPFormulaInfo info = null;
        if (rptType == 2) {
            info = new FPFormulaInfo();
            info.setParams(new Object[]{companyNumber, CashDataSourceEnum.C, accountTableNumber, null, null, currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, Boolean.FALSE, companyName, currencyName, Boolean.FALSE, null, null});
            paramColl.add(info);
            info = new FPFormulaInfo();
            info.setParams(new Object[]{companyNumber, CashDataSourceEnum.C, accountTableNumber, null, null, currencyNumber, beginDate, endDate, CashDataTypeEnum.JF, Boolean.FALSE});
            paramColl.add(info);
            info = new FPFormulaInfo();
            info.setParams(new Object[]{companyNumber, CashDataSourceEnum.C, accountTableNumber, null, null, currencyNumber, beginDate, endDate, CashDataTypeEnum.DF, Boolean.FALSE});
            paramColl.add(info);
        }
        info = new FPFormulaInfo();
        info.setParams(new Object[]{companyNumber, CashDataSourceEnum.C, accountTableNumber, null, null, currencyNumber, endDate, endDate, CashDataTypeEnum.Y, Boolean.FALSE, companyName, currencyName, Boolean.FALSE, null, null});
        paramColl.add(info);
    }

    private void fillCashAndBankData_Change(KDTable tblMain, FPFormulaCollection paramColl, FPFormulaCollection transferParamColl) throws BOSException, EASBizException {
        ISummaryLedger iSummaryLedger = SummaryLedgerFactory.getRemoteInstance();
        DateFormat df = DateFormat.getDateTimeInstance();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        logger.info((Object)("fillCashAndBankData_Change step 1:" + df.format(ts)));
        FPFormulaCollection resultcoll = null;
        resultcoll = this.isOld ? iSummaryLedger.exec(InacctTypeEnum.CASH_INACCT, paramColl) : iSummaryLedger.execBatch(InacctTypeEnum.CASH_INACCT, paramColl, CapitalStockTypeEnum.CAPITALCHANGE);
        ts = new Timestamp(System.currentTimeMillis());
        logger.info((Object)("fillCashAndBankData_Change step 2:" + df.format(ts)));
        FPFormulaCollection transferResultcoll = iSummaryLedger.exec(InacctTypeEnum.OUTACCT, transferParamColl);
        ts = new Timestamp(System.currentTimeMillis());
        logger.info((Object)("fillCashAndBankData_Change step 3:" + df.format(ts)));
        BigDecimal beginBalance = null;
        BigDecimal debitAmount = null;
        BigDecimal creditAmount = null;
        BigDecimal endBalance = null;
        BigDecimal transferBeginBalance = null;
        BigDecimal transferDebitAmount = null;
        BigDecimal transferCreditAmount = null;
        BigDecimal transferEndBalance = null;
        BigDecimal selfBeginBalance = null;
        BigDecimal selfDebitAmount = null;
        BigDecimal selfCreditAmount = null;
        BigDecimal selfEndBalance = null;
        String bankAcctNum = null;
        String bankAcctName = null;
        String bank = null;
        String companyName = null;
        String currencyName = null;
        Object[] params = null;
        CashDataSourceEnum dataSource = null;
        Boolean isCHControl = Boolean.FALSE;
        int size = resultcoll.size() / 4;
        int j = 0;
        for (int i = 0; i < size; ++i) {
            params = resultcoll.get(i * 4).getParams();
            companyName = (String)params[10];
            bankAcctNum = (String)params[4];
            bankAcctName = (String)params[13];
            bank = (String)params[14];
            dataSource = (CashDataSourceEnum)params[1];
            currencyName = (String)params[11];
            isCHControl = (Boolean)params[12];
            beginBalance = resultcoll.get(i * 4).getResult();
            if (beginBalance == null) {
                beginBalance = Constants.ZERO;
            }
            if ((debitAmount = resultcoll.get(i * 4 + 1).getResult()) == null) {
                debitAmount = Constants.ZERO;
            }
            if ((creditAmount = resultcoll.get(i * 4 + 2).getResult()) == null) {
                creditAmount = Constants.ZERO;
            }
            if (beginBalance.compareTo(Constants.ZERO) != 0 || debitAmount.compareTo(Constants.ZERO) != 0 || creditAmount.compareTo(Constants.ZERO) != 0 || beginBalance.compareTo(Constants.ZERO) == 0 && debitAmount.compareTo(Constants.ZERO) == 0 && creditAmount.compareTo(Constants.ZERO) == 0 && isCHControl.booleanValue() && (transferResultcoll.get(j * 3).getResult().compareTo(Constants.ZERO) != 0 || transferResultcoll.get(j * 3 + 1).getResult().compareTo(Constants.ZERO) != 0 || transferResultcoll.get(j * 3 + 2).getResult().compareTo(Constants.ZERO) != 0)) {
                IRow row = tblMain.addRow();
                row.setStat(true);
                row.getCell("company").setValue((Object)companyName);
                if (bankAcctName != null) {
                    row.getCell("account").setValue((Object)bankAcctName);
                }
                if (bank != null) {
                    row.getCell("bank").setValue((Object)bank);
                }
                if (dataSource.getValue() == 0) {
                    row.getCell("type").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Cash"));
                } else {
                    row.getCell("type").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Bank"));
                }
                row.getCell("currency").setValue((Object)currencyName);
                row.getCell("beginBalance").setValue((Object)beginBalance);
                row.getCell("increase").setValue((Object)debitAmount);
                row.getCell("decrease").setValue((Object)creditAmount);
                endBalance = resultcoll.get(i * 4 + 3).getResult();
                row.getCell("endBalance").setValue((Object)endBalance);
                if (isCHControl.booleanValue()) {
                    transferBeginBalance = transferResultcoll.get(j * 4).getResult();
                    if (transferBeginBalance == null) {
                        transferBeginBalance = Constants.ZERO;
                    }
                    if ((transferDebitAmount = transferResultcoll.get(j * 4 + 1).getResult()) == null) {
                        transferDebitAmount = Constants.ZERO;
                    }
                    if ((transferCreditAmount = transferResultcoll.get(j * 4 + 2).getResult()) == null) {
                        transferCreditAmount = Constants.ZERO;
                    }
                    transferEndBalance = transferResultcoll.get(j * 4 + 3).getResult();
                    row = tblMain.addRow();
                    row.setStat(false);
                    row.getCell("beginBalance").setValue((Object)transferBeginBalance);
                    row.getCell("increase").setValue((Object)transferDebitAmount);
                    row.getCell("decrease").setValue((Object)transferCreditAmount);
                    row.getCell("endBalance").setValue((Object)transferEndBalance);
                    row.getCell("type").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    selfBeginBalance = beginBalance.subtract(transferBeginBalance);
                    selfDebitAmount = debitAmount.subtract(transferDebitAmount);
                    selfCreditAmount = creditAmount.subtract(transferCreditAmount);
                    selfEndBalance = endBalance.subtract(transferEndBalance);
                    row = tblMain.addRow();
                    row.setStat(false);
                    row.getCell("beginBalance").setValue((Object)selfBeginBalance);
                    row.getCell("increase").setValue((Object)selfDebitAmount);
                    row.getCell("decrease").setValue((Object)selfCreditAmount);
                    row.getCell("endBalance").setValue((Object)selfEndBalance);
                    row.getCell("type").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                }
            }
            if (!isCHControl.booleanValue()) continue;
            ++j;
        }
        ts = new Timestamp(System.currentTimeMillis());
        logger.info((Object)("fillCashAndBankData_Change step 4:" + df.format(ts)));
    }

    private void fillCashAndBankData_Final(KDTable tblMain, FPFormulaCollection paramColl, FPFormulaCollection transferParamColl) throws BOSException, EASBizException {
        ISummaryLedger iSummaryLedger = SummaryLedgerFactory.getRemoteInstance();
        DateFormat df = CtrlFormatUtilities.getDateTimeFormat();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        logger.info((Object)("fillCashAndBankData_Final step 1:" + df.format(ts)));
        FPFormulaCollection resultcoll = null;
        resultcoll = this.isOld ? iSummaryLedger.exec(InacctTypeEnum.CASH_INACCT, paramColl) : iSummaryLedger.execBatch(InacctTypeEnum.CASH_INACCT, paramColl, CapitalStockTypeEnum.FINALCAPITAL);
        ts = new Timestamp(System.currentTimeMillis());
        logger.info((Object)("fillCashAndBankData_Final step 2:" + df.format(ts)));
        FPFormulaCollection transferResultcoll = iSummaryLedger.exec(InacctTypeEnum.OUTACCT, transferParamColl);
        ts = new Timestamp(System.currentTimeMillis());
        logger.info((Object)("fillCashAndBankData_Final step 3:" + df.format(ts)));
        BigDecimal endBalance = null;
        BigDecimal transferEndBalance = null;
        BigDecimal selfEndBalance = null;
        String bankAcctNum = null;
        String bankAcctName = null;
        String bank = null;
        String companyName = null;
        String currencyName = null;
        Object[] params = null;
        CashDataSourceEnum dataSource = null;
        Boolean isCHControl = Boolean.FALSE;
        int size = resultcoll.size();
        int j = 0;
        for (int i = 0; i < size; ++i) {
            params = resultcoll.get(i).getParams();
            companyName = (String)params[10];
            bankAcctNum = (String)params[4];
            bankAcctName = (String)params[13];
            bank = (String)params[14];
            dataSource = (CashDataSourceEnum)params[1];
            currencyName = (String)params[11];
            isCHControl = (Boolean)params[12];
            endBalance = resultcoll.get(i).getResult();
            if (endBalance == null) {
                endBalance = Constants.ZERO;
            }
            if (endBalance.compareTo(Constants.ZERO) != 0 || isCHControl.booleanValue() && transferResultcoll.get(j).getResult().compareTo(Constants.ZERO) != 0) {
                IRow row = tblMain.addRow();
                row.setStat(true);
                row.getCell("company").setValue((Object)companyName);
                if (bankAcctName != null) {
                    row.getCell("account").setValue((Object)bankAcctName);
                }
                if (bank != null) {
                    row.getCell("bank").setValue((Object)bank);
                }
                if (dataSource.getValue() == 0) {
                    row.getCell("type").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Cash"));
                } else {
                    row.getCell("type").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Bank"));
                }
                row.getCell("currency").setValue((Object)currencyName);
                row.getCell("beginBalance").setValue((Object)Constants.ZERO);
                row.getCell("increase").setValue((Object)Constants.ZERO);
                row.getCell("decrease").setValue((Object)Constants.ZERO);
                row.getCell("endBalance").setValue((Object)endBalance);
                if (isCHControl.booleanValue()) {
                    transferEndBalance = transferResultcoll.get(j).getResult();
                    row = tblMain.addRow();
                    row.setStat(false);
                    row.getCell("beginBalance").setValue((Object)Constants.ZERO);
                    row.getCell("increase").setValue((Object)Constants.ZERO);
                    row.getCell("decrease").setValue((Object)Constants.ZERO);
                    row.getCell("endBalance").setValue((Object)transferEndBalance);
                    row.getCell("type").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    selfEndBalance = endBalance.subtract(transferEndBalance);
                    row = tblMain.addRow();
                    row.setStat(false);
                    row.getCell("beginBalance").setValue((Object)Constants.ZERO);
                    row.getCell("increase").setValue((Object)Constants.ZERO);
                    row.getCell("decrease").setValue((Object)Constants.ZERO);
                    row.getCell("endBalance").setValue((Object)selfEndBalance);
                    row.getCell("type").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                }
            }
            if (!isCHControl.booleanValue()) continue;
            ++j;
        }
        ts = new Timestamp(System.currentTimeMillis());
        logger.info((Object)("fillCashAndBankData_Final step 4:" + df.format(ts)));
    }

    private void setBankDataParam(int rptType, String companyId, String companyNumber, String accountTableNumber, String companyName, String currencyNumber, String currencyName, Date beginDate, Date endDate, FPFormulaCollection paramColl, FPFormulaCollection transferParamColl) throws BOSException {
        FPFormulaInfo info = null;
        AccountBankCollection acctBankCol = this.getAccountBankCollection(companyId);
        AccountBankInfo acctBank = null;
        int acctBankColSize = acctBankCol.size();
        String acctNumber = null;
        String bankAcctNum = null;
        String bankAcctName = null;
        String bankName = null;
        Boolean isCHControl = Boolean.FALSE;
        for (int i = 0; i < acctBankColSize; ++i) {
            acctBank = acctBankCol.get(i);
            if (acctBank != null && acctBank.getAccount() != null) {
                acctNumber = acctBank.getAccount().getNumber();
                bankAcctNum = acctBank.getNumber();
                bankAcctName = acctBank.getName();
                bankName = acctBank.getBank().getName();
            }
            if (rptType == 2) {
                info = new FPFormulaInfo();
                info.setParams(new Object[]{companyNumber, CashDataSourceEnum.B, accountTableNumber, null, bankAcctNum, currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, Boolean.FALSE, companyName, currencyName, isCHControl, bankAcctName, bankName});
                paramColl.add(info);
                info = new FPFormulaInfo();
                info.setParams(new Object[]{companyNumber, CashDataSourceEnum.B, accountTableNumber, null, bankAcctNum, currencyNumber, beginDate, endDate, CashDataTypeEnum.JF, Boolean.FALSE});
                paramColl.add(info);
                info = new FPFormulaInfo();
                info.setParams(new Object[]{companyNumber, CashDataSourceEnum.B, accountTableNumber, null, bankAcctNum, currencyNumber, beginDate, endDate, CashDataTypeEnum.DF, Boolean.FALSE});
                paramColl.add(info);
            }
            info = new FPFormulaInfo();
            info.setParams(new Object[]{companyNumber, CashDataSourceEnum.B, accountTableNumber, null, bankAcctNum, currencyNumber, endDate, endDate, CashDataTypeEnum.Y, Boolean.FALSE, companyName, currencyName, isCHControl, bankAcctName, bankName});
            paramColl.add(info);
        }
    }

    private void setBankDataParamSupportCache(int rptType, String companyId, String companyNumber, String accountTableNumber, String companyName, String currencyNumber, String currencyName, Date beginDate, Date endDate, FPFormulaCollection paramColl, FPFormulaCollection transferParamColl, String[] companyIDSet) throws BOSException {
        if (this.isOld) {
            FPFormulaInfo info = null;
            AccountBankCollection acctBankCol = this.getAccountBankCollectionFromCache(companyId, companyIDSet);
            AccountBankInfo acctBank = null;
            int acctBankColSize = acctBankCol.size();
            String acctNumber = null;
            String bankAcctNum = null;
            String bankAcctName = null;
            String bankName = null;
            Boolean isCHControl = Boolean.FALSE;
            for (int i = 0; i < acctBankColSize; ++i) {
                acctBank = acctBankCol.get(i);
                if (acctBank != null && acctBank.getAccount() != null) {
                    acctNumber = acctBank.getAccount().getNumber();
                    bankAcctNum = acctBank.getNumber();
                    bankAcctName = acctBank.getName();
                    bankName = acctBank.getBank().getName();
                }
                if (rptType == 2) {
                    info = new FPFormulaInfo();
                    info.setParams(new Object[]{companyNumber, CashDataSourceEnum.B, accountTableNumber, null, bankAcctNum, currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, Boolean.FALSE, companyName, currencyName, isCHControl, bankAcctName, bankName});
                    paramColl.add(info);
                    info = new FPFormulaInfo();
                    info.setParams(new Object[]{companyNumber, CashDataSourceEnum.B, accountTableNumber, null, bankAcctNum, currencyNumber, beginDate, endDate, CashDataTypeEnum.JF, Boolean.FALSE});
                    paramColl.add(info);
                    info = new FPFormulaInfo();
                    info.setParams(new Object[]{companyNumber, CashDataSourceEnum.B, accountTableNumber, null, bankAcctNum, currencyNumber, beginDate, endDate, CashDataTypeEnum.DF, Boolean.FALSE});
                    paramColl.add(info);
                }
                info = new FPFormulaInfo();
                info.setParams(new Object[]{companyNumber, CashDataSourceEnum.B, accountTableNumber, null, bankAcctNum, currencyNumber, endDate, endDate, CashDataTypeEnum.Y, Boolean.FALSE, companyName, currencyName, isCHControl, bankAcctName, bankName});
                paramColl.add(info);
            }
        } else {
            FPFormulaInfo info = null;
            AccountBankCollection acctBankCol = this.getAccountBankCollectionFromCache(companyId, companyIDSet);
            AccountBankInfo acctBank = null;
            int acctBankColSize = acctBankCol.size();
            String acctNumber = null;
            String bankAcctNum = null;
            String bankAcctName = null;
            String bankAcctId = "";
            String bankName = null;
            Boolean isCHControl = Boolean.FALSE;
            for (int i = 0; i < acctBankColSize; ++i) {
                acctBank = acctBankCol.get(i);
                if (acctBank != null && acctBank.getAccount() != null) {
                    acctNumber = acctBank.getAccount().getNumber();
                    bankAcctNum = acctBank.getNumber();
                    bankAcctId = acctBank.getId().toString();
                    bankAcctName = acctBank.getName();
                    bankName = acctBank.getBank().getName();
                }
                if (rptType == 2) {
                    info = new FPFormulaInfo();
                    info.setParams(new Object[]{companyNumber, CashDataSourceEnum.B, accountTableNumber, null, bankAcctId.toString(), currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, Boolean.FALSE, companyName, currencyName, isCHControl, bankAcctName, bankName});
                    paramColl.add(info);
                    info = new FPFormulaInfo();
                    info.setParams(new Object[]{companyNumber, CashDataSourceEnum.B, accountTableNumber, null, bankAcctId.toString(), currencyNumber, beginDate, endDate, CashDataTypeEnum.JF, Boolean.FALSE});
                    paramColl.add(info);
                    info = new FPFormulaInfo();
                    info.setParams(new Object[]{companyNumber, CashDataSourceEnum.B, accountTableNumber, null, bankAcctId.toString(), currencyNumber, beginDate, endDate, CashDataTypeEnum.DF, Boolean.FALSE});
                    paramColl.add(info);
                }
                info = new FPFormulaInfo();
                info.setParams(new Object[]{companyNumber, CashDataSourceEnum.B, accountTableNumber, null, bankAcctId, currencyNumber, endDate, endDate, CashDataTypeEnum.Y, Boolean.FALSE, companyName, currencyName, isCHControl, bankAcctName, bankName});
                paramColl.add(info);
            }
        }
    }

    public void setCurrencyFormat(KDTable tblMain, CapitalStockFilterParam param) {
        String numberFtm = param.getCurrencyId() == null ? CurrencyUtil.getNumberFtm((int)2) : FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)param.getCurrencyId()));
        tblMain.getColumn("beginBalance").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("increase").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("decrease").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("endBalance").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("beginBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("increase").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("decrease").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("endBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void initColumnStatus(KDTable tblMain, int rptType) {
        if (rptType == 1) {
            tblMain.getColumn("beginBalance").getStyleAttributes().setHided(true);
            tblMain.getColumn("increase").getStyleAttributes().setHided(true);
            tblMain.getColumn("decrease").getStyleAttributes().setHided(true);
            for (int i = 0; i < tblMain.getColumnCount(); ++i) {
                tblMain.getColumn(i).setWidth(160);
            }
        } else {
            tblMain.getColumn("beginBalance").getStyleAttributes().setHided(false);
            tblMain.getColumn("increase").getStyleAttributes().setHided(false);
            tblMain.getColumn("decrease").getStyleAttributes().setHided(false);
        }
    }

    private AccountBankCollection getAccountBankCollection(String companyID) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("bank.name");
        selector.add("bank.number");
        selector.add("bank.id");
        selector.add("isCHControl");
        FilterInfo fi = new FilterInfo();
        if (companyID != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        }
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        AccountBankCollection acctBankCol = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        return acctBankCol;
    }

    private AccountBankCollection getAccountBankCollectionFromCache(String companyId, String[] companyIDSet) throws BOSException {
        this.putAllAccountBanksToCache(companyIDSet);
        return this.getAccountBankFromCache(companyId);
    }

    private AccountBankCollection getAccountBankFromCache(String companyId) throws BOSException {
        String key = this.genKey(companyId);
        AccountBankCollection returnCol = new AccountBankCollection();
        if (company2BankAccts.get(key) != null) {
            returnCol = (AccountBankCollection)company2BankAccts.get(key);
        } else {
            returnCol = this.getAccountBankCollection(companyId);
            company2BankAccts.put(this.genKey(companyId), returnCol);
        }
        return returnCol;
    }

    private void putAllAccountBanksToCache(String[] companyIDSet) throws BOSException {
        if (!this.isCacheFilled) {
            company2BankAccts.clear();
            this.allBankAcct = this.getAllBankAccount(companyIDSet);
            for (int i = 0; i < companyIDSet.length; ++i) {
                String companyID = companyIDSet[i];
                this.populateMap(companyID);
            }
            this.isCacheFilled = true;
        }
    }

    private void populateMap(String companyID) {
        AccountBankInfo accountBankTmp = null;
        String key = "";
        for (int i = 0; i < this.allBankAcct.size(); ++i) {
            accountBankTmp = this.allBankAcct.get(i);
            key = this.genKey(companyID);
            if (company2BankAccts.get(key) == null) {
                company2BankAccts.put(key, new AccountBankCollection());
            }
            if (!accountBankTmp.getCompany().getId().toString().equals(companyID)) continue;
            ((AccountBankCollection)company2BankAccts.get(key)).add(accountBankTmp);
        }
    }

    private String genKey(String companyID) {
        return companyID;
    }

    private AccountBankCollection getAllBankAccount(String[] companyIDSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("bank.name");
        selector.add("bank.number");
        selector.add("bank.id");
        selector.add("currency.id");
        selector.add("currency.number");
        selector.add("currency.name");
        selector.add("isCHControl");
        FilterInfo fi = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>(Arrays.asList(companyIDSet));
        fi.getFilterItems().add(new FilterItemInfo("company.id", idSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        AccountBankCollection acctBankCol = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        return acctBankCol;
    }

    protected Date adjustDateFromCache(Date date) {
        try {
            BankInfo clearingHouse = this.getClearHouseFromCache();
            if (null == clearingHouse) {
                return date;
            }
            Date openDate = clearingHouse.getOpenDate();
            Date settDate = clearingHouse.getSettleDate();
            if (date.before(openDate)) {
                return openDate;
            }
            if (date.after(settDate)) {
                return settDate;
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return date;
    }

    private BankInfo getClearHouseFromCache() throws BOSException, EASBizException {
        String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        if (company2ClearingHouse.get(curr) == null) {
            BankInfo clearingHouse = BankFactory.getRemoteInstance().getClearingHouse(curr);
            company2ClearingHouse.put(curr, clearingHouse);
        }
        return (BankInfo)company2ClearingHouse.get(curr);
    }

    private Date adjustEndDate(Date date) {
        BankInfo clearingHouse = null;
        try {
            clearingHouse = FSClientHelper.getClearingHouse();
            Date settDate = clearingHouse.getSettleDate();
            if (date.after(settDate)) {
                return DateUtil.getBeforeDay((Date)settDate);
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return DateTimeUtils.truncateDate((Date)date);
    }

    public void setMergeable(KDTable tblMain, CapitalStockFilterParam param) {
        tblMain.getMergeManager().setMergeMode(5);
    }

    protected Date adjustDate(Date date) {
        BankInfo clearingHouse = null;
        try {
            String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            clearingHouse = BankFactory.getRemoteInstance().getClearingHouse(curr);
            if (null == clearingHouse) {
                return date;
            }
            Date openDate = clearingHouse.getOpenDate();
            Date settDate = clearingHouse.getSettleDate();
            if (date.before(openDate)) {
                return openDate;
            }
            if (date.after(settDate)) {
                return settDate;
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return date;
    }

    protected boolean isAfterSettDate(Date date) {
        BankInfo clearingHouse = null;
        try {
            clearingHouse = FSClientHelper.getClearingHouse();
            Date settDate = clearingHouse.getSettleDate();
            if (date.after(settDate)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

