/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.client.AbstractCapitalStockUI;
import com.kingdee.eas.fm.fs.client.CapitalStockFilterParam;
import com.kingdee.eas.fm.fs.client.CapitalStockFilterUI;
import com.kingdee.eas.fm.fs.client.CapitalStockHandler;
import com.kingdee.eas.fm.fs.client.FSAnalysisHandlerFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CapitalStockUI
extends AbstractCapitalStockUI {
    private String resourcePath = "com.kingdee.eas.fm.fs.client.CapitalStockResource";
    private static final Logger logger = CoreUIObject.getLogger(CapitalStockUI.class);
    private CapitalStockFilterUI filterUI;

    public void onLoad() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
        super.onLoad();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.resetColumn();
    }

    protected void execQuery() throws BOSException {
        CapitalStockFilterParam p = (CapitalStockFilterParam)this.getFilterParam();
        CapitalStockHandler handler = FSAnalysisHandlerFactory.getHandler(p);
        this.txtCurrency.setText(p.getCurrencyName());
        this.txtCurrency.setEditable(false);
        String datePeriod = "";
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        if (p.getCapitalStockRptType() == 2) {
            datePeriod = dtformat.format(p.getBeginDate()) + "-" + dtformat.format(p.getEndDate());
        } else {
            datePeriod = dtformat.format(p.getEndDate()).toString();
            if (p.getCapitalSource() == 2) {
                BankInfo clearingHouse = null;
                try {
                    clearingHouse = FSClientHelper.getClearingHouse();
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                Date openDate = clearingHouse.getOpenDate();
                Calendar calOpenDate = Calendar.getInstance();
                calOpenDate.setTime(openDate);
                calOpenDate.set(2, 0);
                calOpenDate.set(5, 1);
                p.setBeginDate(calOpenDate.getTime());
            }
        }
        this.txtPeriod.setText(datePeriod);
        this.txtPeriod.setEditable(false);
        this.tblMain.checkParsed();
        FMClientHelper.clearTable((KDTable)this.tblMain);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        handler.insertHeader(this.tblMain, p.getCapitalSource());
        try {
            handler.fillData(this.tblMain, p, this.mainQueryPK, this.mainQuery);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
        if (p.isDispCompanyTotal() || p.isDispTotal()) {
            this.sort(p.isDispTotal(), p.isDispCompanyTotal());
        }
        handler.setCurrencyFormat(this.tblMain, p);
        handler.initColumnStatus(this.tblMain, p.getCapitalStockRptType());
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CapitalStockFilterUI();
        }
        return this.filterUI;
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    private void sort(boolean isDispTotal, boolean isDispCompanyTotal) {
        KDTable table = this.getMainTable();
        this.tblMain.setRefresh(false);
        int rowCount = table.getRowCount();
        IRow row = null;
        String oldComCur = null;
        String comCur = null;
        IRow totalRow = null;
        BigDecimal beginBalanceTotal = Constants.ZERO;
        BigDecimal increaseTotal = Constants.ZERO;
        BigDecimal decreaseTotal = Constants.ZERO;
        BigDecimal endBalanceTotal = Constants.ZERO;
        BigDecimal beginBalance = Constants.ZERO;
        BigDecimal increase = Constants.ZERO;
        BigDecimal decrease = Constants.ZERO;
        BigDecimal endBalance = Constants.ZERO;
        for (int i = 0; i < rowCount; ++i) {
            row = table.getRow(i);
            if (!row.isStat()) continue;
            if (isDispCompanyTotal) {
                comCur = row.getCell("company").getValue() + ":" + row.getCell("currency").getValue();
            }
            if (isDispTotal && !isDispCompanyTotal) {
                comCur = (String)row.getCell("currency").getValue();
            }
            if (comCur != null && oldComCur != null && !comCur.equals(oldComCur)) {
                totalRow = table.addRow(i);
                totalRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
                totalRow.getCell("company").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"MoneyTotal"));
                totalRow.getCell("beginBalance").setValue((Object)beginBalanceTotal);
                totalRow.getCell("increase").setValue((Object)increaseTotal);
                totalRow.getCell("decrease").setValue((Object)decreaseTotal);
                totalRow.getCell("endBalance").setValue((Object)endBalanceTotal);
                beginBalanceTotal = Constants.ZERO;
                increaseTotal = Constants.ZERO;
                decreaseTotal = Constants.ZERO;
                endBalanceTotal = Constants.ZERO;
                ++i;
                ++rowCount;
            }
            beginBalance = (BigDecimal)row.getCell("beginBalance").getValue();
            increase = (BigDecimal)row.getCell("increase").getValue();
            decrease = (BigDecimal)row.getCell("decrease").getValue();
            endBalance = (BigDecimal)row.getCell("endBalance").getValue();
            beginBalanceTotal = beginBalanceTotal.add(beginBalance);
            increaseTotal = increaseTotal.add(increase);
            decreaseTotal = decreaseTotal.add(decrease);
            endBalanceTotal = endBalanceTotal.add(endBalance);
            oldComCur = comCur;
        }
        if (rowCount > 0) {
            totalRow = table.addRow();
            totalRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
            totalRow.getCell("company").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"MoneyTotal"));
            totalRow.getCell("beginBalance").setValue((Object)beginBalanceTotal);
            totalRow.getCell("increase").setValue((Object)increaseTotal);
            totalRow.getCell("decrease").setValue((Object)decreaseTotal);
            totalRow.getCell("endBalance").setValue((Object)endBalanceTotal);
        }
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        super.preparePrintPageHeader(headerModel);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("currency", this.txtCurrency.getText());
        map.put("periodString", this.txtPeriod.getText());
        return map;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.resetColumn();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.resetColumn();
    }

    private void resetColumn() {
        CapitalStockFilterParam p = (CapitalStockFilterParam)this.getFilterParam();
        CapitalStockHandler handler = FSAnalysisHandlerFactory.getHandler(p);
        handler.initColumnStatus(this.tblMain, p.getCapitalStockRptType());
    }
}

