/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.uiframe.client.LicenseHelper;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.DailySettleFacadeFactory;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.IDailySettleFacade;
import com.kingdee.eas.fm.fs.client.AbstractDailySettleUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class DailySettleUI
extends AbstractDailySettleUI {
    private String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";
    private static final Logger logger = CoreUIObject.getLogger(DailySettleUI.class);
    private static final String resPath = "com.kingdee.eas.fm.fs.client.FSDailySettleResource";
    private CompanyOrgUnitInfo chCompany = null;
    private Date settleDate = null;
    private Date openDate = null;
    private Date preSettleDate = null;
    private Date nextSettleDate = null;
    private int settleCtrlType = 0;

    @Override
    protected void settleDayNum_stateChanged(ChangeEvent e) throws Exception {
        super.settleDayNum_stateChanged(e);
        this.setNextSettleDate();
    }

    @Override
    protected void endSettleDate_dataChanged(DataChangeEvent e) throws Exception {
        super.endSettleDate_dataChanged(e);
        this.setSettleNum();
    }

    private void setNextSettleDate() {
        Date startDate = (Date)this.startSettleDate.getValue();
        int settleNum = this.settleDayNum.getIntegerVlaue();
        if (this.radioAntiDailySettle.isSelected()) {
            settleNum *= -1;
        }
        Date nextSettleDate = DateUtil.getNextDay((Date)startDate, (int)settleNum);
        EventListener[] listeners = this.endSettleDate.getEditor().getListeners(DataChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            DataChangeListener dcl = (DataChangeListener)listeners[0];
            this.endSettleDate.removeDataChangeListener(dcl);
            this.endSettleDate.setValue((Object)nextSettleDate);
            this.endSettleDate.addDataChangeListener(dcl);
        } else {
            this.endSettleDate.setValue((Object)nextSettleDate);
        }
    }

    private void setSettleNum() {
        Date startDate = (Date)this.startSettleDate.getValue();
        Date endDate = (Date)this.endSettleDate.getValue();
        if (this.radioDailySettle.isSelected()) {
            if (this.endSettleDate.getSqlDate() != null && !this.endSettleDate.getSqlDate().after(this.startSettleDate.getSqlDate())) {
                this.endSettleDate.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"91_DailySettleUI"));
                this.endSettleDate.setValue(null);
                SysUtil.abort();
            }
        } else if (this.endSettleDate.getSqlDate() != null && !this.startSettleDate.getSqlDate().after(this.endSettleDate.getSqlDate())) {
            this.endSettleDate.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"92_DailySettleUI"));
            this.endSettleDate.setValue(null);
            SysUtil.abort();
        }
        int settleNum = 1;
        if (endDate != null) {
            settleNum = DateUtil.getDiffDays((Date)startDate, (Date)endDate) - 1;
        }
        if (this.radioAntiDailySettle.isSelected()) {
            settleNum *= -1;
        }
        if (settleNum > 0) {
            this.settleDayNum.setValue((Object)new Integer(settleNum), false);
        }
    }

    public void onLoad() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
        BankInfo chInfo = FSClientHelper.getClearingHouse();
        if (!chInfo.isUsed()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"93_DailySettleUI"));
            SysUtil.abort();
        }
        this.chCompany = chInfo.getRelatedCompany();
        this.settleCtrlType = ContextHelperFactory.getRemoteInstance().getIntParam("TM024", (IObjectPK)new ObjectUuidPK(this.chCompany.getId()));
        this.settleDate = FSHelper.getDailySettledDate(null, this.chCompany.getId().toString());
        this.openDate = FSHelper.getCHOpenDate(null, this.chCompany.getId().toString());
        this.preSettleDate = DateUtil.getBeforeDay((Date)this.settleDate);
        this.nextSettleDate = DateUtil.getAfterDay((Date)this.settleDate);
        SpinnerNumberModel model1 = new SpinnerNumberModel(1, 1, 999, 1);
        this.settleDayNum.setModel((SpinnerModel)model1);
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws Exception {
        this.setImage();
        this.startSettleDate.setValue((Object)this.settleDate);
        this.settleDayNum.setValue((Object)new Integer(1));
        this.endSettleDate.setValue((Object)this.nextSettleDate);
    }

    private void setImage() {
        Icon guide = EASResource.getIcon((String)"imgGuide_pic260");
        KDLabel backlabel = new KDLabel(guide);
        backlabel.setBounds(0, 0, guide.getIconWidth(), guide.getIconHeight());
        this.pnlPicture.add((Component)backlabel, (Object)"Center");
        this.pnlPicture.setSize(guide.getIconWidth(), guide.getIconHeight());
        this.pnlPicture.setBackground(Color.blue);
    }

    @Override
    protected void radioDailySettle_actionPerformed(ActionEvent e) throws Exception {
        this.setNextSettleDate();
        this.setStartLabText((Component)e.getSource());
    }

    @Override
    protected void radioAntiDailySettle_actionPerformed(ActionEvent e) throws Exception {
        this.setNextSettleDate();
        this.setStartLabText((Component)e.getSource());
    }

    private void setDescText(boolean isSettle) {
        DateFormat df = CtrlFormatUtilities.getDateFormat();
        String settleText = MessageFormat.format(this.getResString("CurrentSettleDate"), df.format(this.settleDate));
        StringBuffer sb = new StringBuffer();
        sb.append(settleText);
        sb.append("\n");
        if (isSettle) {
            String nextSettleText = MessageFormat.format(this.getResString("NextSettleDate"), df.format(this.nextSettleDate));
            sb.append(nextSettleText);
        } else {
            String preSettleText = MessageFormat.format(this.getResString("PreSettleDate"), df.format(this.preSettleDate));
            sb.append(preSettleText);
        }
        this.txtDesc.setText(sb.toString());
    }

    private String getResString(String resName) {
        return EASResource.getString((String)resPath, (String)resName);
    }

    private void setStartLabText(Component component) {
        String compText = "";
        if (component instanceof KDRadioButton) {
            compText = ((KDRadioButton)component).getText();
        }
        String text = MessageFormat.format(this.getResString("StratSettle"), compText);
        this.lblInfo.setText(text);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
    }

    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        this.checkisSubsidiaryLedger();
        this.innerStart();
    }

    private void checkisSubsidiaryLedger() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        String key = company.getId().toString() + "_SubsidiaryLedgerBook";
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        boolean result = iMutex.requestObjIDForUpdate(key);
        if (result) {
            iMutex.releaseObjIDForUpdate(key);
        } else {
            String msg1 = EASResource.getString((String)this.resourcePath, (String)"BookProcessNow");
            MsgBox.showConfirm2((Component)((Object)this), (String)msg1);
            SysUtil.abort();
        }
    }

    private void innerStart() throws BOSException, EASBizException {
        Integer dayNum;
        Date endDate = (Date)this.endSettleDate.getValue();
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)this.resourcePath, (Object)endDate, (String)"NoDate");
        Date checkDate = null;
        String info = null;
        IDailySettleFacade iDailySettleFacade = DailySettleFacadeFactory.getRemoteInstance();
        if (this.radioDailySettle.isSelected()) {
            boolean canSettle;
            boolean result;
            dayNum = this.settleDayNum.getIntegerVlaue();
            Date lastSettleDate = DateUtil.getNextDay((Date)this.settleDate, (int)(dayNum - 1));
            if ((lastSettleDate.after(checkDate = this.settleDate.getMonth() <= 9 ? new Date(this.settleDate.getYear(), 9, 31) : new Date(this.settleDate.getYear() + 1, 9, 31)) || lastSettleDate.equals(checkDate)) && !(result = LicenseHelper.keyPointLicenseCheck())) {
                SysUtil.abort();
            }
            if (this.settleCtrlType == 1) {
                canSettle = iDailySettleFacade.checkCanSettle(this.chCompany.getId().toString(), lastSettleDate);
                if (!canSettle) {
                    int result2 = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)resPath, (String)"sureSettle"));
                    if (result2 == 1) {
                        this.btnOK.setVisible(false);
                        this.btnCancel.setText(this.getResString("Close"));
                        return;
                    }
                    if (result2 == 2) {
                        return;
                    }
                }
            } else if (this.settleCtrlType == 2 && !(canSettle = iDailySettleFacade.checkCanSettle(this.chCompany.getId().toString(), lastSettleDate))) {
                MsgBox.showWarning((String)EASResource.getString((String)resPath, (String)"cantSettle"));
                this.btnOK.setVisible(false);
                this.btnCancel.setText(this.getResString("Close"));
                SysUtil.abort();
            }
            iDailySettleFacade.dailySettleBatch(this.chCompany.getId().toString(), this.settleDate, dayNum);
            info = this.getResString("Success");
        } else if (this.radioAntiDailySettle.isSelected()) {
            if (this.openDate.compareTo((Date)this.endSettleDate.getValue()) > 0) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"94_DailySettleUI"));
                SysUtil.abort();
            }
            dayNum = this.settleDayNum.getIntegerVlaue();
            iDailySettleFacade.antiDailySettleBatch(this.chCompany.getId().toString(), this.preSettleDate, dayNum);
            info = this.getResString("AntiSettleSuccess");
        }
        this.settleDate = FSHelper.getDailySettledDate(null, this.chCompany.getId().toString());
        DateFormat df = CtrlFormatUtilities.getDateFormat();
        info = info + "\n" + MessageFormat.format(this.getResString("CurrentSettleDate"), df.format(this.settleDate));
        this.txtDesc.setText(info);
        this.radioDailySettle.setEnabled(false);
        this.radioAntiDailySettle.setEnabled(false);
        this.btnOK.setVisible(false);
        this.btnCancel.setText(this.getResString("Close"));
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }
}

