/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SummaryLedgerCollection;
import com.kingdee.eas.fm.fs.SummaryLedgerInfo;
import com.kingdee.eas.fm.fs.client.AbstractInitHandler;
import java.math.BigDecimal;
import java.util.Iterator;
import javax.swing.JTextField;

public class DepositInitHandler
extends AbstractInitHandler {
    @Override
    public void initTable(KDTable table, boolean isFirstDay) {
        String[] columnKeys = new String[]{"companyNum", "depositor", "inacctNum", "innerAccount", "debit", "credit", "balance"};
        String[] columnNames = new String[]{COMPANYNUM, DEPOSITOR, INACCTNUM, INNERACCT, YEARDEBITAMT, YEARCREDITAMT, OPENBALANCE};
        table.addColumns(columnKeys.length);
        IRow hRow = table.addHeadRow();
        for (int i = 0; i < columnKeys.length; ++i) {
            table.getColumn(i).setKey(columnKeys[i]);
            hRow.getCell(i).setValue((Object)columnNames[i]);
        }
        FMClientHelper.setNumberFormat((KDTable)table, (String)"debit", (String)this.getCurrency().getId().toString());
        FMClientHelper.setNumberFormat((KDTable)table, (String)"credit", (String)this.getCurrency().getId().toString());
        FMClientHelper.setNumberFormat((KDTable)table, (String)"balance", (String)this.getCurrency().getId().toString());
        this.setColumnLocked(table);
        table.getColumn("innerAccount").setWidth(150);
        table.getColumn("debit").setWidth(150);
        table.getColumn("credit").setWidth(150);
        table.getColumn("balance").setWidth(150);
        int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)this.getCurrency().getId());
        KDFormattedTextField txtField1 = new KDFormattedTextField(1);
        txtField1.setPrecision(prec);
        txtField1.setSupportedEmpty(true);
        table.getColumn("debit").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField1));
        KDFormattedTextField txtField2 = new KDFormattedTextField(1);
        txtField2.setPrecision(prec);
        txtField2.setSupportedEmpty(true);
        table.getColumn("credit").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField2));
        KDFormattedTextField txtField3 = new KDFormattedTextField(1);
        txtField3.setPrecision(prec);
        txtField3.setSupportedEmpty(true);
        table.getColumn("balance").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField3));
        if (isFirstDay) {
            table.getColumn("debit").getStyleAttributes().setHided(true);
            table.getColumn("credit").getStyleAttributes().setHided(true);
        }
    }

    @Override
    public void setColumnLocked(KDTable table) {
        table.getColumn("depositor").getStyleAttributes().setLocked(true);
        table.getColumn("innerAccount").getStyleAttributes().setLocked(true);
        table.getColumn("companyNum").getStyleAttributes().setLocked(true);
        table.getColumn("inacctNum").getStyleAttributes().setLocked(true);
    }

    @Override
    public void loadField(KDTable table) throws Exception {
        SummaryLedgerCollection slc = this.getColl();
        this.loadField(table, slc);
    }

    @Override
    public void loadField(KDTable table, SummaryLedgerCollection summaryColl) {
        table.removeRows();
        if (summaryColl != null && summaryColl.size() > 0) {
            FMHelper.sortCollection((AbstractObjectCollection)summaryColl, (String[])this.strArray);
            Iterator iter = summaryColl.iterator();
            while (iter.hasNext()) {
                SummaryLedgerInfo sli = (SummaryLedgerInfo)iter.next();
                IRow row = table.addRow();
                ICell depositoNum = row.getCell("companyNum");
                depositoNum.setValue((Object)sli.getApplyUnit().getNumber());
                ICell depositor = row.getCell("depositor");
                depositor.setValue((Object)sli.getApplyUnit().getName());
                depositor.setValue((Object)sli.getApplyUnit());
                ICell innerAccountNum = row.getCell("inacctNum");
                innerAccountNum.setValue((Object)sli.getInnerAccount().getNumber());
                ICell innerAccount = row.getCell("innerAccount");
                sli.getInnerAccount().setDisplayFormat("$name$");
                innerAccount.setValue((Object)sli.getInnerAccount());
                ICell debit = row.getCell("debit");
                debit.setValue((Object)FMHelper.getBigDecimalNULL((BigDecimal)sli.getDebitTotal()));
                ICell credit = row.getCell("credit");
                credit.setValue((Object)FMHelper.getBigDecimalNULL((BigDecimal)sli.getCreditTotal()));
                ICell openBalance = row.getCell("balance");
                openBalance.setValue((Object)FMHelper.getBigDecimalNULL((BigDecimal)sli.getEndBalance()));
            }
        }
        table.getColumn("companyNum").setMergeable(true);
        table.getColumn("companyNum").setGroup(true);
        table.getColumn("depositor").setMergeable(true);
        table.getColumn("depositor").setGroup(true);
        table.getColumn("innerAccount").setMergeable(true);
        table.getColumn("innerAccount").setGroup(true);
        table.getMergeManager().setMergeMode(5);
        table.getGroupManager().setGroup(true);
        table.getGroupManager().group();
    }

    @Override
    public SummaryLedgerCollection storeField(KDTable table) throws Exception {
        table.getEditManager().stopEditing();
        int rowCount = table.getRowCount();
        SummaryLedgerCollection slc = null;
        if (rowCount > 0) {
            slc = new SummaryLedgerCollection();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = table.getRow(i);
                if (this.isRowNotValid(row)) continue;
                SummaryLedgerInfo summaryLedgerInfo = new SummaryLedgerInfo();
                summaryLedgerInfo.setCurrency(this.getCurrency());
                summaryLedgerInfo.setInnerAccount((InnerAccountInfo)row.getCell("innerAccount").getValue());
                summaryLedgerInfo.setApplyUnit((CompanyOrgUnitInfo)row.getCell("depositor").getValue());
                summaryLedgerInfo.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
                BigDecimal debitTotal = FMHelper.getBigDecimal((Object)row.getCell("debit").getValue());
                summaryLedgerInfo.setDebitTotal(debitTotal);
                BigDecimal creditTotal = FMHelper.getBigDecimal((Object)row.getCell("credit").getValue());
                summaryLedgerInfo.setCreditTotal(creditTotal);
                BigDecimal balance = FMHelper.getBigDecimal((Object)row.getCell("balance").getValue());
                summaryLedgerInfo.setEndBalance(balance);
                summaryLedgerInfo.setBeginBalance(Constants.ZERO);
                summaryLedgerInfo.setDebitCounts(0);
                summaryLedgerInfo.setCreditCounts(0);
                summaryLedgerInfo.setLocalBeginBalance(Constants.ZERO);
                summaryLedgerInfo.setLocalDebitTotal(Constants.ZERO);
                summaryLedgerInfo.setLocalCreditTotal(Constants.ZERO);
                summaryLedgerInfo.setLocalEndBalance(Constants.ZERO);
                summaryLedgerInfo.setBeginBalanceDC(FSHelper.getBalanceDirection(summaryLedgerInfo.getBeginBalance()));
                summaryLedgerInfo.setEndBalanceDC(FSHelper.getBalanceDirection(summaryLedgerInfo.getEndBalance()));
                slc.add(summaryLedgerInfo);
            }
        }
        return slc;
    }

    private boolean isRowNotValid(IRow row) {
        Object debitObj = row.getCell("debit").getValue();
        Object creditObj = row.getCell("credit").getValue();
        Object balanceObj = row.getCell("balance").getValue();
        boolean isDebitNotValid = FMHelper.isZERO((BigDecimal)FMHelper.getBigDecimal((Object)debitObj));
        boolean isCreditNotValid = FMHelper.isZERO((BigDecimal)FMHelper.getBigDecimal((Object)creditObj));
        boolean isBalanceNotValid = FMHelper.isZERO((BigDecimal)FMHelper.getBigDecimal((Object)balanceObj));
        boolean isRowNotValid = isDebitNotValid && isCreditNotValid && isBalanceNotValid;
        return isRowNotValid;
    }
}

