/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.client.AbstractEntityBankAcntRelationUI;
import com.kingdee.eas.fm.fs.client.EntityBankAcntRelationFilerUI;
import com.kingdee.eas.fm.fs.client.EntityBankAcntRelationParam;
import com.kingdee.eas.fm.fs.client.EntityBankRelationHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EntityBankAcntRelationUI
extends AbstractEntityBankAcntRelationUI {
    private static final Logger logger = CoreUIObject.getLogger(EntityBankAcntRelationUI.class);
    EntityBankAcntRelationFilerUI filterUI = null;
    EntityBankAcntRelationParam param = null;

    public void onShow() throws Exception {
        super.onShow();
        this.treeList.requestFocus();
        this.initTable();
    }

    private void initTable() {
        this.tblMain.setColumnMoveable(false);
        this.tblMain.setEditable(false);
        this.tblMain.getColumn("openDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        this.tblMain.getColumn("closeDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
    }

    protected void execQuery() throws BOSException {
        this.param = (EntityBankAcntRelationParam)this.getFilterParam();
        Set bankAcntSet = null;
        try {
            bankAcntSet = this.getEntityBankAccountSet();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
        Map bankAcntMap = this.transMapBankAcntFromSet(bankAcntSet);
        EntityBankRelationHandler.initTree(this.treeList, bankAcntMap, this.param.getQueryType());
        this.fillTableData();
    }

    private void fillTableData() throws BOSException {
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        TreePath path = this.treeList.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        AccountBankInfo acntBankInfo = (AccountBankInfo)node.getUserObject();
        int layer = 0;
        if (acntBankInfo.getNumber().equals("root")) {
            layer = -1;
        }
        this.fillSubNodeData(node, layer);
    }

    private void fillSubNodeData(DefaultKingdeeTreeNode node, int layer) {
        int childCount = node.getChildCount();
        AccountBankInfo acntBankInfo = (AccountBankInfo)node.getUserObject();
        if (!acntBankInfo.getNumber().equals("root")) {
            this.addTblMainData(acntBankInfo, layer);
        }
        for (int i = 0; i < childCount; ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)this.treeList.getModel().getChild(node, i);
            this.fillSubNodeData(childNode, layer + 1);
        }
    }

    private void addTblMainData(AccountBankInfo acntBankInfo, int layer) {
        IRow row = this.tblMain.addRow();
        row.getCell("ID").setValue((Object)acntBankInfo.getId());
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < layer; ++i) {
            strBuf.append("      ");
        }
        row.getCell("number").setValue((Object)strBuf.append(acntBankInfo.getNumber()).toString());
        row.getCell("bankAccountNumber").setValue((Object)acntBankInfo.getBankAccountNumber());
        row.getCell("name").setValue((Object)acntBankInfo.getName());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)acntBankInfo.getBank())) {
            row.getCell("bank.name").setValue((Object)acntBankInfo.getBank().getName());
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)acntBankInfo.getCompany())) {
            row.getCell("company.name").setValue((Object)acntBankInfo.getCompany().getName());
        }
        row.getCell("openDate").setValue((Object)acntBankInfo.getOpenDate());
        row.getCell("closeDate").setValue((Object)acntBankInfo.getCloseDate());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)acntBankInfo.getCurrency())) {
            row.getCell("currency.name").setValue((Object)acntBankInfo.getCurrency().getName());
        }
        row.getCell("property").setValue((Object)acntBankInfo.getProperty().getName());
        row.getCell("isMotherAccount").setValue((Object)new Boolean(acntBankInfo.isIsMotherAccount()));
        row.getCell("isSetBankInterface").setValue((Object)new Boolean(acntBankInfo.isIsSetBankInterface()));
        row.getCell("bankInterFace").setValue((Object)acntBankInfo.getBankInterFace());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)acntBankInfo.getCtrlStrategy())) {
            row.getCell("ctrlStrategy.name").setValue((Object)acntBankInfo.getCtrlStrategy().getName());
        }
        row.getCell("description").setValue((Object)acntBankInfo.getDescription());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new EntityBankAcntRelationFilerUI();
        }
        return this.filterUI;
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    @Override
    protected void treeList_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeList_valueChanged(e);
        this.fillTableData();
    }

    private Map transMapBankAcntFromSet(Set motherAccountSet) {
        HashMap<String, AccountBankInfo> bankAccountMap = new HashMap<String, AccountBankInfo>();
        if (motherAccountSet == null) {
            return bankAccountMap;
        }
        for (AccountBankInfo info : motherAccountSet) {
            bankAccountMap.put(info.getId().toString(), info);
        }
        return bankAccountMap;
    }

    private Set getEntityBankAccountSet() throws EASBizException, BOSException {
        if (this.param.getMotherAccount() == null) {
            EntityViewInfo evi = this.getEntityDefViewInfo();
            AccountBankCollection coll = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
            String[] strInfos = new String[coll.size()];
            for (int i = 0; i < coll.size(); ++i) {
                strInfos[i] = new String();
                strInfos[i] = ((AccountBankInfo)coll.getObject(i)).getId().toString();
            }
            return this.getEntityBankAccountSetById(strInfos);
        }
        CoreBaseInfo[] infos = this.param.getMotherAccount();
        String[] strInfos = new String[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            strInfos[i] = ((AccountBankInfo)infos[i]).getId().toString();
        }
        return this.getEntityBankAccountSetById(strInfos);
    }

    private Set getEntityBankAccountSetById(String[] strInfos) throws EASBizException, BOSException {
        HashSet<AccountBankInfo> bankSet = new HashSet<AccountBankInfo>();
        if (EmptyUtil.isEmpty((Object[])strInfos)) {
            return bankSet;
        }
        AccountBankCollection coll = AccountBankFactory.getRemoteInstance().getAccountTreeByids(strInfos);
        for (int i = 0; i < coll.size(); ++i) {
            bankSet.add((AccountBankInfo)coll.getObject(i));
        }
        return bankSet;
    }

    private EntityViewInfo getEntityDefViewInfo() throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = this.getAccountBankSelector();
        evi.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        evi.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("isMotherAccount", (Object)Boolean.TRUE, CompareType.EQUALS));
        Set companyIdSet = this.param.getCompanyIdSet();
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        companyIdSet.add(currentCompany.getId().toString());
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyIdSet, CompareType.INCLUDE));
        AccountBankCollection coll = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        HashSet<String> idSet = new HashSet<String>();
        for (int index = 0; index < coll.size(); ++index) {
            idSet.add(coll.get(index).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isMotherAccount", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("subAccount", idSet, CompareType.INCLUDE));
        filter.setMaskString("(#0 and #1) or #2");
        view.setFilter(filter);
        return view;
    }

    private SelectorItemCollection getAccountBankSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ID"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }
}

