/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountPropertyCollection;
import com.kingdee.eas.basedata.assistant.AccountPropertyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.client.AbstractInAcctBalanceFilterUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.InAcctBalanceparam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class InAcctBalanceFilterUI
extends AbstractInAcctBalanceFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InAcctBalanceFilterUI.class);
    CompanyOrgUnitCollection coll = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        InAcctBalanceparam para = new InAcctBalanceparam();
        para.setCompanyIds(this.getCompanyIds());
        para.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        para.setRptDate((Date)this.pkRptDate.getValue());
        para.setIncludeClose(this.chkIncludeClose.isSelected());
        para.setShowTotal(this.chkIsShowTotal.isSelected());
        para.setShowLargeZero(this.chkIsShowLargeZero.isSelected());
        para.setAccountPropertyIds(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtAccountProperty));
        return para;
    }

    public void setParam(Object param) {
        if (EmptyUtil.isEmpty((Object)param)) {
            return;
        }
        InAcctBalanceparam para = (InAcctBalanceparam)param;
        try {
            if (!EmptyUtil.isEmpty((String)para.getCurrencyId())) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                CurrencyInfo currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(para.getCurrencyId()));
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currencyInfo);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        this.setCompanyIds(para.getCompanyIds());
        this.pkRptDate.setValue((Object)para.getRptDate());
        this.chkIncludeClose.setSelected(para.isIncludeClose());
        this.chkIsShowTotal.setSelected(para.isShowTotal());
        this.chkIsShowLargeZero.setSelected(para.isShowLargeZero());
        if (!FMHelper.isEmpty((Object[])para.getAccountPropertyIds())) {
            Set set = FMHelper.asSet((String[])para.getAccountPropertyIds());
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            ev.setFilter(filter);
            try {
                AccountPropertyCollection coll = AccountPropertyFactory.getRemoteInstance().getAccountPropertyCollection(ev);
                this.prmtAccountProperty.setData((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
    }

    protected void init() throws Exception {
        super.init();
        this.pkRptDate.setSupportedEmpty(false);
        this.clear();
    }

    protected void initCompanyState() {
        super.initCompanyState();
        if (FSClientHelper.isClearingHouseCompanyId(null)) {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    private void initCompany() throws EASBizException, BOSException {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany) || this.currentCompany.getId().toString().equals(FSClientHelper.getClearingHouseCompany().getId().toString())) {
            if (this.coll == null) {
                try {
                    this.coll = InAcctFactory.getRemoteInstance().getInAcctApplyCompany();
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
            }
            this.setCompanyIdSet(AccessHelper.getIds((Object[])this.coll.toArray()));
        } else {
            this.setCompanyIds(new String[]{this.currentCompany.getId().toString()});
        }
    }

    private void popNode(List list, DefaultKingdeeTreeNode root) {
        Enumeration c = root.children();
        while (c.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)c.nextElement();
            if (node.isCheckBoxEnabled()) {
                OrgStructureInfo org = (OrgStructureInfo)node.getUserObject();
                FullOrgUnitInfo fullUnit = org.getUnit();
                list.add(fullUnit);
            }
            this.popNode(list, node);
        }
    }

    public void clear() {
        this.pkRptDate.setValue((Object)new Date());
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.chkIncludeClose.setSelected(false);
        this.chkIsShowTotal.setSelected(false);
        try {
            this.initCompany();
        }
        catch (EASBizException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        super.clear();
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    public boolean verify() {
        Date rptDate = (Date)this.pkRptDate.getValue();
        Date openDate = null;
        try {
            openDate = FSClientHelper.getClearingHouse().getOpenDate();
        }
        catch (EASBizException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        if (rptDate.before(openDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillUI", (String)"MustBigOpenDate"));
            return false;
        }
        return super.verify();
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.prmtAccountProperty.setValue(null);
        this.chkIsShowLargeZero.setSelected(false);
    }

    protected Class getParamClass() {
        return InAcctBalanceparam.class;
    }
}

