/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMBatchProcessFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fee.FeeBillFactory;
import com.kingdee.eas.fm.fs.IInnerAccountInit;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInitFactory;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SummaryLedgerCollection;
import com.kingdee.eas.fm.fs.SummaryLedgerInfo;
import com.kingdee.eas.fm.fs.client.AbstractInitHandler;
import com.kingdee.eas.fm.fs.client.AbstractInnerAccountInitUI;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.InAcctInputSettingUI;
import com.kingdee.eas.fm.fs.client.InitBalanceUI;
import com.kingdee.eas.fm.im.IntObjectFactory;
import com.kingdee.eas.fm.im.IntObjectSourceTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;

public class InnerAccountInitUI
extends AbstractInnerAccountInitUI {
    public static final String resPath = "com.kingdee.eas.fm.fs.FSClientResource";
    private AbstractInitHandler handler;
    private boolean openDateIsFirstDay;
    private boolean isAcctTypeFirst = false;
    private boolean isCurrencyFirst = false;
    private boolean isEdit = false;
    private boolean isSave = false;
    private BigDecimal oldVal = null;
    private ICell selectedCell = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private FmRpcCacheInfo rpcCacheInfo = null;

    @Override
    public void loadFields() {
        try {
            this.handler.loadField(this.tblMain);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionImportGL_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        SummaryLedgerCollection summaryColl = InnerAccountInitFactory.getRemoteInstance().importGL(this.companyInfo.getId().toString(), currency.getId().toString());
        this.handler.loadField(this.tblMain, summaryColl);
        this.isSave = false;
        this.isEdit = true;
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"98_InnerAccountInitUI"));
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        super.actionImport_actionPerformed(e);
        FSClientHelper.importFromExcel((Component)((Object)this), this.tblMain);
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
        FMClientHelper.exportExcel((Component)((Object)this), (KDTable)this.tblMain, (boolean)false);
    }

    @Override
    public void actionCheckBalance_actionPerformed(ActionEvent e) throws Exception {
        IInnerAccountInit iInnerInit = InnerAccountInitFactory.getRemoteInstance();
        IRowSet rs = iInnerInit.checkBalance(this.companyInfo.getId().toString());
        if (!EmptyUtil.isEmpty((Object)rs) && rs.next()) {
            InitBalanceUI.showDialogWindows((IUIObject)this, rs);
        } else {
            this.showStatusMessage(EASResource.getString((String)resPath, (String)"checkBalanceSuccess"));
        }
    }

    @Override
    public void actionInit_actionPerformed(ActionEvent e) throws Exception {
        if (FSClientHelper.clearingHouseIsUsed(null)) {
            this.setActionEnable(true);
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resPath, (String)"InnerAcctInitialized"));
            return;
        }
        if (this.isEdit && !this.isSave) {
            int flag = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"CheckSaveMsg"));
            switch (flag) {
                case 0: {
                    this.submit();
                }
                case 1: {
                    this.initTable();
                    this.loadFields();
                }
            }
            return;
        }
        this.checkBalance();
        String companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        IInnerAccountInit init = InnerAccountInitFactory.getRemoteInstance();
        init.init(companyId);
        this.showStatusMessage(EASResource.getString((String)resPath, (String)"initialized"));
        this.setActionEnable(true);
    }

    public void checkBalance() throws Exception {
        String resClassName;
        String msg;
        int result;
        ISystemStatusCtrol iSystemCtrl = SystemStatusCtrolFactory.getRemoteInstance();
        boolean glIsStart = iSystemCtrl.isStart(SystemEnum.GENERALLEDGER.getValue(), this.companyInfo.getId().toString());
        if (!glIsStart) {
            return;
        }
        IInnerAccountInit iInnerInit = InnerAccountInitFactory.getRemoteInstance();
        IRowSet rs = iInnerInit.checkBalance(this.companyInfo.getId().toString());
        if (!EmptyUtil.isEmpty((Object)rs) && rs.next() && (result = MsgBox.showConfirm2((Component)((Object)this), (String)(msg = EASResource.getString((String)(resClassName = "com.kingdee.eas.fm.fs.client.InnerAccountResource"), (String)"checkBalanceNotPass")))) == 2) {
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    private void submit() {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        try {
            if (FSClientHelper.clearingHouseIsUsed(null)) {
                this.setActionEnable(true);
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resPath, (String)"InnerAcctInitialized"));
                this.abort();
            }
            IInnerAccountInit manager = InnerAccountInitFactory.getRemoteInstance();
            SummaryLedgerCollection coll = this.handler.storeField(this.tblMain);
            manager.submit(coll, ((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString());
            this.isSave = true;
            this.isEdit = false;
            this.showStatusMessage(AbstractInitHandler.SAVESUCCEED);
        }
        catch (IllegalArgumentException e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resPath, (String)"MoneyIsNotValid"));
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    @Override
    public void actionAntiInit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiInit_actionPerformed(e);
        this.antiInit();
        this.btnSubmit.setEnabled(true);
    }

    protected IObjectValue createNewData() {
        return new SummaryLedgerInfo();
    }

    public void onLoad() throws Exception {
        boolean isChCompany;
        if (this.rpcCacheInfo == null) {
            FmRpcCacheInfo paramInfo = new FmRpcCacheInfo();
            paramInfo.setBatchImplClassName("com.kingdee.eas.fm.fs.app.InnerAcctInitBatchFetcher");
            this.rpcCacheInfo = FMBatchProcessFacadeFactory.getRemoteInstance().batchFetchData(paramInfo);
        }
        if (!(isChCompany = this.rpcCacheInfo.getBoolean("isChCompany"))) {
            MsgBox.showError((String)EASResource.getString((String)resPath, (String)"mustToChCompany"));
            SysUtil.abort();
        }
        this.companyInfo = this.rpcCacheInfo.getCurrentCompany();
        this.isAcctTypeFirst = true;
        this.isCurrencyFirst = true;
        this.initControl();
        this.initTable();
        super.onLoad();
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuView.setVisible(false);
        if (this.rpcCacheInfo.getBoolean("isChUsed")) {
            this.setActionEnable(true);
        }
        this.btnInAcctInputSetting.setVisible(false);
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
    }

    private void initControl() throws EASBizException, BOSException, Exception {
        this.tblMain.checkParsed();
        BankInfo clearingHouseInfo = (BankInfo)this.rpcCacheInfo.get("clearingHouse");
        Date openDate = clearingHouseInfo.getOpenDate();
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        this.txtBeginDate.setText(dtformat.format(openDate));
        this.txtBeginDate.setUserObject((Object)openDate);
        this.txtBeginDate.setEditable(false);
        this.setActionEnable(clearingHouseInfo.isUsed());
        this.openDateIsFirstDay = DateUtil.isFirstDayOfYear((Date)openDate);
        CurrencyCollection currencys = this.rpcCacheInfo.getAllCurrencyColl();
        this.cboCurrency.addItems(currencys.toArray());
        CurrencyInfo currency = CurrencyUtil.getLocalCurrency();
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currency);
        this.enableExportExcel(this.tblMain);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionImportGL.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_input"));
        this.actionImport.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_input"));
        this.actionExport.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_output"));
        this.actionCheckBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_trialbalance"));
        this.actionInit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_initialize"));
        this.actionAntiInit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_finitialize"));
        this.kDSeparator2.setVisible(false);
        this.separatorFile1.setVisible(false);
    }

    public void antiInit() throws Exception {
        IInnerAccountInit init;
        String companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        if (!FSClientHelper.clearingHouseIsUsed(null)) {
            this.setActionEnable(false);
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resPath, (String)"unInitialized"));
            this.abort();
        }
        if (!(init = InnerAccountInitFactory.getRemoteInstance()).checkDate(companyId)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resPath, (String)"dateNotEqual"));
            SysUtil.abort();
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyId));
        if (SettlementBillFactory.getRemoteInstance().exists(filterInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resPath, (String)"bizOccurred"));
            SysUtil.abort();
        }
        FilterInfo feeFilter = new FilterInfo();
        feeFilter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId));
        feeFilter.getFilterItems().add(new FilterItemInfo("innerAccount", null, CompareType.NOTEQUALS));
        if (FeeBillFactory.getRemoteInstance().exists(feeFilter)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resPath, (String)"bizOccurred"));
            SysUtil.abort();
        }
        FilterInfo imFilter = new FilterInfo();
        imFilter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId));
        imFilter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)IntObjectSourceTypeEnum.INNERACCT));
        if (IntObjectFactory.getRemoteInstance().exists(imFilter)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resPath, (String)"bizOccurred"));
            SysUtil.abort();
        }
        init.antiInit(companyId);
        String txt = EASResource.getString((String)resPath, (String)"unInitialized");
        this.showStatusMessage(txt);
        this.setActionEnable(false);
        this.handler.setColumnLocked(this.tblMain);
    }

    public void initTable() throws Exception {
        this.isEdit = false;
        this.isSave = false;
        FMClientHelper.clearTable((KDTable)this.tblMain);
        this.handler = AbstractInitHandler.getInstance();
        this.handler.setClearingHouseInfo((BankInfo)this.rpcCacheInfo.get("clearingHouse"));
        this.handler.setCurrency((CurrencyInfo)this.cboCurrency.getSelectedItem());
        this.handler.setBeginDate((Date)this.txtBeginDate.getUserObject());
        this.handler.initTable(this.tblMain, this.openDateIsFirstDay);
        this.tblMain.setActiveCellStatus(1);
    }

    private void setActionEnable(boolean isUsed) {
        this.actionSubmit.setEnabled(!isUsed);
        this.actionImport.setEnabled(!isUsed);
        this.actionImportGL.setEnabled(!isUsed);
        this.actionCheckBalance.setEnabled(!isUsed);
        this.actionInit.setEnabled(!isUsed);
        this.actionAntiInit.setEnabled(isUsed);
        this.actionInAcctInputSetting.setEnabled(!isUsed);
        this.tblMain.getStyleAttributes().setLocked(isUsed);
    }

    private void showStatusMessage(String msg) {
        this.setMessageText(msg);
        this.showMessage();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InnerAccountFactory.getRemoteInstance();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isCurrencyFirst && this.handler.getCurrency().equals(this.cboCurrency.getSelectedItem())) {
            return;
        }
        this.isCurrencyFirst = false;
        super.cboCurrency_actionPerformed(e);
        int flag = -1;
        if (this.isEdit && !this.isSave) {
            flag = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"CheckSaveAndSwitch"));
        } else {
            this.initTable();
            this.loadFields();
        }
        switch (flag) {
            case 0: {
                this.actionSubmit_actionPerformed(null);
            }
            case 1: {
                this.initTable();
                this.cboCurrency.setSelectedItem((Object)this.handler.getCurrency());
                this.loadFields();
            }
            case 2: {
                this.cboCurrency.setSelectedItem((Object)this.handler.getCurrency());
                return;
            }
        }
    }

    public boolean checkBeforeWindowClosing() {
        int flag = -1;
        if (this.isEdit && !this.isSave) {
            flag = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"CheckSaveAndExit"));
        }
        switch (flag) {
            case 0: {
                this.submit();
                return super.checkBeforeWindowClosing();
            }
            case 1: {
                return super.checkBeforeWindowClosing();
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        int selectedCol = this.tblMain.getSelectManager().getActiveColumnIndex();
        int row = this.tblMain.getSelectManager().getActiveRowIndex();
        this.selectedCell = this.tblMain.getCell(row, selectedCol);
        this.oldVal = this.selectedCell.getValue() instanceof Integer ? new BigDecimal(this.selectedCell.getValue().toString()) : (BigDecimal)this.selectedCell.getValue();
        super.tblMain_editStarting(e);
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        int column = this.tblMain.getColumnIndex("beginBalance");
        Object selectedObject = null;
        if (this.selectedCell != null) {
            selectedObject = this.selectedCell.getValue();
        }
        boolean isNull = false;
        if (selectedObject == null) {
            isNull = true;
        }
        if (isNull) {
            this.selectedCell.setValue(null);
        }
        if (this.oldVal == null && !isNull || this.oldVal != null && isNull) {
            this.isEdit = true;
            this.isSave = false;
        }
        if (this.oldVal != null && !isNull) {
            BigDecimal newVal = this.getBigDecimal(selectedObject);
            if (this.getBigDecimal(this.oldVal).compareTo(newVal) != 0) {
                this.isEdit = true;
            }
            this.isSave = false;
        }
        IRow row = this.tblMain.getRow(e.getRowIndex());
        BigDecimal amount = null;
        if (this.tblMain.getColumnKey(e.getColIndex()).equals("yearCreditAmt")) {
            amount = (BigDecimal)row.getCell("yearCreditAmt").getValue();
            if (amount == null) {
                return;
            }
            if (amount.compareTo(Constants.MAX_VALUE) == 1) {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
                this.showMessage();
                row.getCell("yearCreditAmt").setValue(null);
            }
        }
        if (this.tblMain.getColumnKey(e.getColIndex()).equals("yearDebitAmt")) {
            amount = (BigDecimal)row.getCell("yearDebitAmt").getValue();
            if (amount == null) {
                return;
            }
            if (amount.compareTo(Constants.MAX_VALUE) == 1) {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
                this.showMessage();
                row.getCell("yearDebitAmt").setValue(null);
            }
        }
        if (this.tblMain.getColumnKey(e.getColIndex()).equals("beginBalance")) {
            amount = (BigDecimal)row.getCell("beginBalance").getValue();
            if (amount == null) {
                return;
            }
            if (amount.compareTo(Constants.MAX_VALUE) == 1) {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
                this.showMessage();
                row.getCell("beginBalance").setValue(null);
            }
        }
        if (this.tblMain.getColumnKey(e.getColIndex()).equals("credit")) {
            amount = (BigDecimal)row.getCell("credit").getValue();
            if (amount == null) {
                return;
            }
            if (amount.compareTo(Constants.MAX_VALUE) == 1) {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
                this.showMessage();
                row.getCell("credit").setValue(null);
            }
        }
        if (this.tblMain.getColumnKey(e.getColIndex()).equals("debit")) {
            amount = (BigDecimal)row.getCell("debit").getValue();
            if (amount == null) {
                return;
            }
            if (amount.compareTo(Constants.MAX_VALUE) == 1) {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
                this.showMessage();
                row.getCell("debit").setValue(null);
            }
        }
    }

    public BigDecimal getBigDecimal(Object obj) {
        return FMHelper.getBigDecimal((Object)obj);
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void showAddNew() {
    }

    @Override
    public void actionInAcctInputSetting_actionPerformed(ActionEvent e) throws Exception {
        super.actionInAcctInputSetting_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InAcctInputSettingUI.class.getName(), (Map)uiContext, null, "VIEW");
        uiWindow.show();
        this.initControl();
    }
}

