/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountPropertyInfo;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.AbstractInnerAccountUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.IntObjectCollection;
import com.kingdee.eas.fm.im.IntObjectFactory;
import com.kingdee.eas.fm.im.IntObjectInfo;
import com.kingdee.eas.fm.im.client.IntObjectEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.EventObject;

public class InnerAccountUI
extends AbstractInnerAccountUI {
    private static final String resourcePath = "com.kingdee.eas.fm.fs.client.InnerAccountResource";
    String resClassName = "com.kingdee.eas.basedata.assistant.client.assistantResource";
    private BankInfo clearingHouse;
    private InnerAccountInfo oldData;

    @Override
    protected void txtName_actionPerformed(ActionEvent e) throws Exception {
        super.txtName_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sel = super.getSelectors();
        sel.add("*");
        return sel;
    }

    @Override
    protected IObjectValue createNewData() {
        try {
            FSClientHelper.checkClearingHouseCompany();
        }
        catch (EASBizException e1) {
            SysUtil.abort((Throwable)e1);
        }
        catch (BOSException e1) {
            SysUtil.abort((Throwable)e1);
        }
        InnerAccountInfo info = new InnerAccountInfo();
        if (this.getUIContext().get("innerAccountInfo") != null) {
            info = (InnerAccountInfo)this.getUIContext().get("innerAccountInfo");
        }
        info.setIsUsed(true);
        info.setClosed(false);
        UserInfo user = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        CompanyOrgUnitInfo cur = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (user != null) {
            info.setCreator(user);
        }
        try {
            BankInfo bankInfo = BankFactory.getRemoteInstance().getClearingHouse(cur.getId().toString());
            info.setClearingHouse(bankInfo);
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        if (this.clearingHouse.isUsed()) {
            Date settleDate = this.clearingHouse.getSettleDate();
            if (settleDate != null) {
                info.setOpenDepositDate((Date)new Timestamp(DateTimeUtils.truncateDate((Date)settleDate).getTime()));
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SettleDateIsNull"));
                SysUtil.abort();
            }
        } else {
            info.setOpenDepositDate((Date)DateUtil.getTimeStampDayBegin());
        }
        Object pk = this.getUIContext().get("company");
        if (pk != null) {
            CompanyOrgUnitInfo company = null;
            try {
                ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
                company = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk.toString()));
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
                    company = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (company != null) {
                info.setApplyUnit(company);
            }
        }
        info.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        return info;
    }

    private static boolean existsInnerAccount(String companyId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        return InnerAccountFactory.getRemoteInstance().exists(filterInfo);
    }

    @Override
    protected void prmtapplyUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtapplyUnit_dataChanged(e);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtapplyUnit.getData();
        if (this.oprtState.equals(OprtState.VIEW)) {
            return;
        }
        if (company != null) {
            if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CanNotOnlyUnion"));
                this.prmtapplyUnit.setData(null);
                return;
            }
        } else {
            return;
        }
        try {
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtapplyUnit.getData();
            if (companyInfo == null) {
                return;
            }
            String companyId = companyInfo.getId().toString();
            if (InnerAccountUI.existsInnerAccount(companyId)) {
                StringBuffer sb = new StringBuffer();
                sb.append("select top 1 FCreditLevel as FCreditLevel  from T_FS_InnerAccount\n");
                sb.append("where FCompanyID='").append(companyId).append("'");
                IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
                rs.next();
            }
        }
        catch (EASBizException ex) {
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
        catch (BOSException ex) {
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
        catch (SQLException ex) {
            this.handUIExceptionAndAbort(ex);
        }
        this.initDataStatus();
    }

    @Override
    protected void prmtAcctView_willShow(SelectorEvent e) throws Exception {
        this.setAcctViewProp((EventObject)e);
    }

    @Override
    protected void prmtAcctView_willCommit(CommitEvent e) throws Exception {
        this.setAcctViewProp((EventObject)e);
    }

    private void setAcctViewProp(EventObject e) {
        CompanyOrgUnitInfo company = this.clearingHouse.getRelatedCompany();
        if (company == null) {
            if (e instanceof SelectorEvent) {
                ((SelectorEvent)e).setCanceled(true);
            } else if (e instanceof CommitEvent) {
                ((CommitEvent)e).setCanceled(true);
                ((KDPromptBox)e.getSource()).setData(null);
            }
            return;
        }
        String cuId = company.getId().toString();
        String accountTable = null;
        if (company.getAccountTable() != null) {
            accountTable = company.getAccountTable().getId().toString();
        }
        EntityViewInfo treeEvi = CasRecPayHandler.getCustomAcctEvi((String)cuId, (String)accountTable, (boolean)false, (boolean)true);
        EntityViewInfo evi = CasRecPayHandler.getCustomAcctEvi((String)cuId, (String)accountTable, (boolean)true, (boolean)true);
        AccountPromptBox acctPrmtBox = new AccountPromptBox((IUIObject)this, company, treeEvi.getFilter(), false, true);
        this.prmtAcctView.setEntityViewInfo(evi);
        this.prmtAcctView.setSelector((KDPromptSelector)acctPrmtBox);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return InnerAccountFactory.getRemoteInstance();
    }

    private void init() throws BOSException, EASBizException {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionAddNew.setEnabled(false);
            this.f7ClhClassification.setEnabled(false);
            this.prmtAcctView.setEnabled(false);
            this.prmtapplyUnit.setEnabled(false);
            this.prmtAccountProperty.setEnabled(false);
        }
        this.btnPageSetup.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtapplyUnit.getData();
        if (company == null) {
            // empty if block
        }
        if (this.clearingHouse.isUsed()) {
            this.dtpCreateDate.setEnabled(false);
        }
        NewCompanyF7 f7 = new NewCompanyF7((IUIObject)this);
        f7.setNeedAddOrgRange(false);
        this.prmtapplyUnit.setSelector((KDPromptSelector)f7);
        this.txtName.setRequired(true);
        this.txtName.setMaxLength(70);
        this.txtNumber.setRequired(true);
        this.dtpCreateDate.setRequired(true);
        this.prmtapplyUnit.setRequired(true);
        this.prmtapplyUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        evi.setFilter(filter);
        this.prmtdeFaultAcctBank.setEntityViewInfo(evi);
    }

    protected void initDataStatus() {
        String applyBillId;
        super.initDataStatus();
        InnerAccountInfo info = (InnerAccountInfo)this.getDataObject();
        if (!this.oprtState.equals(OprtState.ADDNEW)) {
            this.prmtapplyUnit.setEnabled(false);
        } else {
            this.prmtapplyUnit.setEnabled(true);
        }
        String oprtS = this.getOprtState();
        boolean canAddNew = !"FINDVIEW".equals(oprtS);
        this.actionAddNew.setVisible(canAddNew);
        this.actionAddNew.setEnabled(canAddNew);
        boolean canSubmit = !"FINDVIEW".equals(oprtS) && !"VIEW".equals(oprtS);
        this.actionSubmit.setVisible(canSubmit);
        this.actionSubmit.setEnabled(canSubmit);
        if (this.oprtState.equals("FINDVIEW")) {
            this.lockUIForViewStatus();
            this.lockAllComps();
        }
        if ((applyBillId = info.getApplyBillId()) != null && !"".equals(applyBillId.trim())) {
            this.prmtapplyUnit.setEnabled(false);
            this.prmtAccountProperty.setEnabled(false);
            this.textAreaDesc.setEnabled(true);
        }
    }

    private void lockAllComps() {
        Component[] conts = this.getComponents();
        Component[] comps = ((Container)conts[0]).getComponents();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setEnabled(false);
        }
    }

    protected void initOldData(IObjectValue dataObject) {
        super.initOldData(dataObject);
    }

    public boolean isModify() {
        if (this.oprtState.equals(OprtState.ADDNEW) || this.oprtState.equals(OprtState.VIEW)) {
            return super.isModify();
        }
        this.storeFields();
        if (this.oldData.getName() == null && this.editData.getName() != null) {
            return true;
        }
        if (this.editData.getName() != null && !this.oldData.getName().equals(this.editData.getName())) {
            return true;
        }
        if (this.oldData.getNumber() != null && !this.oldData.getNumber().equals(this.editData.getNumber())) {
            return true;
        }
        if (this.oldData.getAcctNumber() != null && !this.oldData.getAcctNumber().equals(this.editData.getAcctNumber())) {
            return true;
        }
        if (this.oldData.getCtrlParam() != null && this.editData.getCtrlParam() == null) {
            return true;
        }
        if (this.oldData.getCtrlParam() != null && !this.oldData.getCtrlParam().getId().equals((Object)this.editData.getCtrlParam().getId())) {
            return true;
        }
        if (!this.oldData.getCompany().equals((Object)this.editData.getCompany())) {
            return true;
        }
        if (this.oldData.getType() == null && this.editData.getType() != null) {
            return true;
        }
        if (this.oldData.getType() != null && this.editData.getType() == null) {
            return true;
        }
        if (this.oldData.getType() != null && this.editData.getType() != null && !this.oldData.getType().equals((Object)this.editData.getType())) {
            return true;
        }
        if (!this.oldData.getOpenDepositDate().equals(this.editData.getOpenDepositDate())) {
            return true;
        }
        if (this.oldData.getClhClassification() == null && this.editData.getClhClassification() != null) {
            return true;
        }
        if (this.oldData.getClhClassification() != null && !this.oldData.getClhClassification().equals((Object)this.editData.getClhClassification())) {
            return true;
        }
        if (this.oldData.getAcctView() == null && this.editData.getAcctView() != null) {
            return true;
        }
        return this.oldData.getAcctView() != null && !this.oldData.getAcctView().equals((Object)this.editData.getAcctView());
    }

    @Override
    public void loadFields() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        }
        super.loadFields();
        this.initDataStatus();
        this.oldData = (InnerAccountInfo)this.editData.clone();
    }

    public void onLoad() throws Exception {
        try {
            this.clearingHouse = FSClientHelper.getClearingHouse();
        }
        catch (EASBizException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        if (this.clearingHouse == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"MustSetClearingHouse"));
            SysUtil.abort();
        }
        super.onLoad();
        this.init();
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.txtName});
    }

    protected void verifyInput(ActionEvent arg0) throws Exception {
        super.verifyInput(arg0);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDTextField)this.txtNumber, (String)"NumberIsNull");
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDMultiLangBox)this.txtName, (String)"NameIsNull");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.prmtapplyUnit, (String)"applyUnitIsNull");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtapplyUnit.getData();
        if (company != null && GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CanNotOnlyUnion"));
            this.prmtapplyUnit.setData(null);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDTextField)this.txtAcctNumber, (String)"acctNumberIsNull");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.dtpCreateDate, (String)"createDateIsNull");
        this.verifyOpenDate(this.editData.getOpenDepositDate());
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.prmtAccountProperty, (String)"acctPropertyIsNull");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.prmtAcctView, (String)"acctViewIsNull");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.prmtCtrlParam, (String)"ctrlParamIsNull");
        if (this.chkisDefaultReck.isSelected() && !this.chkisReckoning.isSelected()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"102_InnerAccountUI"));
            this.chkisDefaultReck.setSelected(false);
            SysUtil.abort();
        }
        if (this.chkisReckoning.isSelected()) {
            this.verifyApplyUnit();
        }
    }

    private void verifyApplyUnit() throws BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtapplyUnit.getData();
        if (companyInfo != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("relatedCompany.id", (Object)companyInfo.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("inGroup", (Object)new Boolean(true)));
            if (this.clearingHouse != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("parentInGroup", (Object)this.clearingHouse.getId().toString()));
            }
            evi.setFilter(filterInfo);
            BankCollection coll = BankFactory.getRemoteInstance().getBankCollection(evi);
            if (coll == null || coll.size() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"reckoningApplyUnitMustBeDown"));
                this.prmtapplyUnit.requestFocus();
                SysUtil.abort();
            }
        }
    }

    private void verifyOpenDate(Date innerOpenDate) {
        if (!this.clearingHouse.isUsed()) {
            innerOpenDate = DateTimeUtils.truncateDate((Date)innerOpenDate);
            Date openDate = DateTimeUtils.truncateDate((Date)this.clearingHouse.getOpenDate());
            if (innerOpenDate != null && !innerOpenDate.before(openDate)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"OpenDateBig"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        BankInfo clearingHouse = FSClientHelper.getClearingHouse();
        if (!clearingHouse.isUsed()) {
            super.actionSubmit_actionPerformed(e);
        } else {
            this.processAction(e);
        }
    }

    private void processAction(ActionEvent e) throws Exception {
        BOSUuid companyID;
        IContextHelper ctxHelper = ContextHelperFactory.getRemoteInstance();
        if (this.isAutoAddIntObject(ctxHelper, companyID = ctxHelper.getCurrentCompany().getId())) {
            this.verify(e);
            if (this.editData.getId() == null) {
                this.editData.setId(BOSUuid.create((BOSObjectType)this.editData.getBOSType()));
            }
            if (OprtState.EDIT == this.getOprtState() || OprtState.ADDNEW == this.getOprtState()) {
                if (!this.hasRefIntObject(this.editData)) {
                    if (!this.isFixCredit()) {
                        IntObjectInfo intObjectInfo = IntObjectEditUI.showIntObjectEditUI((CoreUIObject)this, (CoreBaseInfo)this.editData);
                        if (!intObjectInfo.getIsExit()) {
                            this.editData.setIntObjectInfo((IObjectValue)intObjectInfo);
                            super.actionSubmit_actionPerformed(e);
                        }
                    } else {
                        super.actionSubmit_actionPerformed(e);
                    }
                } else {
                    super.actionSubmit_actionPerformed(e);
                }
            } else {
                IntObjectInfo intObjectInfo = IntObjectEditUI.showIntObjectEditUI((CoreUIObject)this, (CoreBaseInfo)this.editData);
                if (!intObjectInfo.getIsExit()) {
                    this.editData.setIntObjectInfo((IObjectValue)intObjectInfo);
                    super.actionSubmit_actionPerformed(e);
                }
            }
        } else {
            super.actionSubmit_actionPerformed(e);
        }
    }

    private void emptyUI() {
        this.txtNumber.setText("");
        this.txtAcctNumber.setText("");
        this.txtName.setSelectedItem(null);
        this.prmtapplyUnit.setValue(null);
        this.f7Shutter.setValue(null);
        this.prmtAccountProperty.setValue(null);
        this.prmtCtrlParam.setValue(null);
        this.prmtAcctView.setValue(null);
        this.f7ClhClassification.setValue(null);
        this.textAreaDesc.setSelectedItem(null);
    }

    private boolean hasRefIntObject(InnerAccountInfo innerAccount) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("sourceId", (Object)new ObjectUuidPK(innerAccount.getId())));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IntObjectCollection col = IntObjectFactory.getRemoteInstance().getIntObjectCollection(evi);
        return col != null && col.size() > 0;
    }

    private boolean isAutoAddIntObject(IContextHelper ctxHelper, BOSUuid companyId) {
        return ctxHelper.getBooleanParam("TM006", (IObjectPK)new ObjectUuidPK(companyId));
    }

    private boolean isFixCredit() {
        boolean flag = false;
        AccountPropertyInfo info = (AccountPropertyInfo)this.prmtAccountProperty.getData();
        int inValue = info.getProperty().getValue();
        if (inValue == 2 || inValue == 3) {
            flag = true;
        }
        return flag;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        boolean isMustCreFromApply = IvtModualUtils.getSysParam(null, (String)"TM036");
        if (isMustCreFromApply) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"mustCreFrominner"));
            SysUtil.abort();
        } else {
            super.actionAddNew_actionPerformed(e);
        }
    }
}

