/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AcctBankGroupEntriesInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryCollection;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryInfo;
import com.kingdee.eas.fm.fs.InnerAcctGroupFactory;
import com.kingdee.eas.fm.fs.InnerAcctGroupInfo;
import com.kingdee.eas.fm.fs.client.AbstractInnerAcctGroupEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class InnerAcctGroupEditUI
extends AbstractInnerAcctGroupEditUI {
    private static final Logger logger = CoreUIObject.getLogger(InnerAcctGroupEditUI.class);
    private static final String resourcePath = "com.kingdee.eas.fm.fs.client.InnerAccountResource";
    private static final String USAGE = "type";
    private static final String COMPANY = "applyUnit";
    private static final String BANK = "bank";
    private static final String ACCOUNT_BANK_NAME = "name";
    private static final String ACCOUNT_BANK = "innerAcct";
    private static final String ACCT_NUMBER = "acctNumber";
    protected KDBizPromptBox prmtInnerAcct;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public void onLoad() throws Exception {
        this.initMainTable();
        super.onLoad();
        this.setWorkButtonStatus();
    }

    private void setWorkButtonStatus() {
        this.actionSubmit.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPrint.setVisible(false);
        this.menuSubmitOption.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setWorkButtonStatus();
        this.loadEntriesFields();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeEntries();
    }

    private void storeEntries() {
        InnerAcctGroupEntryCollection coll = new InnerAcctGroupEntryCollection();
        for (int i = 0; i < this.kdtEntries.getRowCount3(); ++i) {
            InnerAcctGroupEntryInfo entryInfo = (InnerAcctGroupEntryInfo)this.kdtEntries.getRow(i).getUserObject();
            coll.add(entryInfo);
        }
        this.editData.getEntrys().clear();
        this.editData.getEntrys().addCollection(coll);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return InnerAcctGroupFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        InnerAcctGroupEntryInfo entryInfo = new InnerAcctGroupEntryInfo();
        entryInfo.setSeq(1);
        return entryInfo;
    }

    @Override
    protected IObjectValue createNewData() {
        InnerAcctGroupInfo objectValue = new InnerAcctGroupInfo();
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.getEntrys().add((InnerAcctGroupEntryInfo)this.createNewDetailData(this.kdtEntries));
        return objectValue;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionWorkFlowG.setVisible(false);
        this.actionWorkflowList.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionAddLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionRemoveLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    protected void initDataStatus() {
        super.initDataStatus();
        String oprtS = this.getOprtState();
        boolean canModifyline = oprtS.equals("ADDNEW") || oprtS.equals("EDIT");
        this.actionAddLine.setEnabled(canModifyline);
        this.actionRemoveLine.setEnabled(canModifyline);
        if (!this.oprtState.equals(OprtState.ADDNEW)) {
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
    }

    private void initMainTable() throws Exception {
        this.kdtEntries.checkParsed();
        this.prmtInnerAcct = new KDBizPromptBox();
        this.initAccountBank((IUIObject)this, this.prmtInnerAcct);
        this.prmtInnerAcct.setRequired(true);
        KDTDefaultCellEditor editorTurnInAcct = new KDTDefaultCellEditor((IKDEditor)this.prmtInnerAcct);
        this.kdtEntries.getColumn(ACCOUNT_BANK).setEditor((ICellEditor)editorTurnInAcct);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn(ACCOUNT_BANK).setRenderer((IBasicRender)avr);
        this.prmtInnerAcct.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    InnerAcctGroupEditUI.this.prmtAcctBank_dataChanged(e);
                }
                catch (Exception exc) {
                    InnerAcctGroupEditUI.this.handUIException(exc);
                }
            }
        });
        this.kdtEntries.getColumn(ACCOUNT_BANK_NAME).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(BANK).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(COMPANY).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(USAGE).getStyleAttributes().setLocked(true);
    }

    private void loadEntriesFields() {
        this.kdtEntries.removeRows();
        InnerAcctGroupEntryCollection coll = this.editData.getEntrys();
        for (int i = 0; i < coll.size(); ++i) {
            IRow row = this.kdtEntries.addRow();
            InnerAcctGroupEntryInfo info = coll.get(i);
            row.setUserObject((Object)info);
            InnerAccountInfo acctBank = info.getInnerAcct();
            row.getCell(ACCOUNT_BANK).setValue((Object)acctBank);
            if (acctBank == null) continue;
            row.getCell(ACCOUNT_BANK_NAME).setValue((Object)acctBank.getName());
            row.getCell(BANK).setValue((Object)acctBank.getClearingHouse());
            row.getCell(COMPANY).setValue((Object)acctBank.getCompany());
            row.getCell(USAGE).setValue((Object)acctBank.getType().getProperty());
            row.getCell(ACCT_NUMBER).setValue((Object)acctBank.getAcctNumber());
        }
    }

    public void initAccountBank(IUIObject coreui, KDBizPromptBox prmtAccountBank) throws Exception {
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
        entryViewInfo.setFilter(filter);
        prmtAccountBank.setEntityViewInfo(entryViewInfo);
        prmtAccountBank.setQueryInfo("com.kingdee.eas.fm.fs.F7InnerAccountQuery");
        prmtAccountBank.setDisplayFormat("$number$ $name$");
        prmtAccountBank.setEditFormat("$number$");
        prmtAccountBank.setCommitFormat("$number$;$name$");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("clearingHouse.name");
        sic.add("type.*");
        prmtAccountBank.setSelectorCollection(sic);
    }

    protected void prmtAcctBank_dataChanged(DataChangeEvent e) {
        int activeRowNumber = this.kdtEntries.getSelectManager().getActiveRowIndex();
        IRow row = this.kdtEntries.getRow2(activeRowNumber);
        InnerAccountInfo acctBank = (InnerAccountInfo)e.getNewValue();
        if (acctBank == null) {
            row.getCell(ACCOUNT_BANK_NAME).setValue(null);
            row.getCell(BANK).setValue(null);
            row.getCell(COMPANY).setValue(null);
            row.getCell(USAGE).setValue(null);
            row.getCell(ACCT_NUMBER).setValue(null);
        } else {
            row.getCell(ACCOUNT_BANK_NAME).setValue((Object)acctBank.getName());
            row.getCell(BANK).setValue((Object)acctBank.getClearingHouse());
            row.getCell(COMPANY).setValue((Object)acctBank.getCompany());
            row.getCell(USAGE).setValue((Object)acctBank.getType().getProperty());
            row.getCell(ACCT_NUMBER).setValue((Object)acctBank.getAcctNumber());
        }
    }

    private static Set getCompanyIds(String companyNum) throws Exception {
        if (FMHelper.isEmpty((String)companyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(120);
        sql.append("select fid from t_org_company where (");
        if (companyNum.indexOf(";") > 0) {
            String[] nums = companyNum.split(";");
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append(" (FNumber = '").append(nums[i].trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%') ");
            }
        } else {
            sql.append(" FNumber = '").append(companyNum.trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%'");
        }
        sql.append(" ) and FIsOnlyUnion =0 ");
        sql.append(" order by FLongNumber asc");
        IRowSet rs = null;
        try {
            rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), new Object[0]);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        HashSet<String> idSet = new HashSet<String>();
        while (rs.next()) {
            idSet.add(rs.getString("fid"));
        }
        if (idSet.size() > 0) {
            return idSet;
        }
        return null;
    }

    private void bandingUseObject(IRow row, AccountBankInfo acctBank) {
        AcctBankGroupEntriesInfo info = new AcctBankGroupEntriesInfo();
        info.setAcctBank(acctBank);
        if (acctBank != null) {
            row.setUserObject((Object)info);
        } else {
            row.setUserObject(null);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(ACCOUNT_BANK_NAME));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.innerAcct.*"));
        sic.add(new SelectorItemInfo("entrys.innerAcct.company.*"));
        sic.add(new SelectorItemInfo("entrys.innerAcct.clearingHouse.*"));
        sic.add(new SelectorItemInfo("entrys.innerAcct.type.*"));
        sic.add(new SelectorItemInfo("ctrlParam.*"));
        return sic;
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        boolean haveInnerAcct = false;
        for (int i = 0; i < this.kdtEntries.getRowCount3(); ++i) {
            InnerAcctGroupEntryInfo entryInfo = (InnerAcctGroupEntryInfo)this.kdtEntries.getRow(i).getUserObject();
            if (entryInfo == null || entryInfo.getInnerAcct() == null) continue;
            haveInnerAcct = true;
            break;
        }
        if (!haveInnerAcct) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"haveNotInnerAcct"));
            SysUtil.abort();
        }
    }

    public boolean isModify() {
        return super.isModify();
    }
}

