/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankPropertyEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IRptHandler;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPFormulaCollection;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fp.FPHelper;
import com.kingdee.eas.fm.fs.ISummaryLedger;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InacctTypeEnum;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SummaryLedgerFactory;
import com.kingdee.eas.fm.fs.client.InnerAvgAnalysisParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InnerAvgAnalysisHandler
implements IRptHandler {
    private String resourcePath = "com.kingdee.eas.fm.fs.client.AvgAnalysisResource";
    protected static final int AVG_QUARTER = 1;
    protected static final int AVG_MONTH = 0;
    protected static final int AVG_YEAR = 2;
    protected static final int AVG_DATE = 3;
    private InnerAvgAnalysisParam param;
    private int batchFetchCount = 800;

    public void initTable(KDTable tblMain, InnerAvgAnalysisParam param) throws BOSException {
        tblMain.checkParsed();
        FMClientHelper.clearTable((KDTable)tblMain);
        IRow headRow = tblMain.addHeadRow();
        tblMain.addColumn().setKey("company");
        headRow.getCell("company").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"ReqUnit"));
        tblMain.addColumn().setKey("innerAcctNum");
        headRow.getCell("innerAcctNum").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"innerAcctNum"));
        tblMain.addColumn().setKey("innerAccount");
        headRow.getCell("innerAccount").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"innerAccount"));
        tblMain.addColumn().setKey("type");
        headRow.getCell("type").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"type"));
        tblMain.addColumn().setKey("currency");
        headRow.getCell("currency").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Currency"));
        int beginYear = param.getBeginYear();
        int beginMonth = param.getBeginMonth() - 1;
        int endYear = param.getEndYear();
        int endMonth = param.getEndMonth() - 1;
        CycleTypeEnum cycleType = null;
        if (param.getAvgRptType() == 0) {
            cycleType = CycleTypeEnum.MONTH;
        } else if (param.getAvgRptType() == 1) {
            cycleType = CycleTypeEnum.QUARTER;
            beginMonth *= 3;
            endMonth *= 3;
        } else if (param.getAvgRptType() == 2) {
            cycleType = CycleTypeEnum.YEAR;
        }
        if (param.getAvgRptType() == 3) {
            tblMain.addColumn().setKey("AvgColum");
            headRow.getCell("AvgColum").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"103_InnerAvgAnalysisHandler"));
            tblMain.addColumn().setKey("dateColumn");
            headRow.getCell("dateColumn").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"104_InnerAvgAnalysisHandler"));
        } else if (param.getAvgRptType() == 0) {
            CycleRangeCollection coll = FPHelper.genCycleRanges((CycleTypeEnum)cycleType, (FPCycleIntervalEnum)FPCycleIntervalEnum.ONE, (int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
            int CycleRangeColSize = coll.size();
            for (int i = 0; i < CycleRangeColSize; ++i) {
                CycleRangeInfo info = coll.get(i);
                tblMain.addColumn().setKey(info.genDateKey());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
                headRow.getCell(info.genDateKey()).setValue((Object)df.format(info.getBeginDate()));
                tblMain.addColumn().setKey("dateColumn" + i + "");
                headRow.getCell("dateColumn" + i + "").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"104_InnerAvgAnalysisHandler"));
            }
        } else if (param.getAvgRptType() == 2) {
            CycleRangeCollection coll = FPHelper.genCycleRanges((CycleTypeEnum)cycleType, (FPCycleIntervalEnum)FPCycleIntervalEnum.ONE, (int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
            int CycleRangeColSize = coll.size();
            for (int i = 0; i < CycleRangeColSize; ++i) {
                CycleRangeInfo info = coll.get(i);
                tblMain.addColumn().setKey(info.genDateKey());
                SimpleDateFormat df = new SimpleDateFormat("yyyy");
                headRow.getCell(info.genDateKey()).setValue((Object)df.format(info.getBeginDate()));
                tblMain.addColumn().setKey("dateColumn" + i + "");
                headRow.getCell("dateColumn" + i + "").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"104_InnerAvgAnalysisHandler"));
            }
        } else {
            CycleRangeCollection coll = FPHelper.genCycleRanges((CycleTypeEnum)cycleType, (FPCycleIntervalEnum)FPCycleIntervalEnum.ONE, (int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
            int CycleRangeColSize = coll.size();
            for (int i = 0; i < CycleRangeColSize; ++i) {
                CycleRangeInfo info = coll.get(i);
                tblMain.addColumn().setKey(info.genDateKey());
                headRow.getCell(info.genDateKey()).setValue((Object)info.toString());
                tblMain.addColumn().setKey("dateColumn" + i + "");
                headRow.getCell("dateColumn" + i + "").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"104_InnerAvgAnalysisHandler"));
            }
        }
    }

    public void fillData(KDTable tblMain, InnerAvgAnalysisParam param, EntityViewInfo mainQuery, Map paramMap) throws SQLException, EASBizException, BOSException {
        int beginYear = param.getBeginYear();
        int beginMonth = param.getBeginMonth() - 1;
        int endYear = param.getEndYear();
        int endMonth = param.getEndMonth() - 1;
        CompanyOrgUnitCollection companyCol = null;
        String[] companyIds = param.getCompanyIds();
        companyCol = FMClientHelper.getCompanyOrgUnitCollection((String[])companyIds);
        CurrencyCollection currencyCollectionParam = (CurrencyCollection)paramMap.get("currencyCol");
        CurrencyCollection currencyCollection = new CurrencyCollection();
        if (param.getCurrencyId() != null) {
            for (int i = 0; i < currencyCollectionParam.size(); ++i) {
                CurrencyInfo currency = currencyCollectionParam.get(i);
                if (!currency.getId().toString().equals(param.getCurrencyId())) continue;
                currencyCollection.add(currency);
            }
        } else {
            currencyCollection = currencyCollectionParam;
        }
        FPFormulaCollection paramColl = new FPFormulaCollection();
        CycleTypeEnum cycleType = null;
        if (param.getAvgRptType() == 0) {
            cycleType = CycleTypeEnum.MONTH;
        } else if (param.getAvgRptType() == 1) {
            cycleType = CycleTypeEnum.QUARTER;
            beginMonth *= 3;
            endMonth *= 3;
        } else if (param.getAvgRptType() == 2) {
            cycleType = CycleTypeEnum.YEAR;
        }
        CycleRangeCollection coll = FPHelper.genCycleRanges((CycleTypeEnum)cycleType, (FPCycleIntervalEnum)FPCycleIntervalEnum.ONE, (int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
        if (param.getAvgRptType() == 3) {
            int colSize = this.setParamSupertCahcle(paramColl, coll, companyCol, currencyCollection, param);
            ISummaryLedger iSummaryLedger = SummaryLedgerFactory.getRemoteInstance();
            FPFormulaCollection resultcoll = null;
            resultcoll = iSummaryLedger.exec(InacctTypeEnum.INACCT, paramColl);
            int flag = 0;
            int rowCount = -1;
            Object[] params = null;
            String companyName = null;
            String innerNum = null;
            String innerName = null;
            String currencyName = null;
            String type = null;
            for (int i = 0; i < colSize; ++i) {
                params = resultcoll.get(i).getParams();
                companyName = (String)params[8];
                innerNum = (String)params[1];
                innerName = (String)params[9];
                currencyName = (String)params[10];
                type = (String)params[11];
                flag = 0;
                IRow row = tblMain.addRow();
                row.getCell("company").setValue((Object)companyName);
                row.getCell("innerAcctNum").setValue((Object)innerNum);
                row.getCell("innerAccount").setValue((Object)innerName);
                row.getCell("type").setValue((Object)type);
                row.getCell("currency").setValue((Object)currencyName);
                ++rowCount;
                BigDecimal avg = resultcoll.get(i).getResult();
                row.getCell(5).setValue((Object)avg);
                int inDay = this.getDayNum(param);
                row.getCell(6).setValue((Object)new Integer(inDay));
                tblMain.getColumn(6).getStyleAttributes().setNumberFormat("#,###");
                if (avg.compareTo(Constants.ZERO) != 0) {
                    ++flag;
                }
                if (flag != 0) continue;
                tblMain.removeRow(rowCount);
                --rowCount;
            }
        } else {
            int colSize = this.setParamSupertCahcle(paramColl, coll, companyCol, currencyCollection, param);
            ISummaryLedger iSummaryLedger = SummaryLedgerFactory.getRemoteInstance();
            FPFormulaCollection resultcoll = null;
            resultcoll = iSummaryLedger.exec(InacctTypeEnum.INACCT, paramColl);
            int flag = 0;
            int rowCount = -1;
            Object[] params = null;
            String companyName = null;
            String innerNum = null;
            String innerName = null;
            String currencyName = null;
            String type = null;
            int cycleRangeColSize = coll.size();
            for (int i = 0; i < colSize; ++i) {
                params = resultcoll.get(i * cycleRangeColSize).getParams();
                companyName = (String)params[8];
                innerNum = (String)params[1];
                innerName = (String)params[9];
                currencyName = (String)params[10];
                type = (String)params[11];
                flag = 0;
                IRow row = tblMain.addRow();
                row.getCell("company").setValue((Object)companyName);
                row.getCell("innerAcctNum").setValue((Object)innerNum);
                row.getCell("innerAccount").setValue((Object)innerName);
                row.getCell("type").setValue((Object)type);
                row.getCell("currency").setValue((Object)currencyName);
                ++rowCount;
                int c = 0;
                for (int j = 0; j < cycleRangeColSize; ++j) {
                    BigDecimal avg = resultcoll.get(i * cycleRangeColSize + j).getResult();
                    row.getCell(j + c + 5).setValue((Object)avg);
                    String strYearMon = coll.get(j).toString();
                    int inDay = this.getMonthDay(strYearMon, param);
                    row.getCell(j + ++c + 5).setValue((Object)new Integer(inDay));
                    tblMain.getColumn(j + c + 5).getStyleAttributes().setNumberFormat("#,###");
                    if (avg.compareTo(Constants.ZERO) == 0) continue;
                    ++flag;
                }
                if (flag != 0) continue;
                tblMain.removeRow(rowCount);
                --rowCount;
            }
        }
        tblMain.getColumn("company").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        tblMain.getColumn("innerAcctNum").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        tblMain.getColumn("innerAccount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        tblMain.getColumn("type").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        tblMain.getColumn("currency").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.setTotal(tblMain, param.getCurrencyId());
    }

    private int setParam(FPFormulaCollection paramColl, CycleRangeCollection coll, CompanyOrgUnitCollection companyCol, CurrencyCollection currencyCollection) throws BOSException {
        FPFormulaInfo paramInfo = null;
        int currencyColSize = currencyCollection.size();
        int companyColSize = companyCol.size();
        int cycleRangeColSize = coll.size();
        int size = companyColSize;
        CompanyOrgUnitInfo chCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        int count = 0;
        for (int i = 0; i < currencyColSize; ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            for (int j = 0; j < companyColSize; ++j) {
                CompanyOrgUnitInfo company = companyCol.get(j);
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
                    --size;
                    continue;
                }
                InnerAccountCollection inAccts = InnerAccountFactory.getRemoteInstance().getInnerAccountCollection("select * where isUsed=1 and closed=0 and applyunit.id='" + company.getId() + "'and company.id='" + chCompany.getId() + "'");
                for (int t = 0; t < inAccts.size(); ++t) {
                    InnerAccountInfo inner = inAccts.get(t);
                    for (int k = 0; k < cycleRangeColSize; ++k) {
                        CycleRangeInfo info = coll.get(k);
                        paramInfo = new FPFormulaInfo();
                        paramInfo.setParams(new Object[]{chCompany.getNumber(), null, AccountBankPropertyEnum.Current, inner.getNumber(), currency.getNumber(), info.getBeginDate(), info.getEndDate(), InAcctDataTypeEnum.WAY, company.getName(), inner.getName(), currency.getName()});
                        paramColl.add(paramInfo);
                    }
                    ++count;
                }
            }
        }
        return count;
    }

    private int setParamSupertCahcle(FPFormulaCollection paramColl, CycleRangeCollection coll, CompanyOrgUnitCollection companyCol, CurrencyCollection currencyCollection, InnerAvgAnalysisParam param) throws BOSException {
        this.param = param;
        FPFormulaInfo paramInfo = null;
        int currencyColSize = currencyCollection.size();
        int companyColSize = companyCol.size();
        int cycleRangeColSize = coll.size();
        int size = companyColSize;
        CompanyOrgUnitInfo chCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        int count = 0;
        InnerAccountCollection inAcctsAll = this.getInnerAccountCol(companyCol, chCompany);
        Map company2nAcct = this.groupByCompany(inAcctsAll);
        for (int i = 0; i < currencyColSize; ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            for (int j = 0; j < companyColSize; ++j) {
                CompanyOrgUnitInfo company = companyCol.get(j);
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
                    --size;
                    continue;
                }
                InnerAccountCollection inAccts = this.getInnerAccountFromMap(company2nAcct, company);
                for (int t = 0; t < inAccts.size(); ++t) {
                    InnerAccountInfo inner = inAccts.get(t);
                    if (param.getAvgRptType() == 3) {
                        paramInfo = new FPFormulaInfo();
                        paramInfo.setParams(new Object[]{chCompany.getNumber(), inner.getNumber(), currency.getNumber(), param.getFromDate(), param.getToDate(), InAcctDataTypeEnum.WAY, null, AccountBankPropertyEnum.Current, company.getName(), inner.getName(), currency.getName(), inner.getType().getName()});
                        paramColl.add(paramInfo);
                    } else {
                        for (int k = 0; k < cycleRangeColSize; ++k) {
                            CycleRangeInfo info = coll.get(k);
                            paramInfo = new FPFormulaInfo();
                            paramInfo.setParams(new Object[]{chCompany.getNumber(), inner.getNumber(), currency.getNumber(), info.getBeginDate(), info.getEndDate(), InAcctDataTypeEnum.WAY, null, AccountBankPropertyEnum.Current, company.getName(), inner.getName(), currency.getName(), inner.getType().getName()});
                            paramColl.add(paramInfo);
                        }
                    }
                    ++count;
                }
            }
        }
        return count;
    }

    private InnerAccountCollection getInnerAccountFromMap(Map company2nAcct, CompanyOrgUnitInfo company) {
        InnerAccountCollection returnValue = null;
        String applyUnitId = company.getId().toString();
        returnValue = company2nAcct.get(applyUnitId) != null ? (InnerAccountCollection)((Object)company2nAcct.get(applyUnitId)) : new InnerAccountCollection();
        return returnValue;
    }

    private Map groupByCompany(InnerAccountCollection inAccts) {
        int size = inAccts.size();
        HashMap<String, InnerAccountCollection> hnReturn = new HashMap<String, InnerAccountCollection>();
        InnerAccountInfo innercct = null;
        String applyUnitId = "";
        for (int i = 0; i < size; ++i) {
            innercct = inAccts.get(i);
            applyUnitId = innercct.getApplyUnit().getId().toString();
            if (hnReturn.get(applyUnitId) != null) {
                ((InnerAccountCollection)((Object)hnReturn.get(applyUnitId))).add(innercct);
                continue;
            }
            InnerAccountCollection iac = new InnerAccountCollection();
            iac.add(innercct);
            hnReturn.put(applyUnitId, iac);
        }
        return hnReturn;
    }

    private InnerAccountCollection getInnerAccountCol(CompanyOrgUnitCollection companyCol, CompanyOrgUnitInfo chCompany) throws BOSException {
        InnerAccountCollection returnInnerAccCol = new InnerAccountCollection();
        List fetchGroup = this.getGroupMap(companyCol, chCompany);
        InnerAccountCollection iacTmp = this.getInnerAccountCollectionFromSetList(fetchGroup, chCompany);
        returnInnerAccCol.addCollection(iacTmp);
        return returnInnerAccCol;
    }

    private InnerAccountCollection getInnerAccountCollectionFromSetList(List fetchGroup, CompanyOrgUnitInfo chCompany) throws BOSException {
        InnerAccountCollection iac = new InnerAccountCollection();
        for (int i = 0; i < fetchGroup.size(); ++i) {
            Set ids = (Set)fetchGroup.get(i);
            iac.addCollection(this.getInnerAccountCollectionBySet(ids, chCompany));
        }
        return iac;
    }

    private List getGroupMap(CompanyOrgUnitCollection companyCol, CompanyOrgUnitInfo chCompany) {
        ArrayList returnList = new ArrayList();
        HashSet<String> companyIDSet = new HashSet<String>();
        int size = companyCol.size();
        for (int i = 0; i < size; ++i) {
            CompanyOrgUnitInfo company = companyCol.get(i);
            if (i % this.batchFetchCount == 0) {
                companyIDSet = new HashSet();
                returnList.add(companyIDSet);
            }
            companyIDSet.add(company.getId().toString());
        }
        return returnList;
    }

    private InnerAccountCollection getInnerAccountCollectionBySet(Set companyIDs, CompanyOrgUnitInfo chCompany) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("type.*"));
        evi.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("applyunit.id", (Object)companyIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)chCompany.getId()));
        if (!FMHelper.isEmpty((Object)this.param)) {
            if (!FMHelper.isEmpty((Object[])this.param.getInnerAccountIds())) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])this.param.getInnerAccountIds()), CompareType.INCLUDE));
            }
            if (!FMHelper.isEmpty((Object[])this.param.getAccountPropertyIds())) {
                filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)FMHelper.asSet((String[])this.param.getAccountPropertyIds()), CompareType.INCLUDE));
            }
        }
        evi.setFilter(filter);
        return InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(evi);
    }

    private void setTotal(KDTable tblMain, String currencyId) {
        for (int i = 0; i < tblMain.getColumnCount(); ++i) {
            tblMain.getColumn(i).setMergeable(false);
        }
        tblMain.getColumn("currency").setGroup(true);
        tblMain.getColumn("currency").setStat(true);
        tblMain.getGroupManager().setOrientation(1);
        IRow row0 = tblMain.getGroupManager().getStatRowTemplate(-1);
        row0.getStyleAttributes().setHided(true);
        IRow row1 = tblMain.getGroupManager().getStatRowTemplate(0);
        row1.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row1.getCell(0).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"MoneyTotal"));
        String numberFtm = currencyId == null ? FMClientHelper.getNumberFtm((int)2) : FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
        for (int i = 5; i < tblMain.getColumnCount(); ++i) {
            row1.getCell(i).setExpressions("SUM");
            row1.getCell(i).getStyleAttributes().setNumberFormat(numberFtm);
            row1.getCell(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (i % 2 == 1) continue;
            row1.getCell(i).getStyleAttributes().setNumberFormat("#,###");
        }
        tblMain.getGroupManager().group();
    }

    public void setCurrencyFormat(KDTable tblMain, InnerAvgAnalysisParam param) {
        String numberFtm = param.getCurrencyId() == null ? FMClientHelper.getNumberFtm((int)2) : FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)param.getCurrencyId()));
        for (int i = 5; i < tblMain.getColumnCount(); ++i) {
            tblMain.getColumn(i).getStyleAttributes().setNumberFormat(numberFtm);
            tblMain.getColumn(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    private int getMonthDay(String strYearMon, InnerAvgAnalysisParam param) {
        Date yearMon = null;
        try {
            yearMon = FMHelper.getDateFormat().parse(strYearMon);
        }
        catch (ParseException e) {
            Logger.error((Throwable)e);
        }
        int dayOfM = 0;
        if (param.getAvgRptType() == 1) {
            int inYear = Integer.parseInt(strYearMon.substring(0, 4));
            int inMon = Integer.parseInt(strYearMon.substring(7, 8));
            switch (inMon) {
                case 1: {
                    if (inYear % 4 == 0 && inYear % 100 != 0 || inYear % 400 == 0) {
                        dayOfM = 91;
                        break;
                    }
                    dayOfM = 90;
                    break;
                }
                case 2: {
                    dayOfM = 91;
                    break;
                }
                case 3: {
                    dayOfM = 92;
                    break;
                }
                case 4: {
                    dayOfM = 92;
                }
            }
        } else if (param.getAvgRptType() == 0) {
            int inYearM = DateTimeUtils.getYear((Date)yearMon);
            int inMonM = DateTimeUtils.getMonth((Date)yearMon);
            Calendar day = Calendar.getInstance();
            day.set(inYearM, inMonM, 0);
            dayOfM = day.get(5);
        } else {
            int inYearY = DateTimeUtils.getYear((Date)yearMon);
            dayOfM = inYearY % 4 == 0 && inYearY % 100 != 0 || inYearY % 400 == 0 ? 366 : 365;
        }
        return dayOfM;
    }

    private int getDayNum(InnerAvgAnalysisParam param) {
        int day = 0;
        long daTime = param.getToDate().getTime() - param.getFromDate().getTime();
        day = Integer.parseInt(String.valueOf(daTime / 1000L / 60L / 60L / 24L + 1L));
        return day;
    }
}

