/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.InnerFrozenDepositFactory;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class InnerFrozenBillHandler {
    private static final String resourcePath = "com.kingdee.eas.fm.fs.SettlementBillUI";
    private static final int ROUND = 4;
    private Map balanceMap = new HashMap();
    private Map frozenBalanceMap = new HashMap();

    public static InnerFrozenBillHandler create() {
        return new InnerFrozenBillHandler();
    }

    protected BigDecimal getBalanceValue(CurrencyInfo currencyInfo, InnerAccountInfo innerAcctInfo) throws EASBizException, BOSException {
        if (currencyInfo == null || innerAcctInfo == null) {
            return Constants.ZERO;
        }
        String key = innerAcctInfo.getId().toString() + currencyInfo.getId().toString();
        if (this.balanceMap.containsKey(key)) {
            return (BigDecimal)this.balanceMap.get(key);
        }
        ObjectUuidPK chCompanyPk = new ObjectUuidPK(innerAcctInfo.getCompany().getId());
        CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
        BankInfo clearingHouse = BankFactory.getRemoteInstance().getClearingHouse(chCompany.getId().toString());
        Date unSettleDate = clearingHouse.getSettleDate();
        if (unSettleDate == null) {
            return Constants.ZERO;
        }
        BigDecimal balance = InAcctFactory.getRemoteInstance().inAcct(chCompany.getNumber(), innerAcctInfo.getNumber(), currencyInfo.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
        if (balance == null) {
            return Constants.ZERO;
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        this.balanceMap.put(key, balance);
        return balance;
    }

    protected BigDecimal getFrozenBalanceValue(String currencyId, String innerAcctId) throws EASBizException, BOSException {
        if (currencyId == null || innerAcctId == null) {
            return Constants.ZERO;
        }
        BigDecimal fozenBalance = InnerFrozenDepositFactory.getRemoteInstance().getTotalFrozenAmt(innerAcctId, currencyId);
        if (fozenBalance == null) {
            return Constants.ZERO;
        }
        return fozenBalance;
    }

    protected int getFrozenNumber(String id, String currencyID) throws EASBizException, BOSException {
        int frozenNumber = InnerFrozenDepositFactory.getRemoteInstance().getAutoNumber(id, currencyID);
        return frozenNumber;
    }

    public void setInnerAcctF7(KDBizPromptBox f7InnerAccount, boolean isCUControl, String companyId) throws EASBizException, BOSException {
        EntityViewInfo info = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
        if (isCUControl) {
            if (FMHelper.isEmpty((String)companyId)) {
                companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            }
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        }
        info.setFilter(filter);
        f7InnerAccount.setEntityViewInfo(info);
    }
}

